/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class TriggerCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_PRIMED = new SimpleCommandExceptionType((Message)Component.translatable("commands.trigger.failed.unprimed"));
    private static final SimpleCommandExceptionType ERROR_INVALID_OBJECTIVE = new SimpleCommandExceptionType((Message)Component.translatable("commands.trigger.failed.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("trigger").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).suggests((context, builder) -> TriggerCommand.suggestObjectives((CommandSourceStack)context.getSource(), builder)).executes(context -> TriggerCommand.simpleTrigger((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective")))).then(Commands.literal("add").then(Commands.argument("value", IntegerArgumentType.integer()).executes(context -> TriggerCommand.addValue((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(Commands.literal("set").then(Commands.argument("value", IntegerArgumentType.integer()).executes(context -> TriggerCommand.setValue((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))));
    }

    public static CompletableFuture<Suggestions> suggestObjectives(CommandSourceStack source, SuggestionsBuilder builder) {
        Entity scoreHolder = source.getEntity();
        ArrayList list = Lists.newArrayList();
        if (scoreHolder != null) {
            ServerScoreboard scoreboard = source.getServer().getScoreboard();
            for (Objective objective : scoreboard.getObjectives()) {
                ReadOnlyScoreInfo readOnlyScoreInfo;
                if (objective.getCriteria() != ObjectiveCriteria.TRIGGER || (readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective)) == null || readOnlyScoreInfo.isLocked()) continue;
                list.add(objective.getName());
            }
        }
        return SharedSuggestionProvider.suggest(list, builder);
    }

    private static int addValue(CommandSourceStack source, ServerPlayer player, Objective objective, int amount) throws CommandSyntaxException {
        ScoreAccess scoreAccess = TriggerCommand.getScore(source.getServer().getScoreboard(), player, objective);
        int i = scoreAccess.add(amount);
        source.sendSuccess(() -> Component.translatable("commands.trigger.add.success", objective.getFormattedDisplayName(), amount), true);
        return i;
    }

    private static int setValue(CommandSourceStack source, ServerPlayer player, Objective objective, int value) throws CommandSyntaxException {
        ScoreAccess scoreAccess = TriggerCommand.getScore(source.getServer().getScoreboard(), player, objective);
        scoreAccess.set(value);
        source.sendSuccess(() -> Component.translatable("commands.trigger.set.success", objective.getFormattedDisplayName(), value), true);
        return value;
    }

    private static int simpleTrigger(CommandSourceStack source, ServerPlayer player, Objective objective) throws CommandSyntaxException {
        ScoreAccess scoreAccess = TriggerCommand.getScore(source.getServer().getScoreboard(), player, objective);
        int i = scoreAccess.add(1);
        source.sendSuccess(() -> Component.translatable("commands.trigger.simple.success", objective.getFormattedDisplayName()), true);
        return i;
    }

    private static ScoreAccess getScore(Scoreboard scoreboard, ScoreHolder scoreHolder, Objective objective) throws CommandSyntaxException {
        if (objective.getCriteria() != ObjectiveCriteria.TRIGGER) {
            throw ERROR_INVALID_OBJECTIVE.create();
        }
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
        if (readOnlyScoreInfo == null || readOnlyScoreInfo.isLocked()) {
            throw ERROR_NOT_PRIMED.create();
        }
        ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
        scoreAccess.lock();
        return scoreAccess;
    }
}

