/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2;

public class WorldBorderCommand {
    private static final SimpleCommandExceptionType ERROR_SAME_CENTER = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_SIZE = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.big", 5.9999968E7));
    private static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_TIME = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_DISTANCE = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.damage.amount.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("worldborder").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(Commands.literal("add").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), ((CommandSourceStack)commandcontext.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), ((CommandSourceStack)commandcontext.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), ((CommandSourceStack)commandcontext.getSource()).getLevel().getWorldBorder().getLerpRemainingTime() + (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(Commands.literal("set").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setSize((CommandSourceStack)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(Commands.literal("center").then(Commands.argument("pos", Vec2Argument.vec2()).executes(commandcontext -> WorldBorderCommand.setCenter((CommandSourceStack)commandcontext.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)commandcontext, "pos")))))).then(((LiteralArgumentBuilder)Commands.literal("damage").then(Commands.literal("amount").then(Commands.argument("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> WorldBorderCommand.setDamageAmount((CommandSourceStack)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"damagePerBlock")))))).then(Commands.literal("buffer").then(Commands.argument("distance", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> WorldBorderCommand.setDamageBuffer((CommandSourceStack)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"distance"))))))).then(Commands.literal("get").executes(commandcontext -> WorldBorderCommand.getSize((CommandSourceStack)commandcontext.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("warning").then(Commands.literal("distance").then(Commands.argument("distance", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setWarningDistance((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"distance")))))).then(Commands.literal("time").then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> WorldBorderCommand.setWarningTime((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"))))))));
    }

    private static int setDamageBuffer(CommandSourceStack source, float distance) throws CommandSyntaxException {
        WorldBorder worldborder = source.getLevel().getWorldBorder();
        if (worldborder.getDamageSafeZone() == (double)distance) {
            throw ERROR_SAME_DAMAGE_BUFFER.create();
        }
        worldborder.setDamageSafeZone(distance);
        source.sendSuccess(() -> Component.translatable("commands.worldborder.damage.buffer.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(distance))), true);
        return (int)distance;
    }

    private static int setDamageAmount(CommandSourceStack source, float damagePerBlock) throws CommandSyntaxException {
        WorldBorder worldborder = source.getLevel().getWorldBorder();
        if (worldborder.getDamagePerBlock() == (double)damagePerBlock) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create();
        }
        worldborder.setDamagePerBlock(damagePerBlock);
        source.sendSuccess(() -> Component.translatable("commands.worldborder.damage.amount.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(damagePerBlock))), true);
        return (int)damagePerBlock;
    }

    private static int setWarningTime(CommandSourceStack source, int time) throws CommandSyntaxException {
        WorldBorder worldborder = source.getLevel().getWorldBorder();
        if (worldborder.getWarningTime() == time) {
            throw ERROR_SAME_WARNING_TIME.create();
        }
        worldborder.setWarningTime(time);
        source.sendSuccess(() -> Component.translatable("commands.worldborder.warning.time.success", time), true);
        return time;
    }

    private static int setWarningDistance(CommandSourceStack source, int distance) throws CommandSyntaxException {
        WorldBorder worldborder = source.getLevel().getWorldBorder();
        if (worldborder.getWarningBlocks() == distance) {
            throw ERROR_SAME_WARNING_DISTANCE.create();
        }
        worldborder.setWarningBlocks(distance);
        source.sendSuccess(() -> Component.translatable("commands.worldborder.warning.distance.success", distance), true);
        return distance;
    }

    private static int getSize(CommandSourceStack source) {
        double d0 = source.getLevel().getWorldBorder().getSize();
        source.sendSuccess(() -> Component.translatable("commands.worldborder.get", String.format(Locale.ROOT, "%.0f", d0)), false);
        return Mth.floor(d0 + 0.5);
    }

    private static int setCenter(CommandSourceStack source, Vec2 pos) throws CommandSyntaxException {
        WorldBorder worldborder = source.getLevel().getWorldBorder();
        if (worldborder.getCenterX() == (double)pos.x && worldborder.getCenterZ() == (double)pos.y) {
            throw ERROR_SAME_CENTER.create();
        }
        if ((double)Math.abs(pos.x) <= 2.9999984E7 && (double)Math.abs(pos.y) <= 2.9999984E7) {
            worldborder.setCenter(pos.x, pos.y);
            source.sendSuccess(() -> Component.translatable("commands.worldborder.center.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(pos.x)), String.format(Locale.ROOT, "%.2f", Float.valueOf(pos.y))), true);
            return 0;
        }
        throw ERROR_TOO_FAR_OUT.create();
    }

    private static int setSize(CommandSourceStack source, double distance, long time) throws CommandSyntaxException {
        WorldBorder worldborder = source.getLevel().getWorldBorder();
        double d1 = worldborder.getSize();
        if (d1 == distance) {
            throw ERROR_SAME_SIZE.create();
        }
        if (distance < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (distance > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        if (time > 0L) {
            worldborder.lerpSizeBetween(d1, distance, time);
            if (distance > d1) {
                source.sendSuccess(() -> Component.translatable("commands.worldborder.set.grow", String.format(Locale.ROOT, "%.1f", distance), Long.toString(time / 1000L)), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.worldborder.set.shrink", String.format(Locale.ROOT, "%.1f", distance), Long.toString(time / 1000L)), true);
            }
        } else {
            worldborder.setSize(distance);
            source.sendSuccess(() -> Component.translatable("commands.worldborder.set.immediate", String.format(Locale.ROOT, "%.1f", distance)), true);
        }
        return (int)(distance - d1);
    }
}

