/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkHolder
extends GenerationChunkHolder
implements ChunkSystemChunkHolder {
    public static final ChunkResult<LevelChunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    private static final CompletableFuture<ChunkResult<LevelChunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private final LevelHeightAccessor levelHeightAccessor;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter;
    private final BitSet skyChangedLightSectionFilter;
    private final LevelLightEngine lightEngine;
    public final PlayerProvider playerProvider;
    private NewChunkHolder newChunkHolder;
    private static final ServerPlayer[] EMPTY_PLAYER_ARRAY = new ServerPlayer[0];
    private final ReferenceList<ServerPlayer> playersSentChunkTo = new ReferenceList<ServerPlayer>(EMPTY_PLAYER_ARRAY);

    private ChunkMap getChunkMap() {
        return (ChunkMap)this.playerProvider;
    }

    @Override
    public final NewChunkHolder moonrise$getRealChunkHolder() {
        return this.newChunkHolder;
    }

    @Override
    public final void moonrise$setRealChunkHolder(NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
    }

    @Override
    public final void moonrise$addReceivedChunk(ServerPlayer player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + WorldUtil.getWorldName(this.getChunkMap().level) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final void moonrise$removeReceivedChunk(ServerPlayer player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + WorldUtil.getWorldName(this.getChunkMap().level) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent(ServerPlayer to) {
        return this.playersSentChunkTo.contains(to);
    }

    @Override
    public final List<ServerPlayer> moonrise$getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<ServerPlayer> ret = new ArrayList<ServerPlayer>();
        ServerPlayer[] raw = this.playersSentChunkTo.getRawDataUnchecked();
        int len = this.playersSentChunkTo.size();
        for (int i = 0; i < len; ++i) {
            ServerPlayer player = raw[i];
            if (onlyOnWatchDistanceEdge && !this.getChunkMap().level.moonrise$getPlayerChunkLoader().isChunkSent(player, this.pos.x, this.pos.z, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    @Override
    public final LevelChunk moonrise$getFullChunk() {
        ChunkAccess chunkAccess;
        if (this.newChunkHolder.isFullChunkReady() && (chunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            return levelChunk;
        }
        return null;
    }

    private boolean isRadiusLoaded(int radius) {
        ChunkHolderManager manager = this.getChunkMap().level.moonrise$getChunkTaskScheduler().chunkHolderManager;
        ChunkPos pos = this.pos;
        int chunkX = pos.x;
        int chunkZ = pos.z;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                NewChunkHolder holder;
                if ((dx | dz) == 0 || (holder = manager.getChunkHolder(dx + chunkX, dz + chunkZ)) != null && holder.isFullChunkReady()) continue;
                return false;
            }
        }
        return true;
    }

    public ChunkHolder(ChunkPos pos, int level, LevelHeightAccessor world, LevelLightEngine lightingProvider, LevelChangeListener levelUpdateListener, PlayerProvider playersWatchingChunkProvider) {
        super(pos);
        this.blockChangedLightSectionFilter = new BitSet();
        this.skyChangedLightSectionFilter = new BitSet();
        this.levelHeightAccessor = world;
        this.lightEngine = lightingProvider;
        this.playerProvider = playersWatchingChunkProvider;
        this.setTicketLevel(level);
        this.changedBlocksPerSection = new ShortSet[world.getSectionsCount()];
    }

    public LevelChunk getFullChunkNow() {
        if (!this.newChunkHolder.isFullChunkReady()) {
            return null;
        }
        return this.getFullChunkNowUnchecked();
    }

    public LevelChunk getFullChunkNowUnchecked() {
        return (LevelChunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getEntityTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getFullChunkFuture() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final LevelChunk getTickingChunk() {
        ChunkAccess chunkAccess;
        if (this.newChunkHolder.isTickingReady() && (chunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            return levelChunk;
        }
        return null;
    }

    @Nullable
    public LevelChunk getChunkToSend() {
        LevelChunk ret = this.moonrise$getFullChunk();
        if (ret != null && this.isRadiusLoaded(1)) {
            return ret;
        }
        return null;
    }

    public CompletableFuture<?> getSendSyncFuture() {
        throw new UnsupportedOperationException();
    }

    public void addSendDependency(CompletableFuture<?> postProcessingFuture) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> getSaveSyncFuture() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadyForSaving() {
        throw new UnsupportedOperationException();
    }

    private void addSaveDependency(CompletableFuture<?> savingFuture) {
        throw new UnsupportedOperationException();
    }

    public void blockChanged(BlockPos pos) {
        LevelChunk chunk;
        LevelChunk levelChunk = chunk = this.playersSentChunkTo.size() == 0 ? null : this.getChunkToSend();
        if (chunk != null) {
            int i = this.levelHeightAccessor.getSectionIndex(pos.getY());
            if (i < 0 || i >= this.changedBlocksPerSection.length) {
                return;
            }
            if (this.changedBlocksPerSection[i] == null) {
                this.hasChangedSections = true;
                this.changedBlocksPerSection[i] = new ShortOpenHashSet();
            }
            this.changedBlocksPerSection[i].add(SectionPos.sectionRelativePos(pos));
        }
    }

    public void sectionLightChanged(LightLayer lightType, int y) {
        ChunkAccess ichunkaccess = this.getChunkIfPresent(ChunkStatus.INITIALIZE_LIGHT);
        if (ichunkaccess != null) {
            ichunkaccess.setUnsaved(true);
            LevelChunk chunk = this.getChunkToSend();
            if (chunk != null) {
                int j = this.lightEngine.getMinLightSection();
                int k = this.lightEngine.getMaxLightSection();
                if (y >= j && y <= k) {
                    int l = y - j;
                    if (lightType == LightLayer.SKY) {
                        this.skyChangedLightSectionFilter.set(l);
                    } else {
                        this.blockChangedLightSectionFilter.set(l);
                    }
                }
            }
        }
    }

    public void broadcastChanges(LevelChunk chunk) {
        if (this.hasChangedSections || !this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            List<ServerPlayer> list;
            Level world = chunk.getLevel();
            if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
                list = this.moonrise$getPlayers(true);
                if (!list.isEmpty()) {
                    ClientboundLightUpdatePacket packetplayoutlightupdate = new ClientboundLightUpdatePacket(chunk.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                    this.broadcast(list, packetplayoutlightupdate);
                }
                this.skyChangedLightSectionFilter.clear();
                this.blockChangedLightSectionFilter.clear();
            }
            if (this.hasChangedSections) {
                list = this.moonrise$getPlayers(false);
                for (int i = 0; i < this.changedBlocksPerSection.length; ++i) {
                    ShortSet shortset = this.changedBlocksPerSection[i];
                    if (shortset == null) continue;
                    this.changedBlocksPerSection[i] = null;
                    if (list.isEmpty()) continue;
                    int j = this.levelHeightAccessor.getSectionYFromSectionIndex(i);
                    SectionPos sectionposition = SectionPos.of(chunk.getPos(), j);
                    if (shortset.size() == 1) {
                        BlockPos blockposition = sectionposition.relativeToBlockPos(shortset.iterator().nextShort());
                        BlockState iblockdata = world.getBlockState(blockposition);
                        this.broadcast(list, new ClientboundBlockUpdatePacket(blockposition, iblockdata));
                        this.broadcastBlockEntityIfNeeded(list, world, blockposition, iblockdata);
                        continue;
                    }
                    LevelChunkSection chunksection = chunk.getSection(i);
                    ClientboundSectionBlocksUpdatePacket packetplayoutmultiblockchange = new ClientboundSectionBlocksUpdatePacket(sectionposition, shortset, chunksection);
                    this.broadcast(list, packetplayoutmultiblockchange);
                    List<ServerPlayer> finalList = list;
                    packetplayoutmultiblockchange.runUpdates((blockposition1, iblockdata1) -> this.broadcastBlockEntityIfNeeded(finalList, world, (BlockPos)blockposition1, (BlockState)iblockdata1));
                }
                this.hasChangedSections = false;
            }
        }
    }

    private void broadcastBlockEntityIfNeeded(List<ServerPlayer> players, Level world, BlockPos pos, BlockState state) {
        if (state.hasBlockEntity()) {
            this.broadcastBlockEntity(players, world, pos);
        }
    }

    private void broadcastBlockEntity(List<ServerPlayer> players, Level world, BlockPos pos) {
        Packet<ClientGamePacketListener> packet;
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity != null && (packet = tileentity.getUpdatePacket()) != null) {
            this.broadcast(players, packet);
        }
    }

    private void broadcast(List<ServerPlayer> players, Packet<?> packet) {
        players.forEach(entityplayer -> entityplayer.connection.send(packet));
    }

    @Override
    public int getTicketLevel() {
        return this.newChunkHolder.getTicketLevel();
    }

    @Override
    public int getQueueLevel() {
        throw new UnsupportedOperationException();
    }

    private void setQueueLevel(int level) {
        throw new UnsupportedOperationException();
    }

    public void setTicketLevel(int level) {
    }

    private void scheduleFullChunkPromotion(ChunkMap chunkLoadingManager, CompletableFuture<ChunkResult<LevelChunk>> chunkFuture, Executor executor, FullChunkStatus target) {
        throw new UnsupportedOperationException();
    }

    private void demoteFullChunk(ChunkMap chunkLoadingManager, FullChunkStatus target) {
        throw new UnsupportedOperationException();
    }

    protected void updateFutures(ChunkMap chunkLoadingManager, Executor executor) {
        throw new UnsupportedOperationException();
    }

    public boolean wasAccessibleSinceLastSave() {
        throw new UnsupportedOperationException();
    }

    public void refreshAccessibility() {
        throw new UnsupportedOperationException();
    }

    public static interface PlayerProvider {
        public List<ServerPlayer> getPlayers(ChunkPos var1, boolean var2);
    }

    @FunctionalInterface
    public static interface LevelChangeListener {
        public void onLevelChange(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }
}

