/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public abstract class DistanceManager
implements ChunkSystemDistanceManager,
ChunkTickDistanceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    private long ticketTickCounter;
    private final PositionCountingAreaMap<ServerPlayer> spawnChunkTracker = new PositionCountingAreaMap();

    protected DistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
        Objects.requireNonNull(mainThreadExecutor);
        ProcessorHandle<Runnable> mailbox = ProcessorHandle.of("player ticket throttler", mainThreadExecutor::execute);
        ChunkTaskPriorityQueueSorter chunktaskqueuesorter = new ChunkTaskPriorityQueueSorter((List<ProcessorHandle<?>>)ImmutableList.of(mailbox), workerExecutor, 4);
    }

    public ChunkHolderManager getChunkHolderManager() {
        return this.moonrise$getChunkMap().level.moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Override
    public final void moonrise$addPlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.add(player, pos.x(), pos.z(), 8);
    }

    @Override
    public final void moonrise$removePlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(ServerPlayer player, SectionPos oldPos, SectionPos newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.x(), newPos.z(), 8);
        }
    }

    protected void purgeStaleTickets() {
        this.getChunkHolderManager().tick();
    }

    private static int getTicketLevelAt(SortedArraySet<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.first().getTicketLevel() : ChunkLevel.MAX_LEVEL + 1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract ChunkHolder getChunk(long var1);

    @Nullable
    protected abstract ChunkHolder updateChunkScheduling(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean runAllUpdates(ChunkMap chunkLoadingManager) {
        return this.getChunkHolderManager().processTicketUpdates();
    }

    boolean addTicket(long i, Ticket<?> ticket) {
        return this.getChunkHolderManager().addTicketAtLevel(ticket.getType(), i, ticket.getTicketLevel(), ticket.key);
    }

    boolean removeTicket(long i, Ticket<?> ticket) {
        return this.getChunkHolderManager().removeTicketAtLevel(ticket.getType(), i, ticket.getTicketLevel(), ticket.key);
    }

    public <T> void addTicket(TicketType<T> type, ChunkPos pos, int level, T argument) {
        this.addTicket(pos.toLong(), new Ticket<T>(type, level, argument));
    }

    public <T> void removeTicket(TicketType<T> type, ChunkPos pos, int level, T argument) {
        Ticket<T> ticket = new Ticket<T>(type, level, argument);
        this.removeTicket(pos.toLong(), ticket);
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int radius, T argument) {
        this.addRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkPos chunkcoordintpair, int i, T t0) {
        return this.getChunkHolderManager().addTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.byStatus(FullChunkStatus.FULL) - i, t0);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int radius, T argument) {
        this.removeRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkPos chunkcoordintpair, int i, T t0) {
        return this.getChunkHolderManager().removeTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.byStatus(FullChunkStatus.FULL) - i, t0);
    }

    private SortedArraySet<Ticket<?>> getTickets(long position) {
        throw new UnsupportedOperationException();
    }

    protected void updateChunkForced(ChunkPos pos, boolean forced) {
        if (forced) {
            this.getChunkHolderManager().addTicketAtLevel(TicketType.FORCED, pos, ChunkMap.FORCED_TICKET_LEVEL, pos);
        } else {
            this.getChunkHolderManager().removeTicketAtLevel(TicketType.FORCED, pos, ChunkMap.FORCED_TICKET_LEVEL, pos);
        }
    }

    public void addPlayer(SectionPos pos, ServerPlayer player) {
        ChunkPos chunkcoordintpair = pos.chunk();
        long i = chunkcoordintpair.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent(i, j -> new ObjectOpenHashSet())).add((Object)player);
    }

    public void removePlayer(SectionPos pos, ServerPlayer player) {
        ChunkPos chunkcoordintpair = pos.chunk();
        long i = chunkcoordintpair.toLong();
        ObjectSet objectset = (ObjectSet)this.playersPerChunk.get(i);
        if (objectset == null) {
            return;
        }
        if (objectset != null) {
            objectset.remove((Object)player);
        }
        if (objectset == null || objectset.isEmpty()) {
            this.playersPerChunk.remove(i);
        }
    }

    private int getPlayerTicketLevel() {
        throw new UnsupportedOperationException();
    }

    public boolean inEntityTickingRange(long chunkPos) {
        NewChunkHolder chunkHolder = this.getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean inBlockTickingRange(long chunkPos) {
        NewChunkHolder chunkHolder = this.getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    protected String getTicketDebugString(long pos) {
        return this.getChunkHolderManager().getTicketDebugString(pos);
    }

    protected void updatePlayerTickets(int viewDistance) {
        this.moonrise$getChunkMap().setServerViewDistance(viewDistance);
    }

    public void updateSimulationDistance(int simulationDistance) {
        this.moonrise$getChunkMap().level.moonrise$getPlayerChunkLoader().setTickDistance(simulationDistance);
    }

    public int getNaturalSpawnChunkCount() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    public boolean hasPlayersNearby(long chunkPos) {
        return this.spawnChunkTracker.hasObjectsNear(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos));
    }

    public String getDebugStatus() {
        return "No DistanceManager stats available";
    }

    private void dumpTickets(String path) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    TickingTracker tickingTracker() {
        throw new UnsupportedOperationException();
    }

    public void removeTicketsOnClosing() {
    }

    public boolean hasTickets() {
        throw new UnsupportedOperationException();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.getChunkHolderManager().removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    private class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected FixedPlayerDistanceChunkTracker(int i) {
            super(i + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = i;
            this.chunks.defaultReturnValue((byte)(i + 2));
        }

        @Override
        protected int getLevel(long id) {
            return this.chunks.get(id);
        }

        @Override
        protected void setLevel(long id, int level) {
            byte b0 = level > this.maxDistance ? this.chunks.remove(id) : this.chunks.put(id, (byte)level);
            this.onLevelChange(id, b0, level);
        }

        protected void onLevelChange(long pos, int oldDistance, int distance) {
        }

        @Override
        protected int getLevelFromSource(long id) {
            return this.havePlayer(id) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long chunkPos) {
            ObjectSet objectset = (ObjectSet)DistanceManager.this.playersPerChunk.get(chunkPos);
            return objectset != null && !objectset.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }

        private void dumpChunks(String path) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.chunks.long2ByteEntrySet()) {
                    ChunkPos chunkcoordintpair = new ChunkPos(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.x + "\t" + chunkcoordintpair.z + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to dump chunks to {}", (Object)path, (Object)ioexception);
            }
        }
    }
}

