/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;
    private final BuiltInMetadata metadata;
    private final Set<String> namespaces;
    private final List<Path> rootPaths;
    private final Map<PackType, List<Path>> pathsForType;

    VanillaPackResources(PackLocationInfo info, BuiltInMetadata metadata, Set<String> namespaces, List<Path> rootPaths, Map<PackType, List<Path>> namespacePaths) {
        this.location = info;
        this.metadata = metadata;
        this.namespaces = namespaces;
        this.rootPaths = rootPaths;
        this.pathsForType = namespacePaths;
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> getRootResource(String ... segments) {
        FileUtil.validatePath(segments);
        List<String> list = List.of(segments);
        for (Path path : this.rootPaths) {
            Path path2 = FileUtil.resolvePath(path, list);
            if (!Files.exists(path2, new LinkOption[0]) || !PathPackResources.validatePath(path2)) continue;
            return IoSupplier.create(path2);
        }
        return null;
    }

    public void listRawPaths(PackType type, ResourceLocation path, Consumer<Path> consumer) {
        FileUtil.decomposePath(path.getPath()).ifSuccess(segments -> {
            String string = path.getNamespace();
            for (Path path : this.pathsForType.get((Object)type)) {
                Path path2 = path.resolve(string);
                consumer.accept(FileUtil.resolvePath(path2, segments));
            }
        }).ifError(error -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)error.message()));
    }

    @Override
    @Override
    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        FileUtil.decomposePath(prefix).ifSuccess(segments -> {
            List<Path> list = this.pathsForType.get((Object)type);
            int i = list.size();
            if (i == 1) {
                VanillaPackResources.getResources(consumer, namespace, list.get(0), segments);
            } else if (i > 1) {
                HashMap<ResourceLocation, IoSupplier<InputStream>> map = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
                for (int j = 0; j < i - 1; ++j) {
                    VanillaPackResources.getResources(map::putIfAbsent, namespace, list.get(j), segments);
                }
                Path path = list.get(i - 1);
                if (map.isEmpty()) {
                    VanillaPackResources.getResources(consumer, namespace, path, segments);
                } else {
                    VanillaPackResources.getResources(map::putIfAbsent, namespace, path, segments);
                    map.forEach(consumer);
                }
            }
        }).ifError(error -> LOGGER.error("Invalid path {}: {}", (Object)prefix, (Object)error.message()));
    }

    private static void getResources(PackResources.ResourceOutput consumer, String namespace, Path root, List<String> prefixSegments) {
        Path path = root.resolve(namespace);
        PathPackResources.listPath(namespace, path, prefixSegments, consumer);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        return (IoSupplier)FileUtil.decomposePath(id.getPath()).mapOrElse(segments -> {
            String string = id.getNamespace();
            for (Path path : this.pathsForType.get((Object)type)) {
                Path path2 = FileUtil.resolvePath(path.resolve(string), segments);
                if (!Files.exists(path2, new LinkOption[0]) || !PathPackResources.validatePath(path2)) continue;
                return IoSupplier.create(path2);
            }
            return null;
        }, error -> {
            LOGGER.error("Invalid path {}: {}", (Object)id, (Object)error.message());
            return null;
        });
    }

    @Override
    @Override
    public Set<String> getNamespaces(PackType type) {
        return this.namespaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @Override
    public <T> T getMetadataSection(MetadataSectionSerializer<T> metaReader) {
        IoSupplier<InputStream> ioSupplier = this.getRootResource("pack.mcmeta");
        if (ioSupplier == null) return this.metadata.get(metaReader);
        try (InputStream inputStream = ioSupplier.get();){
            T object = AbstractPackResources.getMetadataFromStream(metaReader, inputStream);
            if (object == null) return this.metadata.get(metaReader);
            T t = object;
            return t;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.metadata.get(metaReader);
    }

    @Override
    @Override
    public PackLocationInfo location() {
        return this.location;
    }

    @Override
    @Override
    public void close() {
    }

    public ResourceProvider asProvider() {
        return id -> Optional.ofNullable(this.getResource(PackType.CLIENT_RESOURCES, id)).map(stream -> new Resource(this, (IoSupplier<InputStream>)stream));
    }
}

