/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.util.GsonHelper;
import org.bukkit.Bukkit;
import org.slf4j.Logger;

public abstract class StoredUserList<K, V extends StoredUserEntry<K>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;
    private final Map<String, V> map = Maps.newConcurrentMap();

    public StoredUserList(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void add(V entry) {
        this.map.put(this.getKeyForUser(((StoredUserEntry)entry).getUser()), entry);
        try {
            this.save();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Could not save the list after adding a user.", (Throwable)ioexception);
        }
    }

    @Nullable
    public V get(K key) {
        return (V)this.map.computeIfPresent(this.getKeyForUser(key), (k, v) -> v.hasExpired() ? null : v);
    }

    public void remove(K key) {
        this.map.remove(this.getKeyForUser(key));
        try {
            this.save();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
    }

    public void remove(StoredUserEntry<K> entry) {
        this.remove(entry.getUser());
    }

    public String[] getUserList() {
        return this.map.keySet().toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    protected String getKeyForUser(K profile) {
        return profile.toString();
    }

    protected boolean contains(K k0) {
        this.removeExpired();
        return this.map.containsKey(this.getKeyForUser(k0));
    }

    private void removeExpired() {
        this.map.values().removeIf(StoredUserEntry::hasExpired);
    }

    protected abstract StoredUserEntry<K> createEntry(JsonObject var1);

    public Collection<V> getEntries() {
        return this.map.values();
    }

    public void save() throws IOException {
        this.removeExpired();
        JsonArray jsonarray = new JsonArray();
        Stream<JsonObject> stream = this.map.values().stream().map(jsonlistentry -> {
            JsonObject jsonobject = new JsonObject();
            Objects.requireNonNull(jsonlistentry);
            return Util.make(jsonobject, jsonlistentry::serialize);
        });
        Objects.requireNonNull(jsonarray);
        stream.forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        try (BufferedWriter bufferedwriter = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jsonarray, GSON.newJsonWriter((Writer)bufferedwriter));
        }
    }

    public void load() throws IOException {
        if (this.file.exists()) {
            BufferedReader bufferedreader;
            block10: {
                bufferedreader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);
                try {
                    this.map.clear();
                    JsonArray jsonarray = (JsonArray)GSON.fromJson((Reader)bufferedreader, JsonArray.class);
                    if (jsonarray == null) break block10;
                    for (JsonElement jsonelement : jsonarray) {
                        JsonObject jsonobject = GsonHelper.convertToJsonObject(jsonelement, "entry");
                        StoredUserEntry<K> jsonlistentry = this.createEntry(jsonobject);
                        if (jsonlistentry.getUser() == null) continue;
                        this.map.put(this.getKeyForUser(jsonlistentry.getUser()), jsonlistentry);
                    }
                }
                catch (JsonParseException | NullPointerException ex) {
                    Bukkit.getLogger().log(Level.WARNING, "Unable to read file " + String.valueOf(this.file) + ", backing it up to {0}.backup and creating new copy.", ex);
                    File backup = new File(String.valueOf(this.file) + ".backup");
                    this.file.renameTo(backup);
                    this.file.delete();
                }
                catch (Throwable throwable) {
                    if (bufferedreader != null) {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable1) {
                            throwable.addSuppressed(throwable1);
                        }
                    }
                    throw throwable;
                }
                if (bufferedreader != null) {
                    bufferedreader.close();
                }
                return;
            }
            if (bufferedreader != null) {
                bufferedreader.close();
            }
        }
    }
}

