/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftServer server;
    private final File file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    public ServerStatsCounter(MinecraftServer server, File file) {
        this.server = server;
        this.file = file;
        if (file.isFile()) {
            try {
                this.parseLocal(server.getFixerUpper(), FileUtils.readFileToString((File)file));
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't read statistics file {}", (Object)file, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonparseexception);
            }
        }
        for (Map.Entry<ResourceLocation, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<ResourceLocation> wrapper = Stats.CUSTOM.get(Objects.requireNonNull(BuiltInRegistries.CUSTOM_STAT.get(entry.getKey())));
            this.stats.put(wrapper, entry.getValue().intValue());
        }
    }

    public void save() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void setValue(Player player, Stat<?> stat, int value) {
        ResourceLocation resourceLocation;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.getType() == Stats.CUSTOM && (obj = stat.getValue()) instanceof ResourceLocation && SpigotConfig.forcedStats.get(resourceLocation = (ResourceLocation)obj) != null) {
            return;
        }
        super.setValue(player, stat, value);
        this.dirty.add(stat);
    }

    private Set<Stat<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parseLocal(DataFixer dataFixer, String json) {
        block11: {
            try {
                try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(json));){
                    jsonreader.setLenient(false);
                    JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                    if (!jsonelement.isJsonNull()) {
                        CompoundTag nbttagcompound = ServerStatsCounter.fromJson(jsonelement.getAsJsonObject());
                        if (!(nbttagcompound = DataFixTypes.STATS.updateToCurrentVersion(dataFixer, nbttagcompound, NbtUtils.getDataVersion(nbttagcompound, 1343))).contains("stats", 10)) {
                            break block11;
                        }
                        CompoundTag nbttagcompound1 = nbttagcompound.getCompound("stats");
                        Iterator<String> iterator = nbttagcompound1.getAllKeys().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block11;
                            }
                            String s1 = iterator.next();
                            if (!nbttagcompound1.contains(s1, 10)) continue;
                            Util.ifElse(BuiltInRegistries.STAT_TYPE.getOptional(ResourceLocation.parse(s1)), statisticwrapper -> {
                                CompoundTag nbttagcompound2 = nbttagcompound1.getCompound(s1);
                                for (String s2 : nbttagcompound2.getAllKeys()) {
                                    if (nbttagcompound2.contains(s2, 99)) {
                                        Util.ifElse(this.getStat((StatType)statisticwrapper, s2), statistic -> this.stats.put(statistic, nbttagcompound2.getInt(s2)), () -> LOGGER.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.file, (Object)s2));
                                        continue;
                                    }
                                    LOGGER.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.file, nbttagcompound2.get(s2), s2});
                                }
                            }, () -> LOGGER.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.file, (Object)s1));
                        }
                    }
                    LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                }
                return;
            }
            catch (JsonParseException | IOException jsonparseexception) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)jsonparseexception);
            }
        }
    }

    private <T> Optional<Stat<T>> getStat(StatType<T> type, String id) {
        Optional<ResourceLocation> optional = Optional.ofNullable(ResourceLocation.tryParse(id));
        Registry<T> iregistry = type.getRegistry();
        return optional.flatMap(iregistry::getOptional).map(type::get);
    }

    private static CompoundTag fromJson(JsonObject json) {
        CompoundTag nbttagcompound = new CompoundTag();
        for (Map.Entry entry : json.entrySet()) {
            JsonPrimitive jsonprimitive;
            JsonElement jsonelement = (JsonElement)entry.getValue();
            if (jsonelement.isJsonObject()) {
                nbttagcompound.put((String)entry.getKey(), ServerStatsCounter.fromJson(jsonelement.getAsJsonObject()));
                continue;
            }
            if (!jsonelement.isJsonPrimitive() || !(jsonprimitive = jsonelement.getAsJsonPrimitive()).isNumber()) continue;
            nbttagcompound.putInt((String)entry.getKey(), jsonprimitive.getAsInt());
        }
        return nbttagcompound;
    }

    protected String toJson() {
        HashMap map = Maps.newHashMap();
        for (Object2IntMap.Entry it_unimi_dsi_fastutil_objects_object2intmap_entry : this.stats.object2IntEntrySet()) {
            Stat statistic = (Stat)it_unimi_dsi_fastutil_objects_object2intmap_entry.getKey();
            map.computeIfAbsent(statistic.getType(), statisticwrapper -> new JsonObject()).addProperty(ServerStatsCounter.getKey(statistic).toString(), (Number)it_unimi_dsi_fastutil_objects_object2intmap_entry.getIntValue());
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonobject.add(BuiltInRegistries.STAT_TYPE.getKey((StatType)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonobject1 = new JsonObject();
        jsonobject1.add("stats", (JsonElement)jsonobject);
        jsonobject1.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        return jsonobject1.toString();
    }

    private static <T> ResourceLocation getKey(Stat<T> stat) {
        return stat.getType().getRegistry().getKey(stat.getValue());
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer player) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Stat<?> statistic : this.getDirty()) {
            object2intmap.put(statistic, this.getValue(statistic));
        }
        player.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)object2intmap));
    }
}

