/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.AbstractUUIDFix;
import net.minecraft.util.datafix.fixes.References;

public class BlockEntityUUIDFix
extends AbstractUUIDFix {
    public BlockEntityUUIDFix(Schema outputSchema) {
        super(outputSchema, References.BLOCK_ENTITY);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("BlockEntityUUIDFix", this.getInputSchema().getType(this.typeReference), typed -> {
            typed = this.updateNamedChoice((Typed<?>)typed, "minecraft:conduit", this::updateConduit);
            typed = this.updateNamedChoice((Typed<?>)typed, "minecraft:skull", this::updateSkull);
            return typed;
        });
    }

    private Dynamic<?> updateSkull(Dynamic<?> skullDynamic) {
        return skullDynamic.get("Owner").get().map(ownerDynamic -> BlockEntityUUIDFix.replaceUUIDString(ownerDynamic, "Id", "Id").orElse((Dynamic<?>)((Object)ownerDynamic))).map(ownerDynamic -> skullDynamic.remove("Owner").set("SkullOwner", (Dynamic<?>)((Object)ownerDynamic))).result().orElse(skullDynamic);
    }

    private Dynamic<?> updateConduit(Dynamic<?> conduitDynamic) {
        return BlockEntityUUIDFix.replaceUUIDMLTag(conduitDynamic, "target_uuid", "Target").orElse(conduitDynamic);
    }
}

