/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ChunkHeightAndBiomeFix
extends DataFix {
    public static final String DATAFIXER_CONTEXT_TAG = "__context";
    private static final String NAME = "ChunkHeightAndBiomeFix";
    private static final int OLD_SECTION_COUNT = 16;
    private static final int NEW_SECTION_COUNT = 24;
    private static final int NEW_MIN_SECTION_Y = -4;
    public static final int BLOCKS_PER_SECTION = 4096;
    private static final int LONGS_PER_SECTION = 64;
    private static final int HEIGHTMAP_BITS = 9;
    private static final long HEIGHTMAP_MASK = 511L;
    private static final int HEIGHTMAP_OFFSET = 64;
    private static final String[] HEIGHTMAP_TYPES = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
    private static final Set<String> STATUS_IS_OR_AFTER_SURFACE = Set.of("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> STATUS_IS_OR_AFTER_NOISE = Set.of("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> BLOCKS_BEFORE_FEATURE_STATUS = Set.of("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta");
    private static final int BIOME_CONTAINER_LAYER_SIZE = 16;
    private static final int BIOME_CONTAINER_SIZE = 64;
    private static final int BIOME_CONTAINER_TOP_LAYER_OFFSET = 1008;
    public static final String DEFAULT_BIOME = "minecraft:plains";
    private static final Int2ObjectMap<String> BIOMES_BY_ID = new Int2ObjectOpenHashMap();

    public ChunkHeightAndBiomeFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder2 = opticFinder.type().findField("Sections");
        Schema schema = this.getOutputSchema();
        Type type2 = schema.getType(References.CHUNK);
        Type type3 = type2.findField("Level").type();
        Type type4 = type3.findField("Sections").type();
        return this.fixTypeEverywhereTyped(NAME, type, type2, chunk -> chunk.updateTyped(opticFinder, type3, level -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)level.get(DSL.remainderFinder()))));
            OptionalDynamic optionalDynamic = ((Dynamic)((Object)((Object)((Object)chunk.get(DSL.remainderFinder()))))).get(DATAFIXER_CONTEXT_TAG);
            String string = optionalDynamic.get("dimension").asString().result().orElse("");
            String string2 = optionalDynamic.get("generator").asString().result().orElse("");
            boolean bl = "minecraft:overworld".equals(string);
            MutableBoolean mutableBoolean = new MutableBoolean();
            int i = bl ? -4 : 0;
            Dynamic[] dynamics = ChunkHeightAndBiomeFix.getBiomeContainers(dynamic, bl, i, mutableBoolean);
            Dynamic<?> dynamic2 = ChunkHeightAndBiomeFix.makePalettedContainer(dynamic.createList(Stream.of(dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air")))))));
            HashSet set = Sets.newHashSet();
            MutableObject mutableObject = new MutableObject(() -> null);
            level = level.updateTyped(opticFinder2, type4, sections -> {
                IntOpenHashSet intSet = new IntOpenHashSet();
                Dynamic dynamic3 = (Dynamic)((Object)((Object)((Object)((Object)sections.write().result().orElseThrow(() -> new IllegalStateException("Malformed Chunk.Level.Sections"))))));
                List list = dynamic3.asStream().map(arg_0 -> ChunkHeightAndBiomeFix.lambda$makeRule$6(set, dynamic2, i, dynamics, (IntSet)intSet, mutableObject, arg_0)).collect(Collectors.toCollection(ArrayList::new));
                for (int j = 0; j < dynamics.length; ++j) {
                    int k = j + i;
                    if (!intSet.add(k)) continue;
                    Dynamic dynamic4 = dynamic.createMap(Map.of(dynamic.createString("Y"), dynamic.createInt(k)));
                    dynamic4 = dynamic4.set("block_states", dynamic2);
                    dynamic4 = dynamic4.set("biomes", dynamics[j]);
                    list.add(dynamic4);
                }
                return Util.readTypedOrThrow(type4, dynamic.createList(list.stream()));
            });
            return level.update(DSL.remainderFinder(), level2 -> {
                if (bl) {
                    level2 = this.predictChunkStatusBeforeSurface((Dynamic<?>)((Object)((Object)((Object)level2))), set);
                }
                return ChunkHeightAndBiomeFix.updateChunkTag(level2, bl, mutableBoolean.booleanValue(), "minecraft:noise".equals(string2), (Supplier)mutableObject.getValue());
            });
        }));
    }

    private Dynamic<?> predictChunkStatusBeforeSurface(Dynamic<?> level, Set<String> blocks) {
        return level.update("Status", status -> {
            boolean bl2;
            String string = status.asString("empty");
            if (STATUS_IS_OR_AFTER_SURFACE.contains(string)) {
                return status;
            }
            blocks.remove("minecraft:air");
            boolean bl = !blocks.isEmpty();
            blocks.removeAll(BLOCKS_BEFORE_FEATURE_STATUS);
            boolean bl3 = bl2 = !blocks.isEmpty();
            if (bl2) {
                return status.createString("liquid_carvers");
            }
            if ("noise".equals(string) || bl) {
                return status.createString("noise");
            }
            if ("biomes".equals(string)) {
                return status.createString("structure_references");
            }
            return status;
        });
    }

    private static Dynamic<?>[] getBiomeContainers(Dynamic<?> level, boolean overworld, int i, MutableBoolean heightAlreadyUpdated) {
        Dynamic[] dynamics = new Dynamic[overworld ? 24 : 16];
        int[] is = level.get("Biomes").asIntStreamOpt().result().map(IntStream::toArray).orElse(null);
        if (is != null && is.length == 1536) {
            heightAlreadyUpdated.setValue(true);
            for (int j = 0; j < 24; ++j) {
                int k = j;
                dynamics[j] = ChunkHeightAndBiomeFix.makeBiomeContainer(level, sectionY -> ChunkHeightAndBiomeFix.getOldBiome(is, k * 64 + sectionY));
            }
        } else if (is != null && is.length == 1024) {
            int l = 0;
            while (l < 16) {
                int m = l - i;
                int n = l++;
                dynamics[m] = ChunkHeightAndBiomeFix.makeBiomeContainer(level, sectionY -> ChunkHeightAndBiomeFix.getOldBiome(is, n * 64 + sectionY));
            }
            if (overworld) {
                Dynamic<?> dynamic = ChunkHeightAndBiomeFix.makeBiomeContainer(level, sectionY -> ChunkHeightAndBiomeFix.getOldBiome(is, sectionY % 16));
                Dynamic<?> dynamic2 = ChunkHeightAndBiomeFix.makeBiomeContainer(level, sectionY -> ChunkHeightAndBiomeFix.getOldBiome(is, sectionY % 16 + 1008));
                for (int o = 0; o < 4; ++o) {
                    dynamics[o] = dynamic;
                }
                for (int p = 20; p < 24; ++p) {
                    dynamics[p] = dynamic2;
                }
            }
        } else {
            Arrays.fill((Object[])dynamics, ChunkHeightAndBiomeFix.makePalettedContainer(level.createList(Stream.of(level.createString(DEFAULT_BIOME)))));
        }
        return dynamics;
    }

    private static int getOldBiome(int[] is, int index) {
        return is[index] & 0xFF;
    }

    private static Dynamic<?> updateChunkTag(Dynamic<?> level, boolean overworld, boolean heightAlreadyUpdated, boolean atNoiseStatus, Supplier<ChunkProtoTickListFix.PoorMansPalettedContainer> supplier) {
        Dynamic dynamic;
        String string;
        level = level.remove("Biomes");
        if (!overworld) {
            return ChunkHeightAndBiomeFix.updateCarvingMasks(level, 16, 0);
        }
        if (heightAlreadyUpdated) {
            return ChunkHeightAndBiomeFix.updateCarvingMasks(level, 24, 0);
        }
        level = ChunkHeightAndBiomeFix.updateHeightmaps(level);
        level = ChunkHeightAndBiomeFix.addPaddingEntries(level, "LiquidsToBeTicked");
        level = ChunkHeightAndBiomeFix.addPaddingEntries(level, "PostProcessing");
        level = ChunkHeightAndBiomeFix.addPaddingEntries(level, "ToBeTicked");
        level = ChunkHeightAndBiomeFix.updateCarvingMasks(level, 24, 4);
        level = level.update("UpgradeData", ChunkHeightAndBiomeFix::shiftUpgradeData);
        if (!atNoiseStatus) {
            return level;
        }
        Optional optional = level.get("Status").result();
        if (optional.isPresent() && !"empty".equals(string = (dynamic = (Dynamic)((Object)optional.get())).asString(""))) {
            level = level.set("blending_data", level.createMap((Map)ImmutableMap.of((Object)((Object)level.createString("old_noise")), (Object)((Object)level.createBoolean(STATUS_IS_OR_AFTER_NOISE.contains(string))))));
            ChunkProtoTickListFix.PoorMansPalettedContainer poorMansPalettedContainer = supplier.get();
            if (poorMansPalettedContainer != null) {
                BitSet bitSet = new BitSet(256);
                boolean bl = string.equals("noise");
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        boolean bl3;
                        Dynamic<?> dynamic2 = poorMansPalettedContainer.get(j, 0, i);
                        boolean bl2 = dynamic2 != null && "minecraft:bedrock".equals(dynamic2.get("Name").asString(""));
                        boolean bl4 = bl3 = dynamic2 != null && "minecraft:air".equals(dynamic2.get("Name").asString(""));
                        if (bl3) {
                            bitSet.set(i * 16 + j);
                        }
                        bl |= bl2;
                    }
                }
                if (bl && bitSet.cardinality() != bitSet.size()) {
                    Dynamic dynamic3 = "full".equals(string) ? level.createString("heightmaps") : dynamic;
                    level = level.set("below_zero_retrogen", level.createMap((Map)ImmutableMap.of((Object)((Object)level.createString("target_status")), (Object)((Object)dynamic3), (Object)((Object)level.createString("missing_bedrock")), (Object)((Object)level.createLongList(LongStream.of(bitSet.toLongArray()))))));
                    level = level.set("Status", level.createString("empty"));
                }
                level = level.set("isLightOn", level.createBoolean(false));
            }
        }
        return level;
    }

    private static <T> Dynamic<T> shiftUpgradeData(Dynamic<T> upgradeData) {
        return upgradeData.update("Indices", indices -> {
            HashMap map = new HashMap();
            indices.getMapValues().ifSuccess(indicesMap -> indicesMap.forEach((key, value) -> {
                try {
                    key.asString().result().map(Integer::parseInt).ifPresent(index -> {
                        int i = index - -4;
                        map.put(key.createString(Integer.toString(i)), value);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }));
            return indices.createMap(map);
        });
    }

    private static Dynamic<?> updateCarvingMasks(Dynamic<?> level, int sectionsPerChunk, int oldBottomSectionY) {
        Dynamic dynamic = level.get("CarvingMasks").orElseEmptyMap();
        dynamic = dynamic.updateMapValues(mask -> {
            long[] ls = BitSet.valueOf(((Dynamic)((Object)((Object)mask.getSecond()))).asByteBuffer().array()).toLongArray();
            long[] ms = new long[64 * sectionsPerChunk];
            System.arraycopy(ls, 0, ms, 64 * oldBottomSectionY, ls.length);
            return Pair.of((Object)((Object)((Dynamic)((Object)((Object)mask.getFirst())))), (Object)((Object)level.createLongList(LongStream.of(ms))));
        });
        return level.set("CarvingMasks", dynamic);
    }

    private static Dynamic<?> addPaddingEntries(Dynamic<?> level, String key) {
        List list = level.get(key).orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 24) {
            return level;
        }
        Dynamic dynamic = level.emptyList();
        for (int i = 0; i < 4; ++i) {
            list.add(0, dynamic);
            list.add(dynamic);
        }
        return level.set(key, level.createList(list.stream()));
    }

    private static Dynamic<?> updateHeightmaps(Dynamic<?> level) {
        return level.update("Heightmaps", heightmaps -> {
            for (String string : HEIGHTMAP_TYPES) {
                heightmaps = heightmaps.update(string, ChunkHeightAndBiomeFix::getFixedHeightmap);
            }
            return heightmaps;
        });
    }

    private static Dynamic<?> getFixedHeightmap(Dynamic<?> heightmap) {
        return heightmap.createLongList(heightmap.asLongStream().map(entry -> {
            long l = 0L;
            int i = 0;
            while (i + 9 <= 64) {
                long o;
                long m = entry >> i & 0x1FFL;
                if (m == 0L) {
                    long n = 0L;
                } else {
                    o = Math.min(m + 64L, 511L);
                }
                l |= o << i;
                i += 9;
            }
            return l;
        }));
    }

    private static Dynamic<?> makeBiomeContainer(Dynamic<?> level, Int2IntFunction biomeGetter) {
        Int2IntLinkedOpenHashMap int2IntMap = new Int2IntLinkedOpenHashMap();
        for (int i = 0; i < 64; ++i) {
            int j = biomeGetter.applyAsInt(i);
            if (int2IntMap.containsKey(j)) continue;
            int2IntMap.put(j, int2IntMap.size());
        }
        Dynamic dynamic = level.createList(int2IntMap.keySet().stream().map(rawBiomeId -> level.createString((String)BIOMES_BY_ID.getOrDefault(rawBiomeId.intValue(), (Object)DEFAULT_BIOME))));
        int k = ChunkHeightAndBiomeFix.ceillog2(int2IntMap.size());
        if (k == 0) {
            return ChunkHeightAndBiomeFix.makePalettedContainer(dynamic);
        }
        int l = 64 / k;
        int m = (64 + l - 1) / l;
        long[] ls = new long[m];
        int n = 0;
        int o = 0;
        for (int p = 0; p < 64; ++p) {
            int q = biomeGetter.applyAsInt(p);
            int n2 = n++;
            ls[n2] = ls[n2] | (long)int2IntMap.get(q) << o;
            if ((o += k) + k <= 64) continue;
            o = 0;
        }
        Dynamic dynamic2 = level.createLongList(Arrays.stream(ls));
        return ChunkHeightAndBiomeFix.makePalettedContainer(dynamic, dynamic2);
    }

    private static Dynamic<?> makePalettedContainer(Dynamic<?> palette) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette));
    }

    private static Dynamic<?> makePalettedContainer(Dynamic<?> palette, Dynamic<?> data) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette, (Object)((Object)palette.createString("data")), data));
    }

    private static Dynamic<?> makeOptimizedPalettedContainer(Dynamic<?> dynamic, Dynamic<?> dynamic2) {
        List list = dynamic.asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 1) {
            return ChunkHeightAndBiomeFix.makePalettedContainer(dynamic);
        }
        dynamic = ChunkHeightAndBiomeFix.padPaletteEntries(dynamic, dynamic2, list);
        return ChunkHeightAndBiomeFix.makePalettedContainer(dynamic, dynamic2);
    }

    private static Dynamic<?> padPaletteEntries(Dynamic<?> dynamic, Dynamic<?> dynamic2, List<Dynamic<?>> list) {
        int i;
        int j;
        long l = dynamic2.asLongStream().count() * 64L;
        long m = l / 4096L;
        if (m > (long)(j = ChunkHeightAndBiomeFix.ceillog2(i = list.size()))) {
            Dynamic dynamic3 = dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air"))));
            int k = (1 << (int)(m - 1L)) + 1;
            int n = k - i;
            for (int o = 0; o < n; ++o) {
                list.add(dynamic3);
            }
            return dynamic.createList(list.stream());
        }
        return dynamic;
    }

    public static int ceillog2(int value) {
        if (value == 0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(value) / Math.log(2.0));
    }

    private static /* synthetic */ Dynamic lambda$makeRule$6(Set set, Dynamic dynamic, int i, Dynamic[] dynamics, IntSet intSet, MutableObject mutableObject, Dynamic dynamic2) {
        int j = dynamic2.get("Y").asInt(0);
        Dynamic dynamic3 = (Dynamic)((Object)DataFixUtils.orElse(dynamic2.get("Palette").result().flatMap(dynamic22 -> {
            dynamic22.asStream().map(dynamic -> dynamic.get("Name").asString("minecraft:air")).forEach(set::add);
            return dynamic2.get("BlockStates").result().map(dynamic2 -> ChunkHeightAndBiomeFix.makeOptimizedPalettedContainer(dynamic22, dynamic2));
        }), (Object)((Object)dynamic)));
        Dynamic dynamic4 = dynamic2;
        int k = j - i;
        if (k >= 0 && k < dynamics.length) {
            dynamic4 = dynamic4.set("biomes", dynamics[k]);
        }
        intSet.add(j);
        if (dynamic2.get("Y").asInt(Integer.MAX_VALUE) == 0) {
            mutableObject.setValue(() -> {
                List list = dynamic3.get("palette").asList(Function.identity());
                long[] ls = dynamic3.get("data").asLongStream().toArray();
                return new ChunkProtoTickListFix.PoorMansPalettedContainer(list, ls);
            });
        }
        return dynamic4.set("block_states", dynamic3).remove("Palette").remove("BlockStates");
    }

    static {
        BIOMES_BY_ID.put(0, (Object)"minecraft:ocean");
        BIOMES_BY_ID.put(1, (Object)DEFAULT_BIOME);
        BIOMES_BY_ID.put(2, (Object)"minecraft:desert");
        BIOMES_BY_ID.put(3, (Object)"minecraft:mountains");
        BIOMES_BY_ID.put(4, (Object)"minecraft:forest");
        BIOMES_BY_ID.put(5, (Object)"minecraft:taiga");
        BIOMES_BY_ID.put(6, (Object)"minecraft:swamp");
        BIOMES_BY_ID.put(7, (Object)"minecraft:river");
        BIOMES_BY_ID.put(8, (Object)"minecraft:nether_wastes");
        BIOMES_BY_ID.put(9, (Object)"minecraft:the_end");
        BIOMES_BY_ID.put(10, (Object)"minecraft:frozen_ocean");
        BIOMES_BY_ID.put(11, (Object)"minecraft:frozen_river");
        BIOMES_BY_ID.put(12, (Object)"minecraft:snowy_tundra");
        BIOMES_BY_ID.put(13, (Object)"minecraft:snowy_mountains");
        BIOMES_BY_ID.put(14, (Object)"minecraft:mushroom_fields");
        BIOMES_BY_ID.put(15, (Object)"minecraft:mushroom_field_shore");
        BIOMES_BY_ID.put(16, (Object)"minecraft:beach");
        BIOMES_BY_ID.put(17, (Object)"minecraft:desert_hills");
        BIOMES_BY_ID.put(18, (Object)"minecraft:wooded_hills");
        BIOMES_BY_ID.put(19, (Object)"minecraft:taiga_hills");
        BIOMES_BY_ID.put(20, (Object)"minecraft:mountain_edge");
        BIOMES_BY_ID.put(21, (Object)"minecraft:jungle");
        BIOMES_BY_ID.put(22, (Object)"minecraft:jungle_hills");
        BIOMES_BY_ID.put(23, (Object)"minecraft:jungle_edge");
        BIOMES_BY_ID.put(24, (Object)"minecraft:deep_ocean");
        BIOMES_BY_ID.put(25, (Object)"minecraft:stone_shore");
        BIOMES_BY_ID.put(26, (Object)"minecraft:snowy_beach");
        BIOMES_BY_ID.put(27, (Object)"minecraft:birch_forest");
        BIOMES_BY_ID.put(28, (Object)"minecraft:birch_forest_hills");
        BIOMES_BY_ID.put(29, (Object)"minecraft:dark_forest");
        BIOMES_BY_ID.put(30, (Object)"minecraft:snowy_taiga");
        BIOMES_BY_ID.put(31, (Object)"minecraft:snowy_taiga_hills");
        BIOMES_BY_ID.put(32, (Object)"minecraft:giant_tree_taiga");
        BIOMES_BY_ID.put(33, (Object)"minecraft:giant_tree_taiga_hills");
        BIOMES_BY_ID.put(34, (Object)"minecraft:wooded_mountains");
        BIOMES_BY_ID.put(35, (Object)"minecraft:savanna");
        BIOMES_BY_ID.put(36, (Object)"minecraft:savanna_plateau");
        BIOMES_BY_ID.put(37, (Object)"minecraft:badlands");
        BIOMES_BY_ID.put(38, (Object)"minecraft:wooded_badlands_plateau");
        BIOMES_BY_ID.put(39, (Object)"minecraft:badlands_plateau");
        BIOMES_BY_ID.put(40, (Object)"minecraft:small_end_islands");
        BIOMES_BY_ID.put(41, (Object)"minecraft:end_midlands");
        BIOMES_BY_ID.put(42, (Object)"minecraft:end_highlands");
        BIOMES_BY_ID.put(43, (Object)"minecraft:end_barrens");
        BIOMES_BY_ID.put(44, (Object)"minecraft:warm_ocean");
        BIOMES_BY_ID.put(45, (Object)"minecraft:lukewarm_ocean");
        BIOMES_BY_ID.put(46, (Object)"minecraft:cold_ocean");
        BIOMES_BY_ID.put(47, (Object)"minecraft:deep_warm_ocean");
        BIOMES_BY_ID.put(48, (Object)"minecraft:deep_lukewarm_ocean");
        BIOMES_BY_ID.put(49, (Object)"minecraft:deep_cold_ocean");
        BIOMES_BY_ID.put(50, (Object)"minecraft:deep_frozen_ocean");
        BIOMES_BY_ID.put(127, (Object)"minecraft:the_void");
        BIOMES_BY_ID.put(129, (Object)"minecraft:sunflower_plains");
        BIOMES_BY_ID.put(130, (Object)"minecraft:desert_lakes");
        BIOMES_BY_ID.put(131, (Object)"minecraft:gravelly_mountains");
        BIOMES_BY_ID.put(132, (Object)"minecraft:flower_forest");
        BIOMES_BY_ID.put(133, (Object)"minecraft:taiga_mountains");
        BIOMES_BY_ID.put(134, (Object)"minecraft:swamp_hills");
        BIOMES_BY_ID.put(140, (Object)"minecraft:ice_spikes");
        BIOMES_BY_ID.put(149, (Object)"minecraft:modified_jungle");
        BIOMES_BY_ID.put(151, (Object)"minecraft:modified_jungle_edge");
        BIOMES_BY_ID.put(155, (Object)"minecraft:tall_birch_forest");
        BIOMES_BY_ID.put(156, (Object)"minecraft:tall_birch_hills");
        BIOMES_BY_ID.put(157, (Object)"minecraft:dark_forest_hills");
        BIOMES_BY_ID.put(158, (Object)"minecraft:snowy_taiga_mountains");
        BIOMES_BY_ID.put(160, (Object)"minecraft:giant_spruce_taiga");
        BIOMES_BY_ID.put(161, (Object)"minecraft:giant_spruce_taiga_hills");
        BIOMES_BY_ID.put(162, (Object)"minecraft:modified_gravelly_mountains");
        BIOMES_BY_ID.put(163, (Object)"minecraft:shattered_savanna");
        BIOMES_BY_ID.put(164, (Object)"minecraft:shattered_savanna_plateau");
        BIOMES_BY_ID.put(165, (Object)"minecraft:eroded_badlands");
        BIOMES_BY_ID.put(166, (Object)"minecraft:modified_wooded_badlands_plateau");
        BIOMES_BY_ID.put(167, (Object)"minecraft:modified_badlands_plateau");
        BIOMES_BY_ID.put(168, (Object)"minecraft:bamboo_jungle");
        BIOMES_BY_ID.put(169, (Object)"minecraft:bamboo_jungle_hills");
        BIOMES_BY_ID.put(170, (Object)"minecraft:soul_sand_valley");
        BIOMES_BY_ID.put(171, (Object)"minecraft:crimson_forest");
        BIOMES_BY_ID.put(172, (Object)"minecraft:warped_forest");
        BIOMES_BY_ID.put(173, (Object)"minecraft:basalt_deltas");
        BIOMES_BY_ID.put(174, (Object)"minecraft:dripstone_caves");
        BIOMES_BY_ID.put(175, (Object)"minecraft:lush_caves");
        BIOMES_BY_ID.put(177, (Object)"minecraft:meadow");
        BIOMES_BY_ID.put(178, (Object)"minecraft:grove");
        BIOMES_BY_ID.put(179, (Object)"minecraft:snowy_slopes");
        BIOMES_BY_ID.put(180, (Object)"minecraft:snowcapped_peaks");
        BIOMES_BY_ID.put(181, (Object)"minecraft:lofty_peaks");
        BIOMES_BY_ID.put(182, (Object)"minecraft:stony_peaks");
    }
}

