/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class EntityCustomNameToComponentFix
extends DataFix {
    public EntityCustomNameToComponentFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        return this.fixTypeEverywhereTyped("EntityCustomNameToComponentFix", this.getInputSchema().getType(References.ENTITY), entityTyped -> entityTyped.update(DSL.remainderFinder(), entityDynamic -> {
            Optional optional = entityTyped.getOptional(opticFinder);
            if (optional.isPresent() && Objects.equals(optional.get(), "minecraft:commandblock_minecart")) {
                return entityDynamic;
            }
            return EntityCustomNameToComponentFix.fixTagCustomName(entityDynamic);
        }));
    }

    public static Dynamic<?> fixTagCustomName(Dynamic<?> entityDynamic) {
        String string = entityDynamic.get("CustomName").asString("");
        if (string.isEmpty()) {
            return entityDynamic.remove("CustomName");
        }
        return entityDynamic.set("CustomName", ComponentDataFixUtils.createPlainTextComponent(entityDynamic.getOps(), string));
    }
}

