/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityMinecartIdentifiersFix
extends EntityRenameFix {
    public EntityMinecartIdentifiersFix(Schema outputSchema) {
        super("EntityMinecartIdentifiersFix", outputSchema, true);
    }

    @Override
    @Override
    protected Pair<String, Typed<?>> fix(String choice, Typed<?> entityTyped) {
        if (!choice.equals("Minecart")) {
            return Pair.of((Object)choice, entityTyped);
        }
        int i = ((Dynamic)((Object)entityTyped.getOrCreate(DSL.remainderFinder()))).get("Type").asInt(0);
        String string = switch (i) {
            default -> "MinecartRideable";
            case 1 -> "MinecartChest";
            case 2 -> "MinecartFurnace";
        };
        Type type = (Type)this.getOutputSchema().findChoiceType(References.ENTITY).types().get(string);
        return Pair.of((Object)string, Util.writeAndReadTypedOrThrow(entityTyped, type, entityDynamic -> entityDynamic.remove("Type")));
    }
}

