/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class JigsawRotationFix
extends DataFix {
    private static final Map<String, String> RENAMES = ImmutableMap.builder().put((Object)"down", (Object)"down_south").put((Object)"up", (Object)"up_north").put((Object)"north", (Object)"north_up").put((Object)"south", (Object)"south_up").put((Object)"west", (Object)"west_up").put((Object)"east", (Object)"east_up").build();

    public JigsawRotationFix(Schema outputSchema, boolean changesTyped) {
        super(outputSchema, changesTyped);
    }

    private static Dynamic<?> fix(Dynamic<?> blockStateDynamic) {
        Optional optional = blockStateDynamic.get("Name").asString().result();
        if (optional.equals(Optional.of("minecraft:jigsaw"))) {
            return blockStateDynamic.update("Properties", propertiesDynamic -> {
                String string = propertiesDynamic.get("facing").asString("north");
                return propertiesDynamic.remove("facing").set("orientation", propertiesDynamic.createString(RENAMES.getOrDefault(string, string)));
            });
        }
        return blockStateDynamic;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("jigsaw_rotation_fix", this.getInputSchema().getType(References.BLOCK_STATE), blockStateTyped -> blockStateTyped.update(DSL.remainderFinder(), JigsawRotationFix::fix));
    }
}

