/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.stream.Stream;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;

public interface StringReaderTerms {
    public static Term<StringReader> word(String string) {
        return new TerminalWord(string);
    }

    public static Term<StringReader> character(char c) {
        return new TerminalCharacter(c);
    }

    public record TerminalWord(String value) implements Term<StringReader>
    {
        @Override
        @Override
        public boolean parse(ParseState<StringReader> state, Scope results, Control cut) {
            state.input().skipWhitespace();
            int i = state.mark();
            String string = state.input().readUnquotedString();
            if (!string.equals(this.value)) {
                state.errorCollector().store(i, suggestState -> Stream.of(this.value), CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect().create((Object)this.value));
                return false;
            }
            return true;
        }
    }

    public record TerminalCharacter(char value) implements Term<StringReader>
    {
        @Override
        @Override
        public boolean parse(ParseState<StringReader> state, Scope results, Control cut) {
            state.input().skipWhitespace();
            int i = state.mark();
            if (!state.input().canRead() || state.input().read() != this.value) {
                state.errorCollector().store(i, suggestState -> Stream.of(String.valueOf(this.value)), CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect().create((Object)Character.valueOf(this.value)));
                return false;
            }
            return true;
        }
    }
}

