/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import java.util.function.Supplier;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.metrics.MetricCategory;

public interface ProfilerFiller {
    public static final String ROOT = "root";

    public void startTick();

    public void endTick();

    public void push(String var1);

    public void push(Supplier<String> var1);

    public void pop();

    public void popPush(String var1);

    public void popPush(Supplier<String> var1);

    public void markForCharting(MetricCategory var1);

    default public void incrementCounter(String marker) {
        this.incrementCounter(marker, 1);
    }

    public void incrementCounter(String var1, int var2);

    default public void incrementCounter(Supplier<String> markerGetter) {
        this.incrementCounter(markerGetter, 1);
    }

    public void incrementCounter(Supplier<String> var1, int var2);

    public static ProfilerFiller tee(final ProfilerFiller a, final ProfilerFiller b) {
        if (a == InactiveProfiler.INSTANCE) {
            return b;
        }
        if (b == InactiveProfiler.INSTANCE) {
            return a;
        }
        return new ProfilerFiller(){

            @Override
            @Override
            public void startTick() {
                a.startTick();
                b.startTick();
            }

            @Override
            @Override
            public void endTick() {
                a.endTick();
                b.endTick();
            }

            @Override
            @Override
            public void push(String location) {
                a.push(location);
                b.push(location);
            }

            @Override
            @Override
            public void push(Supplier<String> locationGetter) {
                a.push(locationGetter);
                b.push(locationGetter);
            }

            @Override
            @Override
            public void markForCharting(MetricCategory type) {
                a.markForCharting(type);
                b.markForCharting(type);
            }

            @Override
            @Override
            public void pop() {
                a.pop();
                b.pop();
            }

            @Override
            @Override
            public void popPush(String location) {
                a.popPush(location);
                b.popPush(location);
            }

            @Override
            @Override
            public void popPush(Supplier<String> locationGetter) {
                a.popPush(locationGetter);
                b.popPush(locationGetter);
            }

            @Override
            @Override
            public void incrementCounter(String marker, int num) {
                a.incrementCounter(marker, num);
                b.incrementCounter(marker, num);
            }

            @Override
            @Override
            public void incrementCounter(Supplier<String> markerGetter, int num) {
                a.incrementCounter(markerGetter, num);
                b.incrementCounter(markerGetter, num);
            }
        };
    }
}

