/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public interface StrictQueue<T, F> {
    @Nullable
    public F pop();

    public boolean push(T var1);

    public boolean isEmpty();

    public int size();

    public static final class FixedPriorityQueue
    implements StrictQueue<IntRunnable, Runnable> {
        private final Queue<Runnable>[] queues;
        private final AtomicInteger size = new AtomicInteger();

        public FixedPriorityQueue(int priorityCount) {
            this.queues = new Queue[priorityCount];
            for (int i = 0; i < priorityCount; ++i) {
                this.queues[i] = Queues.newConcurrentLinkedQueue();
            }
        }

        @Override
        @Nullable
        @Override
        public Runnable pop() {
            for (Queue<Runnable> queue : this.queues) {
                Runnable runnable = queue.poll();
                if (runnable == null) continue;
                this.size.decrementAndGet();
                return runnable;
            }
            return null;
        }

        @Override
        @Override
        public boolean push(IntRunnable message) {
            int i = message.priority;
            if (i >= this.queues.length || i < 0) {
                throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Priority %d not supported. Expected range [0-%d]", i, this.queues.length - 1));
            }
            this.queues[i].add(message);
            this.size.incrementAndGet();
            return true;
        }

        @Override
        @Override
        public boolean isEmpty() {
            return this.size.get() == 0;
        }

        @Override
        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        @Nullable
        public /* synthetic */ Object pop() {
            return this.pop();
        }
    }

    public static final class IntRunnable
    implements Runnable {
        final int priority;
        private final Runnable task;

        public IntRunnable(int priority, Runnable runnable) {
            this.priority = priority;
            this.task = runnable;
        }

        @Override
        @Override
        public void run() {
            this.task.run();
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static final class QueueStrictQueue<T>
    implements StrictQueue<T, T> {
        private final Queue<T> queue;

        public QueueStrictQueue(Queue<T> queue) {
            this.queue = queue;
        }

        @Override
        @Nullable
        @Override
        public T pop() {
            return this.queue.poll();
        }

        @Override
        @Override
        public boolean push(T message) {
            return this.queue.add(message);
        }

        @Override
        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

