/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedNormalInt
extends IntProvider {
    public static final MapCodec<ClampedNormalInt> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(provider -> Float.valueOf(provider.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(provider -> Float.valueOf(provider.deviation)), (App)Codec.INT.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive)).apply((Applicative)instance, ClampedNormalInt::new)).validate(provider -> {
        if (provider.maxInclusive < provider.minInclusive) {
            return DataResult.error(() -> "Max must be larger than min: [" + clampedNormalInt.minInclusive + ", " + clampedNormalInt.maxInclusive + "]");
        }
        return DataResult.success((Object)provider);
    });
    private final float mean;
    private final float deviation;
    private final int minInclusive;
    private final int maxInclusive;

    public static ClampedNormalInt of(float mean, float deviation, int min, int max) {
        return new ClampedNormalInt(mean, deviation, min, max);
    }

    private ClampedNormalInt(float mean, float deviation, int min, int max) {
        this.mean = mean;
        this.deviation = deviation;
        this.minInclusive = min;
        this.maxInclusive = max;
    }

    @Override
    @Override
    public int sample(RandomSource random) {
        return ClampedNormalInt.sample(random, this.mean, this.deviation, this.minInclusive, this.maxInclusive);
    }

    public static int sample(RandomSource random, float mean, float deviation, float min, float max) {
        return (int)Mth.clamp(Mth.normal(random, mean, deviation), min, max);
    }

    @Override
    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    @Override
    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CLAMPED_NORMAL;
    }

    @Override
    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

