/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ConstantInt
extends IntProvider {
    public static final ConstantInt ZERO = new ConstantInt(0);
    public static final MapCodec<ConstantInt> CODEC = Codec.INT.fieldOf("value").xmap(ConstantInt::of, ConstantInt::getValue);
    private final int value;

    public static ConstantInt of(int value) {
        if (value == 0) {
            return ZERO;
        }
        return new ConstantInt(value);
    }

    private ConstantInt(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    @Override
    public int sample(RandomSource random) {
        return this.value;
    }

    @Override
    @Override
    public int getMinValue() {
        return this.value;
    }

    @Override
    @Override
    public int getMaxValue() {
        return this.value;
    }

    @Override
    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CONSTANT;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }
}

