/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.util.CraftChatMessage;

public record LockCode(String key) {
    public static final LockCode NO_LOCK = new LockCode("");
    public static final Codec<LockCode> CODEC = Codec.STRING.xmap(LockCode::new, LockCode::key);
    public static final String TAG_LOCK = "Lock";

    public boolean unlocksWith(ItemStack stack) {
        if (this.key.isEmpty()) {
            return true;
        }
        Component ichatbasecomponent = stack.get(DataComponents.CUSTOM_NAME);
        if (this.key.isEmpty()) {
            return true;
        }
        if (ichatbasecomponent != null) {
            if (this.key.indexOf(167) == -1) {
                return this.key.equals(ichatbasecomponent.getString());
            }
            return this.key.equals(CraftChatMessage.fromComponent(ichatbasecomponent));
        }
        return false;
    }

    public void addToTag(CompoundTag nbt) {
        if (!this.key.isEmpty()) {
            nbt.putString(TAG_LOCK, this.key);
        }
    }

    public static LockCode fromTag(CompoundTag nbt) {
        return nbt.contains(TAG_LOCK, 8) ? new LockCode(nbt.getString(TAG_LOCK)) : NO_LOCK;
    }
}

