/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class CombatRules {
    public static final float MAX_ARMOR = 20.0f;
    public static final float ARMOR_PROTECTION_DIVIDER = 25.0f;
    public static final float BASE_ARMOR_TOUGHNESS = 2.0f;
    public static final float MIN_ARMOR_RATIO = 0.2f;
    private static final int NUM_ARMOR_ITEMS = 4;

    public static float getDamageAfterAbsorb(LivingEntity armorWearer, float damageAmount, DamageSource damageSource, float armor, float armorToughness) {
        float j;
        Level level;
        float f = 2.0f + armorToughness / 4.0f;
        float g = Mth.clamp(armor - damageAmount / f, armor * 0.2f, 20.0f);
        float h = g / 25.0f;
        ItemStack itemStack = damageSource.getWeaponItem();
        if (itemStack != null && (level = armorWearer.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float i = Mth.clamp(EnchantmentHelper.modifyArmorEffectiveness(serverLevel, itemStack, armorWearer, damageSource, h), 0.0f, 1.0f);
        } else {
            j = h;
        }
        float k = 1.0f - j;
        return damageAmount * k;
    }

    public static float getDamageAfterMagicAbsorb(float damageDealt, float protection) {
        float f = Mth.clamp(protection, 0.0f, 20.0f);
        return damageDealt * (1.0f - f / 25.0f);
    }
}

