/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;

public interface EquipmentUser {
    public void setItemSlot(EquipmentSlot var1, ItemStack var2);

    public ItemStack getItemBySlot(EquipmentSlot var1);

    public void setDropChance(EquipmentSlot var1, float var2);

    default public void equip(EquipmentTable equipmentTable, LootParams parameters) {
        this.equip(equipmentTable.lootTable(), parameters, equipmentTable.slotDropChances());
    }

    default public void equip(ResourceKey<LootTable> lootTable, LootParams parameters, Map<EquipmentSlot, Float> slotDropChances) {
        this.equip(lootTable, parameters, 0L, slotDropChances);
    }

    default public void equip(ResourceKey<LootTable> lootTable, LootParams parameters, long seed, Map<EquipmentSlot, Float> slotDropChances) {
        if (lootTable.equals(BuiltInLootTables.EMPTY)) {
            return;
        }
        LootTable lootTable2 = parameters.getLevel().getServer().reloadableRegistries().getLootTable(lootTable);
        if (lootTable2 == LootTable.EMPTY) {
            return;
        }
        ObjectArrayList<ItemStack> list = lootTable2.getRandomItems(parameters, seed);
        ArrayList<EquipmentSlot> list2 = new ArrayList<EquipmentSlot>();
        for (ItemStack itemStack : list) {
            EquipmentSlot equipmentSlot = this.resolveSlot(itemStack, list2);
            if (equipmentSlot == null) continue;
            ItemStack itemStack2 = equipmentSlot.limit(itemStack);
            this.setItemSlot(equipmentSlot, itemStack2);
            Float float_ = slotDropChances.get(equipmentSlot);
            if (float_ != null) {
                this.setDropChance(equipmentSlot, float_.floatValue());
            }
            list2.add(equipmentSlot);
        }
    }

    @Nullable
    default public EquipmentSlot resolveSlot(ItemStack stack, List<EquipmentSlot> slotBlacklist) {
        if (stack.isEmpty()) {
            return null;
        }
        Equipable equipable = Equipable.get(stack);
        if (equipable != null) {
            EquipmentSlot equipmentSlot = equipable.getEquipmentSlot();
            if (!slotBlacklist.contains(equipmentSlot)) {
                return equipmentSlot;
            }
        } else if (!slotBlacklist.contains(EquipmentSlot.MAINHAND)) {
            return EquipmentSlot.MAINHAND;
        }
        return null;
    }
}

