/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 10.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedToIt() {
        return this.canBeLeashed() && !this.isLeashed();
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int unresolvedLeashHolderId) {
        this.setLeashData(new LeashData(unresolvedLeashHolderId));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    @Nullable
    default public LeashData readLeashData(CompoundTag nbt) {
        Either either;
        if (nbt.contains(LEASH_TAG, 10)) {
            CompoundTag leashTag = nbt.getCompound(LEASH_TAG);
            if (!leashTag.hasUUID("UUID")) {
                return null;
            }
            return new LeashData(Either.left(leashTag.getUUID("UUID")));
        }
        if (nbt.contains(LEASH_TAG, 11) && (either = (Either)NbtUtils.readBlockPos(nbt, LEASH_TAG).map(Either::right).orElse(null)) != null) {
            return new LeashData(either);
        }
        return null;
    }

    default public void writeLeashData(CompoundTag nbt, @Nullable LeashData leashData) {
        if (leashData != null) {
            Either<UUID, BlockPos> either = leashData.delayedLeashInfo;
            Entity entity = leashData.leashHolder;
            if (entity != null && entity.pluginRemoved) {
                return;
            }
            if (entity instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity entityleash = (LeashFenceKnotEntity)entity;
                either = Either.right(entityleash.getPos());
            } else if (leashData.leashHolder != null) {
                either = Either.left(leashData.leashHolder.getUUID());
            }
            if (either != null) {
                nbt.put(LEASH_TAG, either.map(uuid -> {
                    CompoundTag nbttagcompound1 = new CompoundTag();
                    nbttagcompound1.putUUID("UUID", (UUID)uuid);
                    return nbttagcompound1;
                }, NbtUtils::writeBlockPos));
            }
        }
    }

    private static <E extends Entity> void restoreLeashFromSave(E entity, LeashData leashData) {
        Level world;
        if (leashData.delayedLeashInfo != null && (world = entity.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Optional<UUID> optional = leashData.delayedLeashInfo.left();
            Optional<BlockPos> optional1 = leashData.delayedLeashInfo.right();
            if (optional.isPresent()) {
                Entity entity1 = worldserver.getEntity(optional.get());
                if (entity1 != null) {
                    Leashable.setLeashedTo(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.setLeashedTo(entity, LeashFenceKnotEntity.getOrCreateKnot(worldserver, optional1.get()), true);
                return;
            }
            if (entity.tickCount > 100) {
                entity.forceDrops = true;
                entity.spawnAtLocation(Items.LEAD);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).setLeashData(null);
            }
        }
    }

    default public void dropLeash(boolean sendPacket, boolean dropItem) {
        Leashable.dropLeash((Entity)((Object)this), sendPacket, dropItem);
    }

    private static <E extends Entity> void dropLeash(E entity, boolean sendPacket, boolean dropItem) {
        LeashData leashable_a = ((Leashable)((Object)entity)).getLeashData();
        if (leashable_a != null && leashable_a.leashHolder != null) {
            Level world;
            ((Leashable)((Object)entity)).setLeashData(null);
            if (!entity.level().isClientSide && dropItem) {
                entity.forceDrops = true;
                entity.spawnAtLocation(Items.LEAD);
                entity.forceDrops = false;
            }
            if (sendPacket && (world = entity.level()) instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                worldserver.getChunkSource().broadcast(entity, new ClientboundSetEntityLinkPacket(entity, null));
            }
        }
    }

    public static <E extends Entity> void tickLeash(E entity) {
        LeashData leashable_a = ((Leashable)((Object)entity)).getLeashData();
        if (leashable_a != null && leashable_a.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(entity, leashable_a);
        }
        if (leashable_a != null && leashable_a.leashHolder != null) {
            Entity entity1;
            if (!entity.isAlive() || !leashable_a.leashHolder.isAlive()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.isAlive() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, !entity.pluginRemoved);
                event.callEvent();
                Leashable.dropLeash(entity, true, event.isDropLeash());
            }
            if ((entity1 = ((Leashable)((Object)entity)).getLeashHolder()) != null && entity1.level() == entity.level()) {
                float f = entity.distanceTo(entity1);
                if (!((Leashable)((Object)entity)).handleLeashAtDistance(entity1, f)) {
                    return;
                }
                if ((double)f > entity.level().paperConfig().misc.maxLeashDistance.or(10.0)) {
                    ((Leashable)((Object)entity)).leashTooFarBehaviour();
                } else if ((double)f > 6.0) {
                    ((Leashable)((Object)entity)).elasticRangeLeashBehaviour(entity1, f);
                    entity.checkSlowFallDistance();
                } else {
                    ((Leashable)((Object)entity)).closeRangeLeashBehaviour(entity1);
                }
            }
        }
    }

    default public boolean handleLeashAtDistance(Entity leashHolder, float distance) {
        return true;
    }

    default public void leashTooFarBehaviour() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            dropLeash = event.isDropLeash();
        }
        this.dropLeash(true, dropLeash);
    }

    default public void closeRangeLeashBehaviour(Entity entity) {
    }

    default public void elasticRangeLeashBehaviour(Entity leashHolder, float distance) {
        Leashable.legacyElasticRangeLeashBehaviour((Entity)((Object)this), leashHolder, distance);
    }

    private static <E extends Entity> void legacyElasticRangeLeashBehaviour(E entity, Entity leashHolder, float distance) {
        double d0 = (leashHolder.getX() - entity.getX()) / (double)distance;
        double d1 = (leashHolder.getY() - entity.getY()) / (double)distance;
        double d2 = (leashHolder.getZ() - entity.getZ()) / (double)distance;
        entity.setDeltaMovement(entity.getDeltaMovement().add(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
    }

    default public void setLeashedTo(Entity leashHolder, boolean sendPacket) {
        Leashable.setLeashedTo((Entity)((Object)this), leashHolder, sendPacket);
    }

    private static <E extends Entity> void setLeashedTo(E entity, Entity leashHolder, boolean sendPacket) {
        Level world;
        LeashData leashable_a = ((Leashable)((Object)entity)).getLeashData();
        if (leashable_a == null) {
            leashable_a = new LeashData(leashHolder);
            ((Leashable)((Object)entity)).setLeashData(leashable_a);
        } else {
            leashable_a.setLeashHolder(leashHolder);
        }
        if (sendPacket && (world = entity.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.getChunkSource().broadcast(entity, new ClientboundSetEntityLinkPacket(entity, leashHolder));
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E entity) {
        Entity entity1;
        LeashData leashable_a = ((Leashable)((Object)entity)).getLeashData();
        if (leashable_a == null) {
            return null;
        }
        if (leashable_a.delayedLeashHolderId != 0 && entity.level().isClientSide && (entity1 = entity.level().getEntity(leashable_a.delayedLeashHolderId)) instanceof Entity) {
            leashable_a.setLeashHolder(entity1);
        }
        return leashable_a.leashHolder;
    }

    public static final class LeashData {
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;

        LeashData(Either<UUID, BlockPos> unresolvedLeashData) {
            this.delayedLeashInfo = unresolvedLeashData;
        }

        LeashData(Entity leashHolder) {
            this.leashHolder = leashHolder;
        }

        LeashData(int unresolvedLeashHolderId) {
            this.delayedLeashHolderId = unresolvedLeashHolderId;
        }

        public void setLeashHolder(Entity leashHolder) {
            this.leashHolder = leashHolder;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }
}

