/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class LivingEntity
extends Entity
implements Attackable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    private static final ResourceLocation SPEED_MODIFIER_POWDER_SNOW_ID = ResourceLocation.withDefaultNamespace("powder_snow");
    private static final ResourceLocation SPRINTING_MODIFIER_ID = ResourceLocation.withDefaultNamespace("sprinting");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int HAND_SLOTS = 2;
    public static final int ARMOR_SLOTS = 4;
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final int USE_ITEM_INTERVAL = 4;
    public static final float BASE_JUMP_POWER = 0.42f;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    public static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final EntityDataAccessor<Byte> DATA_LIVING_ENTITY_FLAGS = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<List<ParticleOptions>> DATA_EFFECT_PARTICLES = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.PARTICLES);
    private static final EntityDataAccessor<Boolean> DATA_EFFECT_AMBIENCE_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_ARROW_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STINGER_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> SLEEPING_POS_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    private static final float ITEM_USE_EFFECT_START_FRACTION = 0.21875f;
    public static final String ATTRIBUTES_FIELD = "attributes";
    private final AttributeMap attributes;
    public CombatTracker combatTracker = new CombatTracker(this);
    public final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = Maps.newHashMap();
    private final NonNullList<ItemStack> lastHandItemStacks;
    private final NonNullList<ItemStack> lastArmorItemStacks;
    private ItemStack lastBodyItemStack;
    public boolean swinging;
    private boolean discardFriction;
    public InteractionHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public final WalkAnimationState walkAnimation;
    public int invulnerableDuration;
    public final float timeOffs;
    public final float rotA;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    @Nullable
    public Player lastHurtByPlayer;
    public int lastHurtByPlayerTime;
    protected boolean dead;
    protected int noActionTime;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected float rotOffs;
    protected int deathScore;
    public float lastHurt;
    public boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    public boolean effectsDirty;
    @Nullable
    public LivingEntity lastHurtByMob;
    public int lastHurtByMobTimestamp;
    @Nullable
    private LivingEntity lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem;
    public int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPos lastPos;
    private Optional<BlockPos> lastClimbablePos;
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    protected float autoSpinAttackDmg;
    @Nullable
    protected ItemStack autoSpinAttackItemStack;
    private float swimAmount;
    private float swimAmountO;
    protected Brain<?> brain;
    protected boolean skipDropExperience;
    private final Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments;
    protected float appliedScale;
    public int expToDrop;
    public ArrayList<Entity.DefaultDrop> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EquipmentSlot> clearedEquipmentSlots = new HashSet<EquipmentSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.getYHeadRot();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.noActionTime;
    }

    protected LivingEntity(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
        this.shieldBlockingDelay = this.level().paperConfig().misc.shieldBlockingDelay;
        this.lastHandItemStacks = NonNullList.withSize(2, ItemStack.EMPTY);
        this.lastArmorItemStacks = NonNullList.withSize(4, ItemStack.EMPTY);
        this.lastBodyItemStack = ItemStack.EMPTY;
        this.discardFriction = false;
        this.walkAnimation = new WalkAnimationState();
        this.invulnerableDuration = 20;
        this.effectsDirty = true;
        this.useItem = ItemStack.EMPTY;
        this.lastClimbablePos = Optional.empty();
        this.activeLocationDependentEnchantments = new Reference2ObjectArrayMap();
        this.appliedScale = 1.0f;
        this.attributes = new AttributeMap(DefaultAttributes.getSupplier(type));
        this.craftAttributes = new CraftAttributeMap(this.attributes);
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf((float)this.getAttribute(Attributes.MAX_HEALTH).getValue()));
        this.blocksBuilding = true;
        this.rotA = (float)((Math.random() + 1.0) * (double)0.01f);
        this.reapplyPosition();
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        NbtOps dynamicopsnbt = NbtOps.INSTANCE;
        this.brain = this.makeBrain(new Dynamic<Tag>(dynamicopsnbt, (Tag)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.createString("memories"), (Object)((Tag)dynamicopsnbt.emptyMap())))));
    }

    public Brain<?> getBrain() {
        return this.brain;
    }

    protected Brain.Provider<?> brainProvider() {
        return Brain.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return this.brainProvider().makeBrain(dynamic);
    }

    @Override
    public void kill() {
        this.hurt(this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityType<?> type) {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        builder.define(DATA_EFFECT_PARTICLES, List.of());
        builder.define(DATA_EFFECT_AMBIENCE_ID, false);
        builder.define(DATA_ARROW_COUNT_ID, 0);
        builder.define(DATA_STINGER_COUNT_ID, 0);
        builder.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        builder.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeSupplier.Builder createLivingAttributes() {
        return AttributeSupplier.builder().add(Attributes.MAX_HEALTH).add(Attributes.KNOCKBACK_RESISTANCE).add(Attributes.MOVEMENT_SPEED).add(Attributes.ARMOR).add(Attributes.ARMOR_TOUGHNESS).add(Attributes.MAX_ABSORPTION).add(Attributes.STEP_HEIGHT).add(Attributes.SCALE).add(Attributes.GRAVITY).add(Attributes.SAFE_FALL_DISTANCE).add(Attributes.FALL_DAMAGE_MULTIPLIER).add(Attributes.JUMP_STRENGTH).add(Attributes.OXYGEN_BONUS).add(Attributes.BURNING_TIME).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE).add(Attributes.WATER_MOVEMENT_EFFICIENCY).add(Attributes.MOVEMENT_EFFICIENCY).add(Attributes.ATTACK_KNOCKBACK);
    }

    @Override
    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        Level world;
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if ((world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (onGround && this.fallDistance > 0.0f) {
                this.onChangedBlock(worldserver, landedPosition);
                double d1 = this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
                if ((double)this.fallDistance > d1 && !state.isAir()) {
                    double d2 = this.getX();
                    double d3 = this.getY();
                    double d4 = this.getZ();
                    BlockPos blockposition1 = this.blockPosition();
                    if (landedPosition.getX() != blockposition1.getX() || landedPosition.getZ() != blockposition1.getZ()) {
                        double d5 = d2 - (double)landedPosition.getX() - 0.5;
                        double d6 = d4 - (double)landedPosition.getZ() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)landedPosition.getX() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)landedPosition.getZ() + 0.5 + d6 / d7 * 0.5;
                    }
                    float f = Mth.ceil((double)this.fallDistance - d1);
                    double d8 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                    int i = (int)(150.0 * d8);
                    if (this instanceof ServerPlayer) {
                        ((ServerLevel)this.level()).sendParticles((ServerPlayer)this, new BlockParticleOption(ParticleTypes.BLOCK, state), d2, d3, d4, i, 0.0, 0.0, 0.0, (double)0.15f, false);
                    } else {
                        ((ServerLevel)this.level()).sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, state), d2, d3, d4, i, 0.0, 0.0, 0.0, 0.15f);
                    }
                }
            }
        }
        super.checkFallDamage(heightDifference, onGround, state, landedPosition);
        if (onGround) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public final boolean canBreatheUnderwater() {
        return this.getType().is(EntityTypeTags.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float tickDelta) {
        return Mth.lerp(tickDelta, this.swimAmountO, this.swimAmount);
    }

    public boolean hasLandedInLiquid() {
        return this.getDeltaMovement().y() < (double)1.0E-5f && this.isInLiquid();
    }

    @Override
    public void baseTick() {
        Level world;
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if ((world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            EnchantmentHelper.tickEffects(worldserver, this);
        }
        super.baseTick();
        this.level().getProfiler().push("livingEntityBaseTick");
        if (this.fireImmune() || this.level().isClientSide) {
            this.clearFire();
        }
        if (this.isAlive()) {
            boolean flag = this instanceof Player;
            if (!this.level().isClientSide) {
                double d1;
                double d0;
                if (this.isInWall()) {
                    this.hurt(this.damageSources().inWall(), 1.0f);
                } else if (flag && !this.level().getWorldBorder().isWithinBounds(this.getBoundingBox()) && (d0 = this.level().getWorldBorder().getDistanceToBorder(this) + this.level().getWorldBorder().getDamageSafeZone()) < 0.0 && (d1 = this.level().getWorldBorder().getDamagePerBlock()) > 0.0) {
                    this.hurt(this.damageSources().outOfBorder(), Math.max(1, Mth.floor(-d0 * d1)));
                }
            }
            if (this.isEyeInFluid(FluidTags.WATER) && !this.level().getBlockState(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean flag1;
                boolean bl = flag1 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!flag || !((Player)this).getAbilities().invulnerable);
                if (flag1) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.getAirSupply() == -20) {
                        this.setAirSupply(0);
                        Vec3 vec3d = this.getDeltaMovement();
                        for (int i = 0; i < 8; ++i) {
                            double d2 = this.random.nextDouble() - this.random.nextDouble();
                            double d3 = this.random.nextDouble() - this.random.nextDouble();
                            double d4 = this.random.nextDouble() - this.random.nextDouble();
                            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + d2, this.getY() + d3, this.getZ() + d4, vec3d.x, vec3d.y, vec3d.z);
                        }
                        this.hurt(this.damageSources().drown(), 2.0f);
                    }
                }
                if (!this.level().isClientSide && this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            Level world1 = this.level();
            if (world1 instanceof ServerLevel) {
                ServerLevel worldserver1 = (ServerLevel)world1;
                BlockPos blockposition = this.blockPosition();
                if (!com.google.common.base.Objects.equal((Object)this.lastPos, (Object)blockposition)) {
                    this.lastPos = blockposition;
                    this.onChangedBlock(worldserver1, blockposition);
                }
            }
        }
        if (this.isAlive() && (this.isInWaterRainOrBubble() || this.isInPowderSnow)) {
            this.extinguishFire();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof ServerPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerTime > 0) {
            --this.lastHurtByPlayerTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if (this.lastHurtByMob != null) {
            if (!this.lastHurtByMob.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.level().getProfiler().pop();
    }

    @Override
    protected float getBlockSpeedFactor() {
        return Mth.lerp((float)this.getAttributeValue(Attributes.MOVEMENT_EFFICIENCY), super.getBlockSpeedFactor(), 1.0f);
    }

    protected void removeFrost() {
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributemodifiable != null && attributemodifiable.getModifier(SPEED_MODIFIER_POWDER_SNOW_ID) != null) {
            attributemodifiable.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
        }
    }

    protected void tryAddFrost() {
        int i;
        if (!this.getBlockStateOnLegacy().isAir() && (i = this.getTicksFrozen()) > 0) {
            AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributemodifiable == null) {
                return;
            }
            float f = -0.05f * this.getPercentFrozen();
            attributemodifiable.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, f, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(ServerLevel world, BlockPos pos) {
        EnchantmentHelper.runLocationChangedEffects(world, this);
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public float getScale() {
        AttributeMap attributemapbase = this.getAttributes();
        return attributemapbase == null ? 1.0f : this.sanitizeScale((float)attributemapbase.getValue(Attributes.SCALE));
    }

    protected float sanitizeScale(float scale) {
        return scale;
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot() {
        return !this.isBaby();
    }

    protected int decreaseAirSupply(int air) {
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.OXYGEN_BONUS);
        double d0 = attributemodifiable != null ? attributemodifiable.getValue() : 0.0;
        return d0 > 0.0 && this.random.nextDouble() >= 1.0 / (d0 + 1.0) ? air : air - 1;
    }

    protected int increaseAirSupply(int air) {
        return Math.min(air + 4, this.getMaxAirSupply());
    }

    public final int getExperienceReward(ServerLevel world, @Nullable Entity attacker) {
        return EnchantmentHelper.processMobExperience(world, attacker, this, this.getBaseExperienceReward());
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    @Nullable
    public LivingEntity getLastHurtByMob() {
        return this.lastHurtByMob;
    }

    @Override
    public LivingEntity getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(@Nullable Player attacking) {
        this.lastHurtByPlayer = attacking;
        this.lastHurtByPlayerTime = this.tickCount;
    }

    public void setLastHurtByMob(@Nullable LivingEntity attacker) {
        this.lastHurtByMob = attacker;
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public LivingEntity getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity target) {
        this.lastHurtMob = target instanceof LivingEntity ? (LivingEntity)target : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int despawnCounter) {
        this.noActionTime = despawnCounter;
    }

    public boolean shouldDiscardFriction() {
        return !this.frictionState.toBooleanOrElse(!this.discardFriction);
    }

    public void setDiscardFriction(boolean noDrag) {
        this.discardFriction = noDrag;
    }

    protected boolean doesEmitEquipEvent(EquipmentSlot slot) {
        return true;
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack oldStack, ItemStack newStack) {
        this.onEquipItem(slot, oldStack, newStack, false);
    }

    public void onEquipItem(EquipmentSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        boolean flag;
        boolean bl = flag = itemstack1.isEmpty() && itemstack.isEmpty();
        if (!(flag || ItemStack.isSameItemSameComponents(itemstack, itemstack1) || this.firstTick)) {
            Equipable equipable = Equipable.get(itemstack1);
            if (!this.level().isClientSide() && !this.isSpectator()) {
                if (!this.isSilent() && equipable != null && equipable.getEquipmentSlot() == enumitemslot && !silent) {
                    this.level().playSeededSound((Player)null, this.getX(), this.getY(), this.getZ(), equipable.getEquipSound(), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
                }
                if (this.doesEmitEquipEvent(enumitemslot)) {
                    this.gameEvent(equipable != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
                }
            }
        }
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (entity_removalreason == Entity.RemovalReason.KILLED || entity_removalreason == Entity.RemovalReason.DISCARDED) {
            this.triggerOnDeathMobEffects(entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.brain.clearMemories();
    }

    protected void triggerOnDeathMobEffects(Entity.RemovalReason reason) {
        for (MobEffectInstance mobeffect : this.getActiveEffects()) {
            mobeffect.onMobRemoved(this, reason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.activeEffects.clear();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.putString("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.putFloat("Health", this.getHealth());
        nbt.putShort("HurtTime", (short)this.hurtTime);
        nbt.putInt("HurtByTimestamp", this.lastHurtByMobTimestamp);
        nbt.putShort("DeathTime", (short)this.deathTime);
        nbt.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        nbt.put(ATTRIBUTES_FIELD, this.getAttributes().save());
        if (!this.activeEffects.isEmpty()) {
            ListTag nbttaglist = new ListTag();
            for (MobEffectInstance mobeffect : this.activeEffects.values()) {
                nbttaglist.add(mobeffect.save());
            }
            nbt.put(TAG_ACTIVE_EFFECTS, nbttaglist);
        }
        nbt.putBoolean("FallFlying", this.isFallFlying());
        this.getSleepingPos().ifPresent(blockposition -> {
            nbt.putInt("SleepingX", blockposition.getX());
            nbt.putInt("SleepingY", blockposition.getY());
            nbt.putInt("SleepingZ", blockposition.getZ());
        });
        DataResult<Tag> dataresult = this.brain.serializeStart(NbtOps.INSTANCE);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("Brain", (Tag)nbtbase));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        float absorptionAmount = nbt.getFloat("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.internalSetAbsorptionAmount(absorptionAmount);
        if (nbt.contains("Paper.FrictionState")) {
            String fs = nbt.getString("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LOGGER.error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
        if (nbt.contains(ATTRIBUTES_FIELD, 9) && this.level() != null && !this.level().isClientSide) {
            this.getAttributes().load(nbt.getList(ATTRIBUTES_FIELD, 10));
        }
        if (nbt.contains(TAG_ACTIVE_EFFECTS, 9)) {
            ListTag nbttaglist = nbt.getList(TAG_ACTIVE_EFFECTS, 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound1 = nbttaglist.getCompound(i);
                MobEffectInstance mobeffect = MobEffectInstance.load(nbttagcompound1);
                if (mobeffect == null) continue;
                this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            }
        }
        if (nbt.contains("Bukkit.MaxHealth")) {
            Tag nbtbase = nbt.get("Bukkit.MaxHealth");
            if (nbtbase.getId() == 5) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((FloatTag)nbtbase).getAsDouble());
            } else if (nbtbase.getId() == 3) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((IntTag)nbtbase).getAsDouble());
            }
        }
        if (nbt.contains("Health", 99)) {
            this.setHealth(nbt.getFloat("Health"));
        }
        this.hurtTime = nbt.getShort("HurtTime");
        this.deathTime = nbt.getShort("DeathTime");
        this.lastHurtByMobTimestamp = nbt.getInt("HurtByTimestamp");
        if (nbt.contains("Team", 8)) {
            boolean flag;
            String s = nbt.getString("Team");
            Scoreboard scoreboard = this.level().getScoreboard();
            PlayerTeam scoreboardteam = scoreboard.getPlayerTeam(s);
            if (!this.level().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof Player)) {
                scoreboardteam = null;
            }
            boolean bl = flag = scoreboardteam != null && scoreboard.addPlayerToTeam(this.getStringUUID(), scoreboardteam);
            if (!flag) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s);
            }
        }
        if (nbt.getBoolean("FallFlying")) {
            this.setSharedFlag(7, true);
        }
        if (nbt.contains("SleepingX", 99) && nbt.contains("SleepingY", 99) && nbt.contains("SleepingZ", 99)) {
            BlockPos blockposition = new BlockPos(nbt.getInt("SleepingX"), nbt.getInt("SleepingY"), nbt.getInt("SleepingZ"));
            if (this.position().distanceToSqr(blockposition.getX(), blockposition.getY(), blockposition.getZ()) < 256.0) {
                this.setSleepingPos(blockposition);
                this.entityData.set(Entity.DATA_POSE, Pose.SLEEPING);
                if (!this.firstTick) {
                    this.setPosToBed(blockposition);
                }
            }
        }
        if (nbt.contains("Brain", 10)) {
            this.brain = this.makeBrain(new Dynamic<Tag>(NbtOps.INSTANCE, nbt.get("Brain")));
        }
    }

    protected void tickEffects() {
        List<ParticleOptions> list;
        Iterator<Holder<MobEffect>> iterator = this.activeEffects.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                Holder<MobEffect> holder = iterator.next();
                MobEffectInstance mobeffect = this.activeEffects.get(holder);
                if (!mobeffect.tick(this, () -> this.onEffectUpdated(mobeffect, true, null))) {
                    EntityPotionEffectEvent event;
                    if (this.level().isClientSide || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.onEffectRemoved(mobeffect);
                    continue;
                }
                if (mobeffect.getDuration() % 600 != 0) continue;
                this.onEffectUpdated(mobeffect, false, null);
            }
        }
        catch (ConcurrentModificationException holder) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e : this.effectsToProcess) {
            if (e.effect != null) {
                this.addEffect(e.effect, e.cause);
                continue;
            }
            this.removeEffect(e.type, e.cause);
        }
        this.effectsToProcess.clear();
        if (this.effectsDirty) {
            if (!this.level().isClientSide) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
            }
            this.effectsDirty = false;
        }
        if (!(list = this.entityData.get(DATA_EFFECT_PARTICLES)).isEmpty()) {
            int j;
            boolean flag = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
            int i = this.isInvisible() ? 15 : 4;
            int n = j = flag ? 5 : 1;
            if (this.random.nextInt(i * j) == 0) {
                this.level().addParticle(Util.getRandom(list, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
        } else {
            this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
            this.updateSynchronizedMobEffectParticles();
        }
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleOptions> list = this.activeEffects.values().stream().filter(MobEffectInstance::isVisible).map(MobEffectInstance::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, list);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, LivingEntity.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean flag = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != flag) {
            this.setSharedFlag(6, flag);
        }
    }

    public double getVisibilityPercent(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.isDiscrete()) {
            d0 *= 0.8;
        }
        if (this.isInvisible()) {
            float f = this.getArmorCoverPercentage();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d0 *= 0.7 * (double)f;
        }
        if (entity != null) {
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
            EntityType<?> entitytypes = entity.getType();
            if (entitytypes == EntityType.SKELETON && itemstack.is(Items.SKELETON_SKULL) || entitytypes == EntityType.ZOMBIE && itemstack.is(Items.ZOMBIE_HEAD) || entitytypes == EntityType.PIGLIN && itemstack.is(Items.PIGLIN_HEAD) || entitytypes == EntityType.PIGLIN_BRUTE && itemstack.is(Items.PIGLIN_HEAD) || entitytypes == EntityType.CREEPER && itemstack.is(Items.CREEPER_HEAD)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean canAttack(LivingEntity target) {
        return target instanceof Player && this.level().getDifficulty() == Difficulty.PEACEFUL ? false : target.canBeSeenAsEnemy();
    }

    public boolean canAttack(LivingEntity entity, TargetingConditions predicate) {
        return predicate.test(this, entity);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffectInstance> effects) {
        MobEffectInstance mobeffect;
        Iterator<MobEffectInstance> iterator = effects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).isVisible() || mobeffect.isAmbient());
        return false;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.level().isClientSide) {
            return false;
        }
        Iterator<MobEffectInstance> iterator = this.activeEffects.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffectInstance effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.onEffectRemoved(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffectInstance> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffect> effect) {
        return this.activeEffects.containsKey(effect);
    }

    @Nullable
    public MobEffectInstance getEffect(Holder<MobEffect> effect) {
        return this.activeEffects.get(effect);
    }

    public final boolean addEffect(MobEffectInstance effect) {
        return this.addEffect(effect, (Entity)null);
    }

    public boolean addEffect(MobEffectInstance mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean addEffect(MobEffectInstance effect, @Nullable Entity source) {
        return this.addEffect(effect, source, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffectInstance mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, entity, cause, true);
    }

    public boolean addEffect(MobEffectInstance mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.canBeAffected(mobeffect)) {
            return false;
        }
        MobEffectInstance mobeffect1 = this.activeEffects.get(mobeffect.getEffect());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffectInstance(mobeffect1).update(mobeffect);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobeffect1 == null) {
            this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            this.onEffectAdded(mobeffect, entity);
            flag = true;
            mobeffect.onEffectAdded(this);
        } else if (override) {
            mobeffect1.update(mobeffect);
            this.onEffectUpdated(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.onEffectStarted(this);
        return flag;
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return this.getType().is(EntityTypeTags.IMMUNE_TO_INFESTED) ? !effect.is(MobEffects.INFESTED) : (this.getType().is(EntityTypeTags.IMMUNE_TO_OOZING) ? !effect.is(MobEffects.OOZING) : (!this.getType().is(EntityTypeTags.IGNORES_POISON_AND_REGEN) ? true : !effect.is(MobEffects.REGENERATION) && !effect.is(MobEffects.POISON)));
    }

    public void forceAddEffect(MobEffectInstance effect, @Nullable Entity source) {
        if (this.canBeAffected(effect)) {
            MobEffectInstance mobeffect1 = this.activeEffects.put(effect.getEffect(), effect);
            if (mobeffect1 == null) {
                this.onEffectAdded(effect, source);
            } else {
                effect.copyBlendState(mobeffect1);
                this.onEffectUpdated(effect, true, source);
            }
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(EntityTypeTags.INVERTED_HEALING_AND_HARM);
    }

    @Nullable
    public MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffectInstance effect = this.activeEffects.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.activeEffects.remove(holder);
    }

    public boolean removeEffect(Holder<MobEffect> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffect> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffectInstance mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.onEffectRemoved(mobeffect);
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffectInstance effect, @Nullable Entity source) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            effect.getEffect().value().addAttributeModifiers(this.getAttributes(), effect.getAmplifier());
            this.sendEffectToPassengers(effect);
        }
    }

    public void sendEffectToPassengers(MobEffectInstance effect) {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), effect, false));
        }
    }

    protected void onEffectUpdated(MobEffectInstance effect, boolean reapplyEffect, @Nullable Entity source) {
        this.effectsDirty = true;
        if (reapplyEffect && !this.level().isClientSide) {
            MobEffect mobeffectlist = effect.getEffect().value();
            mobeffectlist.removeAttributeModifiers(this.getAttributes());
            mobeffectlist.addAttributeModifiers(this.getAttributes(), effect.getAmplifier());
            this.refreshDirtyAttributes();
        }
        if (!this.level().isClientSide) {
            this.sendEffectToPassengers(effect);
        }
    }

    protected void onEffectRemoved(MobEffectInstance effect) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            effect.getEffect().value().removeAttributeModifiers(this.getAttributes());
            this.refreshDirtyAttributes();
            for (Entity entity : this.getPassengers()) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer entityplayer = (ServerPlayer)entity;
                entityplayer.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), effect.getEffect()));
            }
        }
    }

    private void refreshDirtyAttributes() {
        Set<AttributeInstance> set = this.getAttributes().getAttributesToUpdate();
        for (AttributeInstance attributemodifiable : set) {
            this.onAttributeUpdated(attributemodifiable.getAttribute());
        }
        set.clear();
    }

    private void onAttributeUpdated(Holder<Attribute> attribute) {
        if (attribute.is(Attributes.MAX_HEALTH)) {
            float f = this.getMaxHealth();
            if (this.getHealth() > f) {
                this.setHealth(f);
            }
        } else if (attribute.is(Attributes.MAX_ABSORPTION)) {
            float f = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > f) {
                this.setAbsorptionAmount(f);
            }
        }
    }

    public void heal(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(f, regainReason, false);
    }

    public void heal(float f, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float f1 = this.getHealth();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f, regainReason, isFastRegen);
            if (this.valid) {
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.setHealth((float)((double)this.getHealth() + event.getAmount()));
            }
        }
    }

    public float getHealth() {
        if (this instanceof ServerPlayer) {
            return (float)((ServerPlayer)this).getBukkitEntity().getHealth();
        }
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float health) {
        if (Float.isNaN(health)) {
            health = this.getMaxHealth();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.getScoreboardName() + " had NaN health set");
            }
        }
        if (this instanceof ServerPlayer) {
            CraftPlayer player = ((ServerPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(Mth.clamp(health, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean flag2;
        float f1;
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.level().isClientSide) {
            return false;
        }
        if (this.isRemoved() || this.dead || this.getHealth() <= 0.0f) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping() && !this.level().isClientSide) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        float originalAmount = f1 = amount;
        boolean flag = amount > 0.0f && this.isDamageSourceBlocked(source);
        float f2 = 0.0f;
        this.walkAnimation.setSpeed(1.5f);
        boolean flag1 = true;
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f && !source.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (amount <= this.lastHurt) {
                return false;
            }
            event = this.handleEntityDamage(source, amount);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(source, (float)event.getFinalDamage() - this.lastHurt, event)) {
                return false;
            }
            if (this instanceof ServerPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.lastHurt = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(source, amount);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(source, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof ServerPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.lastHurt = amount;
            this.invulnerableTime = this.invulnerableDuration;
            this.hurtTime = this.hurtDuration = 10;
        }
        Entity entity1 = source.getEntity();
        if (entity1 != null) {
            Wolf entitywolf;
            if (entity1 instanceof LivingEntity) {
                LivingEntity entityliving1 = (LivingEntity)entity1;
                if (!(source.is(DamageTypeTags.NO_ANGER) || source.is(DamageTypes.WIND_CHARGE) && this.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                    this.setLastHurtByMob(entityliving1);
                }
            }
            if (entity1 instanceof Player) {
                Player entityhuman = (Player)entity1;
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = entityhuman;
            } else if (entity1 instanceof Wolf && (entitywolf = (Wolf)entity1).isTame()) {
                Player entityhuman1;
                this.lastHurtByPlayerTime = 100;
                LivingEntity entityliving2 = entitywolf.getOwner();
                this.lastHurtByPlayer = entityliving2 instanceof Player ? (entityhuman1 = (Player)entityliving2) : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.level().broadcastEntityEvent(this, (byte)29);
            } else {
                this.level().broadcastDamageEvent(this, source);
            }
            if (!source.is(DamageTypeTags.NO_IMPACT) && !flag) {
                this.markHurt();
            }
            if (!source.is(DamageTypeTags.NO_KNOCKBACK)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity2 = source.getDirectEntity();
                if (entity2 instanceof Projectile) {
                    Projectile iprojectile = (Projectile)entity2;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.calculateHorizontalHurtKnockbackDirection(this, source);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (source.getSourcePosition() != null) {
                    d0 = source.getSourcePosition().x() - this.getX();
                    d1 = source.getSourcePosition().z() - this.getZ();
                }
                if (Math.abs(d0) > 200.0) {
                    d0 = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d0, d1, entity1, entity1 == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.indicateDamage(d0, d1);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(source)) {
                this.silentDeath = !flag1;
                this.die(source);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.playHurtSound(source);
        }
        boolean bl = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = source;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffectInstance mobeffect : this.getActiveEffects()) {
                mobeffect.onMobHurt(this, source, amount);
            }
        }
        if (this instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)this, source, f1, amount, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                ((ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f2 * 10.0f));
            }
        }
        if (entity1 instanceof ServerPlayer) {
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)entity1, this, source, f1, amount, flag);
        }
        return flag2;
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void blockUsingShield(LivingEntity attacker) {
        attacker.blockedByShield(this);
    }

    protected void blockedByShield(LivingEntity target) {
        target.knockback(0.5, target.getX() - this.getX(), target.getZ() - this.getZ(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean checkTotemDeathProtection(DamageSource source) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack itemstack = null;
        InteractionHand[] aenumhand = InteractionHand.values();
        int i = aenumhand.length;
        InteractionHand hand = null;
        ItemStack itemstack1 = ItemStack.EMPTY;
        for (int j = 0; j < i; ++j) {
            InteractionHand enumhand = aenumhand[j];
            itemstack1 = this.getItemInHand(enumhand);
            if (!itemstack1.is(Items.TOTEM_OF_UNDYING)) continue;
            hand = enumhand;
            itemstack = itemstack1.copy();
            break;
        }
        org.bukkit.inventory.EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((org.bukkit.entity.LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.isEmpty() && itemstack != null) {
                itemstack1.shrink(1);
            }
            if (itemstack != null && this instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)this;
                entityplayer.awardStat(Stats.ITEM_USED.get(Items.TOTEM_OF_UNDYING));
                CriteriaTriggers.USED_TOTEM.trigger(entityplayer, itemstack);
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource damageSource) {
        this.makeSound(this.getHurtSound(damageSource));
    }

    public void makeSound(@Nullable SoundEvent sound) {
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isDamageSourceBlocked(DamageSource source) {
        Vec3 vec3d;
        AbstractArrow entityarrow;
        Entity entity = source.getDirectEntity();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (entityarrow = (AbstractArrow)entity).getPierceLevel() > 0) {
            flag = true;
        }
        if (!source.is(DamageTypeTags.BYPASSES_SHIELD) && this.isBlocking() && !flag && (vec3d = source.getSourcePosition()) != null) {
            Vec3 vec3d1 = this.calculateViewVector(0.0f, this.getYHeadRot());
            Vec3 vec3d2 = vec3d.vectorTo(this.position());
            vec3d2 = new Vec3(vec3d2.x, 0.0, vec3d2.z).normalize();
            return vec3d2.dot(vec3d1) < 0.0;
        }
        return false;
    }

    private void breakItem(ItemStack stack) {
        if (!stack.isEmpty()) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), stack.getBreakingSound(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(stack, 5);
        }
    }

    public void die(DamageSource damageSource) {
        if (!this.isRemoved() && !this.dead) {
            Entity entity = damageSource.getEntity();
            LivingEntity entityliving = this.getKillCredit();
            this.dead = true;
            Level world = this.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(worldserver, damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof Mob) {
                        for (EquipmentSlot slot : this.clearedEquipmentSlots) {
                            this.setItemSlot(slot, ItemStack.EMPTY);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.isSleeping()) {
                        this.stopSleeping();
                    }
                    if (!this.level().isClientSide && this.hasCustomName() && SpigotConfig.logNamedDeaths) {
                        LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
                    }
                    this.getCombatTracker().recheckStatus();
                    if (entity != null) {
                        entity.killedEntity((ServerLevel)this.level(), this);
                    }
                    this.gameEvent(GameEvent.ENTITY_DIE);
                } else {
                    this.dead = false;
                    this.setHealth((float)deathEvent.getReviveHealth());
                }
                this.createWitherRose(entityliving);
            }
            if (this.dead) {
                this.level().broadcastEntityEvent(this, (byte)3);
                this.setPose(Pose.DYING);
            }
        }
    }

    protected void createWitherRose(@Nullable LivingEntity adversary) {
        if (!this.level().isClientSide) {
            boolean flag = false;
            if (this.dead && adversary instanceof WitherBoss) {
                if (this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    BlockPos blockposition = this.blockPosition();
                    BlockState iblockdata = Blocks.WITHER_ROSE.defaultBlockState();
                    if (this.level().getBlockState(blockposition).isAir() && iblockdata.canSurvive(this.level(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.level(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.level().addFreshEntity(entityitem);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(ServerLevel world, DamageSource damageSource) {
        boolean flag = this.lastHurtByPlayerTime > 0;
        this.dropEquipment();
        if (this.shouldDropLoot() && world.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.dropCustomDeathLoot(world, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            LivingEntity entityliving = this.getKillCredit();
            if (this.deathScore >= 0 && entityliving != null) {
                entityliving.awardKillScore(this, this.deathScore, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.dropExperience(damageSource.getEntity());
        return deathEvent;
    }

    protected void dropEquipment() {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(@Nullable Entity entity) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerTime > 0 && this.shouldDropExperience() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
                return this.getExperienceReward(worldserver, entity);
            }
        }
        return 0;
    }

    protected void dropExperience(@Nullable Entity attacker) {
        if (!(this instanceof EnderDragon)) {
            ExperienceOrb.award((ServerLevel)this.level(), this.position(), this.expToDrop, this instanceof ServerPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, attacker, this);
            this.expToDrop = 0;
        }
    }

    protected void dropCustomDeathLoot(ServerLevel world, DamageSource source, boolean causedByPlayer) {
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.getType().getDefaultLootTable();
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected float getKnockback(Entity target, DamageSource damageSource) {
        float f = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return EnchantmentHelper.modifyKnockback(worldserver, this.getWeaponItem(), target, damageSource, f);
        }
        return f;
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer) {
        ResourceKey<LootTable> resourcekey = this.getLootTable();
        LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(resourcekey);
        LootParams.Builder lootparams_a = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, damageSource.getDirectEntity());
        if (causedByPlayer && this.lastHurtByPlayer != null) {
            lootparams_a = lootparams_a.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        LootParams lootparams = lootparams_a.create(LootContextParamSets.ENTITY);
        loottable.getRandomItems(lootparams, this.getLootTableSeed(), this::spawnAtLocation);
    }

    public void knockback(double strength, double x, double z) {
        this.knockback(strength, x, z, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, @Nullable Entity attacker, EntityKnockbackEvent.Cause cause) {
        d0 *= 1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        Vec3 vec3d = this.getDeltaMovement();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3 vec3d1 = new Vec3(d1, 0.0, d2).normalize().scale(d0);
        Vec3 finalVelocity = new Vec3(vec3d.x / 2.0 - vec3d1.x, this.onGround() ? Math.min(0.4, vec3d.y / 2.0 + d0) : vec3d.y, vec3d.z / 2.0 - vec3d1.z);
        Vec3 diff = finalVelocity.subtract(vec3d);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, cause, d0, diff);
        if (event.isCancelled()) {
            return;
        }
        this.hasImpulse = true;
        this.setDeltaMovement(vec3d.add(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void indicateDamage(double deltaX, double deltaZ) {
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.GENERIC_HURT;
    }

    @Nullable
    public SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    private SoundEvent getFallDamageSound(int distance) {
        return distance > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AABB getHitbox() {
        AABB axisalignedbb = this.getBoundingBox();
        Entity entity = this.getVehicle();
        if (entity != null) {
            Vec3 vec3d = entity.getPassengerRidingPosition(this);
            return axisalignedbb.setMinY(Math.max(vec3d.y, axisalignedbb.minY));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments() {
        return this.activeLocationDependentEnchantments;
    }

    public Fallsounds getFallSounds() {
        return new Fallsounds(SoundEvents.GENERIC_SMALL_FALL, SoundEvents.GENERIC_BIG_FALL);
    }

    protected SoundEvent getDrinkingSound(ItemStack stack) {
        return stack.getDrinkingSound();
    }

    public SoundEvent getEatingSound(ItemStack stack) {
        return stack.getEatingSound();
    }

    public SoundEvent getHurtSound0(DamageSource damagesource) {
        return this.getHurtSound(damagesource);
    }

    public SoundEvent getDeathSound0() {
        return this.getDeathSound();
    }

    public SoundEvent getFallDamageSound0(int fallHeight) {
        return this.getFallDamageSound(fallHeight);
    }

    public SoundEvent getDrinkingSound0(ItemStack itemstack) {
        return this.getDrinkingSound(itemstack);
    }

    public SoundEvent getEatingSound0(ItemStack itemstack) {
        return this.getEatingSound(itemstack);
    }

    public Optional<BlockPos> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPos blockposition = this.blockPosition();
        BlockState iblockdata = this.getInBlockState();
        if (iblockdata.is(BlockTags.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.getBlock() instanceof TrapDoorBlock && this.trapdoorUsableAsLadder(blockposition, iblockdata)) {
            this.lastClimbablePos = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPos pos, BlockState state) {
        if (!state.getValue(TrapDoorBlock.OPEN).booleanValue()) {
            return false;
        }
        BlockState iblockdata1 = this.level().getBlockState(pos.below());
        return iblockdata1.is(Blocks.LADDER) && iblockdata1.getValue(LadderBlock.FACING) == state.getValue(HorizontalDirectionalBlock.FACING);
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f && !this.dead;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float health) {
        return Mth.floor(health + 3.0f);
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
        int i = this.calculateFallDamage(fallDistance, damageMultiplier);
        if (i > 0) {
            if (!this.hurt(damageSource, i)) {
                return true;
            }
            this.playSound(this.getFallDamageSound(i), 1.0f, 1.0f);
            this.playBlockFallSound();
            return true;
        }
        return flag;
    }

    protected int calculateFallDamage(float fallDistance, float damageMultiplier) {
        if (this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        float f2 = (float)this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
        float f3 = fallDistance - f2;
        return Mth.ceil((double)(f3 * damageMultiplier) * this.getAttributeValue(Attributes.FALL_DAMAGE_MULTIPLIER));
    }

    protected void playBlockFallSound() {
        if (!this.isSilent()) {
            int i = Mth.floor(this.getX());
            int j = Mth.floor(this.getY() - (double)0.2f);
            int k = Mth.floor(this.getZ());
            BlockState iblockdata = this.level().getBlockState(new BlockPos(i, j, k));
            if (!iblockdata.isAir()) {
                SoundType soundeffecttype = iblockdata.getSoundType();
                this.playSound(soundeffecttype.getFallSound(), soundeffecttype.getVolume() * 0.5f, soundeffecttype.getPitch() * 0.75f);
            }
        }
    }

    @Override
    public void animateHurt(float yaw) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return Mth.floor(this.getAttributeValue(Attributes.ARMOR));
    }

    protected void hurtArmor(DamageSource source, float amount) {
    }

    protected void hurtHelmet(DamageSource source, float amount) {
    }

    protected void hurtCurrentlyUsedShield(float amount) {
    }

    protected void doHurtEquipment(DamageSource source, float amount, EquipmentSlot ... slots) {
        if (amount > 0.0f) {
            int i = (int)Math.max(1.0f, amount / 4.0f);
            EquipmentSlot[] aenumitemslot1 = slots;
            int j = slots.length;
            for (int k = 0; k < j; ++k) {
                EquipmentSlot enumitemslot = aenumitemslot1[k];
                ItemStack itemstack = this.getItemBySlot(enumitemslot);
                if (!(itemstack.getItem() instanceof ArmorItem) || !itemstack.canBeHurtBy(source)) continue;
                itemstack.hurtAndBreak(i, this, enumitemslot);
            }
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource source, float amount) {
        if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            amount = CombatRules.getDamageAfterAbsorb(this, amount, source, this.getArmorValue(), (float)this.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        return amount;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource source, float amount) {
        float f4;
        if (source.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return amount;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return amount;
        }
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            f4 = EnchantmentHelper.getDamageProtection(worldserver, this, source);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            amount = CombatRules.getDamageAfterMagicAbsorb(amount, f4);
        }
        return amount;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f) {
        float originalDamage = f;
        Function<Double, Double> freezing = new Function<Double, Double>(){

            public Double apply(Double f) {
                if (damagesource.is(DamageTypeTags.IS_FREEZING) && LivingEntity.this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                    return -(f - f * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f)).floatValue();
        Function<Double, Double> hardHat = new Function<Double, Double>(){

            public Double apply(Double f) {
                if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !LivingEntity.this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                    return -(f - f * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f += freezingModifier))).floatValue();
        Function<Double, Double> blocking = new Function<Double, Double>(){

            public Double apply(Double f) {
                return -(LivingEntity.this.isDamageSourceBlocked(damagesource) ? f : 0.0);
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f += hardHatModifier))).floatValue();
        Function<Double, Double> armor = new Function<Double, Double>(){

            public Double apply(Double f) {
                return -(f - (double)LivingEntity.this.getDamageAfterArmorAbsorb(damagesource, f.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f += blockingModifier))).floatValue();
        Function<Double, Double> resistance = new Function<Double, Double>(){

            public Double apply(Double f) {
                if (!damagesource.is(DamageTypeTags.BYPASSES_EFFECTS) && LivingEntity.this.hasEffect(MobEffects.DAMAGE_RESISTANCE) && !damagesource.is(DamageTypeTags.BYPASSES_RESISTANCE)) {
                    int i = (LivingEntity.this.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5;
                    int j = 25 - i;
                    float f1 = f.floatValue() * (float)j;
                    return -(f - (double)(f1 / 25.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f += armorModifier))).floatValue();
        Function<Double, Double> magic = new Function<Double, Double>(){

            public Double apply(Double f) {
                return -(f - (double)LivingEntity.this.getDamageAfterMagicAbsorb(damagesource, f.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f += resistanceModifier))).floatValue();
        Function<Double, Double> absorption = new Function<Double, Double>(){

            public Double apply(Double f) {
                return -Math.max(f - Math.max(f - (double)LivingEntity.this.getAbsorptionAmount(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(DamageSource damagesource, float f, EntityDamageEvent event) {
        if (!this.isInvulnerableTo(damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.getEntity() instanceof Player) {
                if (damagesource.getEntity() instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)damagesource.getEntity();
                    if (new PlayerAttackEntityCooldownResetEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.getAttackStrengthScale(0.0f)).callEvent()) {
                        player.resetAttackStrengthTicker();
                    }
                } else {
                    ((Player)damagesource.getEntity()).resetAttackStrengthTicker();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof ServerPlayer) {
                    ((ServerPlayer)this).awardStat(Stats.DAMAGE_RESISTED, Math.round(f3 * 10.0f));
                } else if (damagesource.getEntity() instanceof ServerPlayer) {
                    ((ServerPlayer)damagesource.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                this.hurtHelmet(damagesource, f);
            }
            if (!damagesource.is(DamageTypeTags.BYPASSES_ARMOR)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.hurtArmor(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.hurtCurrentlyUsedShield((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.getDirectEntity();
                if (!damagesource.is(DamageTypeTags.IS_PROJECTILE) && entity2 instanceof LivingEntity && entity2.distanceToSqr(this) <= 40000.0) {
                    this.blockUsingShield((LivingEntity)entity2);
                }
            }
            boolean human = this instanceof Player;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.setAbsorptionAmount(Math.max(this.getAbsorptionAmount() - absorptionModifier, 0.0f));
            float f2 = absorptionModifier;
            if (f2 > 0.0f && f2 < 3.4028235E37f && this instanceof Player) {
                ((Player)this).awardStat(Stats.DAMAGE_ABSORBED, Math.round(f2 * 10.0f));
            }
            if (f2 > 0.0f && f2 < 3.4028235E37f && (entity = damagesource.getEntity()) instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                entityplayer.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f2 * 10.0f));
            }
            if (f > 0.0f || !human) {
                if (human) {
                    ((Player)this).causeFoodExhaustion(damagesource.getFoodExhaustion(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f < 3.4028235E37f) {
                        ((Player)this).awardStat(Stats.DAMAGE_TAKEN, Math.round(f * 10.0f));
                    }
                }
                this.getCombatTracker().recordDamage(damagesource, f);
                this.setHealth(this.getHealth() - f);
                if (!human) {
                    this.setAbsorptionAmount(this.getAbsorptionAmount() - f);
                }
                this.gameEvent(GameEvent.ENTITY_DAMAGE);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof ServerPlayer) {
                    CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)this, damagesource, originalDamage, f, true);
                    f2 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f2 > 0.0f && f2 < 3.4028235E37f) {
                        ((ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.getEntity() instanceof ServerPlayer) {
                    CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)damagesource.getEntity(), this, damagesource, originalDamage, f, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public LivingEntity getKillCredit() {
        return this.lastHurtByPlayer != null ? this.lastHurtByPlayer : (this.lastHurtByMob != null ? this.lastHurtByMob : null);
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(Attributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(Attributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int stuckArrowCount) {
        this.setArrowCount(stuckArrowCount, false);
    }

    public final void setArrowCount(int i, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.getArrowCount(), i, flag);
        if (event.isCancelled()) {
            return;
        }
        this.entityData.set(DATA_ARROW_COUNT_ID, event.getNewAmount());
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int stingerCount) {
        this.entityData.set(DATA_STINGER_COUNT_ID, stingerCount);
    }

    private int getCurrentSwingDuration() {
        return MobEffectUtil.hasDigSpeed(this) ? 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this)) : (this.hasEffect(MobEffects.DIG_SLOWDOWN) ? 6 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2 : 6);
    }

    public void swing(InteractionHand hand) {
        this.swing(hand, false);
    }

    public void swing(InteractionHand hand, boolean fromServerPlayer) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = hand;
            if (this.level() instanceof ServerLevel) {
                ClientboundAnimatePacket packetplayoutanimation = new ClientboundAnimatePacket(this, hand == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache chunkproviderserver = ((ServerLevel)this.level()).getChunkSource();
                if (fromServerPlayer) {
                    chunkproviderserver.broadcastAndSend(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.broadcast(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource damageSource) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = 20;
        this.hurtTime = this.hurtDuration = 10;
        SoundEvent soundeffect = this.getHurtSound(damageSource);
        if (soundeffect != null) {
            this.playSound(soundeffect, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.hurt(this.damageSources().generic(), 0.0f);
        this.lastDamageSource = damageSource;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte status) {
        switch (status) {
            case 3: {
                SoundEvent soundeffect = this.getDeathSound();
                if (soundeffect != null) {
                    this.playSound(soundeffect, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof Player) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 29: {
                this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 30: {
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i = 0; i < 128; ++i) {
                    double d0 = (double)i / 127.0;
                    float f = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = Mth.lerp(d0, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double d2 = Mth.lerp(d0, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double d3 = Mth.lerp(d0, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(ParticleTypes.PORTAL, d1, d2, d3, f, f1, f2);
                }
                return;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.FEET));
                break;
            }
            case 54: {
                HoneyBlock.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.BODY));
                break;
            }
            default: {
                super.handleEntityEvent(status);
            }
        }
    }

    private void makePoofParticles() {
        for (int i = 0; i < 20; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private void swapHandItems() {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.OFFHAND);
        this.setItemSlot(EquipmentSlot.OFFHAND, this.getItemBySlot(EquipmentSlot.MAINHAND));
        this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), this.level().getWorld().getVoidDamageAmount());
    }

    protected void updateSwingTime() {
        int i = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= i) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)i;
    }

    @Nullable
    public AttributeInstance getAttribute(Holder<Attribute> attribute) {
        return this.getAttributes().getInstance(attribute);
    }

    public double getAttributeValue(Holder<Attribute> attribute) {
        return this.getAttributes().getValue(attribute);
    }

    public double getAttributeBaseValue(Holder<Attribute> attribute) {
        return this.getAttributes().getBaseValue(attribute);
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EquipmentSlot.OFFHAND);
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        return this.getMainHandItem();
    }

    public boolean isHolding(net.minecraft.world.item.Item item) {
        return this.isHolding((ItemStack itemstack) -> itemstack.is(item));
    }

    public boolean isHolding(Predicate<ItemStack> predicate) {
        return predicate.test(this.getMainHandItem()) || predicate.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(EquipmentSlot.MAINHAND);
        }
        if (hand == InteractionHand.OFF_HAND) {
            return this.getItemBySlot(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void setItemInHand(InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        } else {
            if (hand != InteractionHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.setItemSlot(EquipmentSlot.OFFHAND, stack);
        }
    }

    public boolean hasItemInSlot(EquipmentSlot slot) {
        return !this.getItemBySlot(slot).isEmpty();
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return false;
    }

    public abstract Iterable<ItemStack> getArmorSlots();

    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    public void setItemSlot(EquipmentSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.setItemSlot(enumitemslot, itemstack);
    }

    public abstract void setItemSlot(EquipmentSlot var1, ItemStack var2);

    public Iterable<ItemStack> getHandSlots() {
        return List.of();
    }

    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        return this.getArmorSlots();
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorAndBodyArmorSlots());
    }

    protected void verifyEquippedItem(ItemStack stack) {
        stack.getItem().verifyComponentsAfterLoad(stack);
    }

    public float getArmorCoverPercentage() {
        Iterable<ItemStack> iterable = this.getArmorSlots();
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.isEmpty()) {
                ++j;
            }
            ++i;
        }
        return i > 0 ? (float)j / (float)i : 0.0f;
    }

    @Override
    public void setSprinting(boolean sprinting) {
        super.setSprinting(sprinting);
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
        attributemodifiable.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (sprinting) {
            attributemodifiable.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity entity) {
        if (!this.isSleeping()) {
            super.push(entity);
        }
    }

    private void dismountVehicle(Entity vehicle) {
        Vec3 vec3d;
        if (this.isRemoved()) {
            vec3d = this.position();
        } else if (!vehicle.isRemoved() && !this.level().getBlockState(vehicle.blockPosition()).is(BlockTags.PORTALS)) {
            vec3d = vehicle.getDismountLocationForPassenger(this);
        } else {
            double d0 = Math.max(this.getY(), vehicle.getY());
            vec3d = new Vec3(this.getX(), d0, this.getZ());
        }
        this.dismountTo(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float strength) {
        return (float)this.getAttributeValue(Attributes.JUMP_STRENGTH) * strength * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP).getAmplifier() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void jumpFromGround() {
        float f = this.getJumpPower();
        if (f > 1.0E-5f) {
            Vec3 vec3d = this.getDeltaMovement();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof Player) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.setDeltaMovement(vec3d.x, f, vec3d.z);
            if (this.isSprinting()) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.addDeltaMovement(new Vec3((double)(-Mth.sin(f1)) * 0.2, 0.0, (double)Mth.cos(f1) * 0.2));
                }
            }
            this.hasImpulse = true;
        }
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<Fluid> fluid) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(FluidState state) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(Attributes.GRAVITY);
    }

    public void travel(Vec3 movementInput) {
        if (this.isControlledByLocalInstance()) {
            boolean flag;
            double d0 = this.getGravity();
            boolean bl = flag = this.getDeltaMovement().y <= 0.0;
            if (flag && this.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = Math.min(d0, 0.01);
            }
            FluidState fluid = this.level().getFluidState(this.blockPosition());
            if (this.isInWater() && this.isAffectedByFluids() && !this.canStandOnFluid(fluid)) {
                double d1 = this.getY();
                float f = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                float f1 = 0.02f;
                float f2 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                if (!this.onGround()) {
                    f2 *= 0.5f;
                }
                if (f2 > 0.0f) {
                    f += (0.54600006f - f) * f2;
                    f1 += (this.getSpeed() - f1) * f2;
                }
                if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    f = 0.96f;
                }
                this.moveRelative(f1, movementInput);
                this.move(MoverType.SELF, this.getDeltaMovement());
                Vec3 vec3d1 = this.getDeltaMovement();
                if (this.horizontalCollision && this.onClimbable()) {
                    vec3d1 = new Vec3(vec3d1.x, 0.2, vec3d1.z);
                }
                this.setDeltaMovement(vec3d1.multiply(f, 0.8f, f));
                Vec3 vec3d2 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                this.setDeltaMovement(vec3d2);
                if (this.horizontalCollision && this.isFree(vec3d2.x, vec3d2.y + (double)0.6f - this.getY() + d1, vec3d2.z)) {
                    this.setDeltaMovement(vec3d2.x, 0.3f, vec3d2.z);
                }
            } else if (this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid(fluid)) {
                Vec3 vec3d3;
                double d1 = this.getY();
                this.moveRelative(0.02f, movementInput);
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                    vec3d3 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec3d3);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                }
                if (d0 != 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.getDeltaMovement();
                if (this.horizontalCollision && this.isFree(vec3d3.x, vec3d3.y + (double)0.6f - this.getY() + d1, vec3d3.z)) {
                    this.setDeltaMovement(vec3d3.x, 0.3f, vec3d3.z);
                }
            } else if (this.isFallFlying()) {
                double d7;
                float f3;
                double d6;
                this.checkSlowFallDistance();
                Vec3 vec3d4 = this.getDeltaMovement();
                Vec3 vec3d5 = this.getLookAngle();
                float f = this.getXRot() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.x * vec3d5.x + vec3d5.z * vec3d5.z);
                double d3 = vec3d4.horizontalDistance();
                double d4 = vec3d5.length();
                double d5 = Math.cos(f);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.getDeltaMovement().add(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.y < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.y * -0.1 * d5;
                    vec3d4 = vec3d4.add(vec3d5.x * d6 / d2, d6, vec3d5.z * d6 / d2);
                }
                if (f < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-Mth.sin(f)) * 0.04;
                    vec3d4 = vec3d4.add(-vec3d5.x * d6 / d2, d6 * 3.2, -vec3d5.z * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.add((vec3d5.x / d2 * d3 - vec3d4.x) * 0.1, 0.0, (vec3d5.z / d2 * d3 - vec3d4.z) * 0.1);
                }
                this.setDeltaMovement(vec3d4.multiply(0.99f, 0.98f, 0.99f));
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.horizontalCollision && !this.level().isClientSide && (f3 = (float)((d7 = d3 - (d6 = this.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                    this.playSound(this.getFallDamageSound((int)f3), 1.0f, 1.0f);
                    this.hurt(this.damageSources().flyIntoWall(), f3);
                }
                if (this.onGround() && !this.level().isClientSide && this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.setSharedFlag(7, false);
                }
            } else {
                BlockPos blockposition = this.getBlockPosBelowThatAffectsMyMovement();
                float f4 = this.level().getBlockState(blockposition).getBlock().getFriction();
                float f = this.onGround() ? f4 * 0.91f : 0.91f;
                Vec3 vec3d6 = this.handleRelativeFrictionAndCalculateMovement(movementInput, f4);
                double d8 = vec3d6.y;
                d8 = this.hasEffect(MobEffects.LEVITATION) ? (d8 += (0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec3d6.y) * 0.2) : (this.level().isClientSide && !this.level().hasChunkAt(blockposition) ? (this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0) : (d8 -= d0));
                if (this.shouldDiscardFriction()) {
                    this.setDeltaMovement(vec3d6.x, d8, vec3d6.z);
                } else {
                    this.setDeltaMovement(vec3d6.x * (double)f, this instanceof FlyingAnimal ? d8 * (double)f : d8 * (double)0.98f, vec3d6.z * (double)f);
                }
            }
        }
        this.calculateEntityAnimation(this instanceof FlyingAnimal);
    }

    private void travelRidden(Player controllingPlayer, Vec3 movementInput) {
        Vec3 vec3d1 = this.getRiddenInput(controllingPlayer, movementInput);
        this.tickRidden(controllingPlayer, vec3d1);
        if (this.isControlledByLocalInstance()) {
            this.setSpeed(this.getRiddenSpeed(controllingPlayer));
            this.travel(vec3d1);
        } else {
            this.calculateEntityAnimation(false);
            this.setDeltaMovement(Vec3.ZERO);
            this.tryCheckInsideBlocks();
        }
    }

    protected void tickRidden(Player controllingPlayer, Vec3 movementInput) {
    }

    protected Vec3 getRiddenInput(Player controllingPlayer, Vec3 movementInput) {
        return movementInput;
    }

    protected float getRiddenSpeed(Player controllingPlayer) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean flutter) {
        float f = (float)Mth.length(this.getX() - this.xo, flutter ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        this.updateWalkAnimation(f);
    }

    protected void updateWalkAnimation(float posDelta) {
        float f1 = Math.min(posDelta * 4.0f, 1.0f);
        this.walkAnimation.update(f1, 0.4f);
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 movementInput, float slipperiness) {
        this.moveRelative(this.getFrictionInfluencedSpeed(slipperiness), movementInput);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 vec3d1 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.getInBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            vec3d1 = new Vec3(vec3d1.x, 0.2, vec3d1.z);
        }
        return vec3d1;
    }

    public Vec3 getFluidFallingAdjustedMovement(double gravity, boolean falling, Vec3 motion) {
        if (gravity != 0.0 && !this.isSprinting()) {
            double d1 = falling && Math.abs(motion.y - 0.005) >= 0.003 && Math.abs(motion.y - gravity / 16.0) < 0.003 ? -0.003 : motion.y - gravity / 16.0;
            return new Vec3(motion.x, d1, motion.z);
        }
        return motion;
    }

    private Vec3 handleOnClimbable(Vec3 motion) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float f = 0.15f;
            double d0 = Mth.clamp(motion.x, (double)-0.15f, (double)0.15f);
            double d1 = Mth.clamp(motion.z, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(motion.y, (double)-0.15f);
            if (d2 < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof Player) {
                d2 = 0.0;
            }
            motion = new Vec3(d0, d2, d1);
        }
        return motion;
    }

    private float getFrictionInfluencedSpeed(float slipperiness) {
        return this.onGround() ? this.getSpeed() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float movementSpeed) {
        this.speed = movementSpeed;
    }

    public boolean doHurtTarget(Entity target) {
        this.setLastHurtMob(target);
        return false;
    }

    @Override
    public void tick() {
        float f4;
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide) {
            int j;
            int i = this.getArrowCount();
            if (i > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - i);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount(i - 1);
                }
            }
            if ((j = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - j);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount(j - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (this.isSleeping() && !this.checkBedExists()) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            this.aiStep();
        }
        double d0 = this.getX() - this.xo;
        double d1 = this.getZ() - this.zo;
        float f = (float)(d0 * d0 + d1 * d1);
        float f1 = this.yBodyRot;
        float f2 = 0.0f;
        this.oRun = this.run;
        float f3 = 0.0f;
        if (f > 0.0025000002f) {
            f3 = 1.0f;
            f2 = (float)Math.sqrt(f) * 3.0f;
            f4 = (float)Mth.atan2(d1, d0) * 57.295776f - 90.0f;
            float f5 = Mth.abs(Mth.wrapDegrees(this.getYRot()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.attackAnim > 0.0f) {
            f1 = this.getYRot();
        }
        if (!this.onGround()) {
            f3 = 0.0f;
        }
        this.run += (f3 - this.run) * 0.3f;
        this.level().getProfiler().push("headTurn");
        f2 = this.tickHeadTurn(f1, f2);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("rangeChecks");
        this.yRotO += (float)Math.round((this.getYRot() - this.yRotO) / 360.0f) * 360.0f;
        this.yBodyRotO += (float)Math.round((this.yBodyRot - this.yBodyRotO) / 360.0f) * 360.0f;
        this.xRotO += (float)Math.round((this.getXRot() - this.xRotO) / 360.0f) * 360.0f;
        this.yHeadRotO += (float)Math.round((this.yHeadRot - this.yHeadRotO) / 360.0f) * 360.0f;
        this.level().getProfiler().pop();
        this.animStep += f2;
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        f4 = this.getScale();
        if (f4 != this.appliedScale) {
            this.appliedScale = f4;
            this.refreshDimensions();
        }
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EquipmentSlot, ItemStack> map = this.collectEquipmentChanges();
        if (map != null) {
            this.handleHandSwap(map);
            if (!map.isEmpty()) {
                this.handleEquipmentChanges(map);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlot, ItemStack> collectEquipmentChanges() {
        Map map = null;
        for (EquipmentSlot enumitemslot : EquipmentSlot.values()) {
            ItemStack itemstack1 = switch (enumitemslot.getType()) {
                case EquipmentSlot.Type.HAND -> this.getLastHandItem(enumitemslot);
                case EquipmentSlot.Type.HUMANOID_ARMOR -> this.getLastArmorItem(enumitemslot);
                case EquipmentSlot.Type.ANIMAL_ARMOR -> this.lastBodyItemStack;
                default -> throw new MatchException(null, null);
            };
            ItemStack itemstack2 = this.getItemBySlot(enumitemslot);
            if (!this.equipmentHasChanged(itemstack1, itemstack2)) continue;
            if (this instanceof ServerPlayer && enumitemslot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemstack1);
                org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemstack2);
                new PlayerArmorChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumitemslot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EquipmentSlot.class);
            }
            map.put(enumitemslot, itemstack2);
            AttributeMap attributemapbase = this.getAttributes();
            if (itemstack1.isEmpty()) continue;
            itemstack1.forEachModifier(enumitemslot, (holder, attributemodifier) -> {
                AttributeInstance attributemodifiable = attributemapbase.getInstance((Holder<Attribute>)holder);
                if (attributemodifiable != null) {
                    attributemodifiable.removeModifier((AttributeModifier)attributemodifier);
                }
                EnchantmentHelper.stopLocationBasedEffects(itemstack1, this, enumitemslot);
            });
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EquipmentSlot enumitemslot1 = (EquipmentSlot)entry.getKey();
                ItemStack itemstack3 = (ItemStack)entry.getValue();
                if (itemstack3.isEmpty()) continue;
                itemstack3.forEachModifier(enumitemslot1, (holder, attributemodifier) -> {
                    Level world;
                    AttributeInstance attributemodifiable = this.attributes.getInstance((Holder<Attribute>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.removeModifier(attributemodifier.id());
                        attributemodifiable.addTransientModifier((AttributeModifier)attributemodifier);
                    }
                    if ((world = this.level()) instanceof ServerLevel) {
                        ServerLevel worldserver = (ServerLevel)world;
                        EnchantmentHelper.runLocationChangedEffects(worldserver, itemstack3, this, enumitemslot1);
                    }
                });
            }
        }
        return map;
    }

    public boolean equipmentHasChanged(ItemStack stack, ItemStack stack2) {
        return !ItemStack.matches(stack2, stack);
    }

    private void handleHandSwap(Map<EquipmentSlot, ItemStack> equipmentChanges) {
        ItemStack itemstack = equipmentChanges.get(EquipmentSlot.MAINHAND);
        ItemStack itemstack1 = equipmentChanges.get(EquipmentSlot.OFFHAND);
        if (itemstack != null && itemstack1 != null && ItemStack.matches(itemstack, this.getLastHandItem(EquipmentSlot.OFFHAND)) && ItemStack.matches(itemstack1, this.getLastHandItem(EquipmentSlot.MAINHAND))) {
            ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundEntityEventPacket(this, 55));
            equipmentChanges.remove(EquipmentSlot.MAINHAND);
            equipmentChanges.remove(EquipmentSlot.OFFHAND);
            this.setLastHandItem(EquipmentSlot.MAINHAND, itemstack.copy());
            this.setLastHandItem(EquipmentSlot.OFFHAND, itemstack1.copy());
        }
    }

    private void handleEquipmentChanges(Map<EquipmentSlot, ItemStack> equipmentChanges) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipmentChanges.size());
        equipmentChanges.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.copy();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            switch (enumitemslot.getType()) {
                case HAND: {
                    this.setLastHandItem((EquipmentSlot)enumitemslot, itemstack1);
                    break;
                }
                case HUMANOID_ARMOR: {
                    this.setLastArmorItem((EquipmentSlot)enumitemslot, itemstack1);
                    break;
                }
                case ANIMAL_ARMOR: {
                    this.lastBodyItemStack = itemstack1;
                }
            }
        });
        ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundSetEquipmentPacket(this.getId(), list, true));
    }

    private ItemStack getLastArmorItem(EquipmentSlot slot) {
        return this.lastArmorItemStacks.get(slot.getIndex());
    }

    private void setLastArmorItem(EquipmentSlot slot, ItemStack armor) {
        this.lastArmorItemStacks.set(slot.getIndex(), armor);
    }

    private ItemStack getLastHandItem(EquipmentSlot slot) {
        return this.lastHandItemStacks.get(slot.getIndex());
    }

    private void setLastHandItem(EquipmentSlot slot, ItemStack stack) {
        this.lastHandItemStacks.set(slot.getIndex(), stack);
    }

    protected float tickHeadTurn(float bodyRotation, float headRotation) {
        boolean flag;
        float f2 = Mth.wrapDegrees(bodyRotation - this.yBodyRot);
        this.yBodyRot += f2 * 0.3f;
        float f3 = Mth.wrapDegrees(this.getYRot() - this.yBodyRot);
        float f4 = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs(f3) > f4) {
            this.yBodyRot += f3 - (float)Mth.sign(f3) * f4;
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        } else if (!this.isEffectiveAi()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        vec3d = this.getDeltaMovement();
        d0 = vec3d.x;
        d1 = vec3d.y;
        d2 = vec3d.z;
        if (Math.abs(vec3d.x) < 0.003) {
            d0 = 0.0;
        }
        if (Math.abs(vec3d.y) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.z) < 0.003) {
            d2 = 0.0;
        }
        this.setDeltaMovement(d0, d1, d2);
        this.level().getProfiler().push("ai");
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi()) {
            this.level().getProfiler().push("newAi");
            this.serverAiStep();
            this.level().getProfiler().pop();
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            d3 = this.isInLava() != false ? this.getFluidHeight(FluidTags.LAVA) : this.getFluidHeight(FluidTags.WATER);
            flag = this.isInWater() != false && d3 > 0.0;
            d4 = this.getFluidJumpThreshold();
            if (flag && (!this.onGround() || d3 > d4)) {
                this.jumpInLiquid(FluidTags.WATER);
            } else if (this.isInLava() && (!this.onGround() || d3 > d4)) {
                this.jumpInLiquid(FluidTags.LAVA);
            } else if ((this.onGround() || flag && d3 <= d4) && this.noJumpDelay == 0) {
                if (new EntityJumpEvent((org.bukkit.entity.LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                    this.jumpFromGround();
                    this.noJumpDelay = 10;
                } else {
                    this.setJumping(false);
                }
            }
        } else {
            this.noJumpDelay = 0;
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("travel");
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.updateFallFlying();
        axisalignedbb = this.getBoundingBox();
        vec3d1 = new Vec3(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        if (!((entityliving = this.getControllingPassenger()) instanceof Player)) ** GOTO lbl-1000
        entityhuman = (Player)entityliving;
        if (this.isAlive()) {
            this.travelRidden(entityhuman, vec3d1);
        } else lbl-1000:
        // 2 sources

        {
            this.travel(vec3d1);
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("freezing");
        if (!(this.level().isClientSide || this.isDeadOrDying() || this.freezeLocked)) {
            i = this.getTicksFrozen();
            if (this.isInPowderSnow && this.canFreeze()) {
                this.setTicksFrozen(Math.min(this.getTicksRequiredToFreeze(), i + 1));
            } else {
                this.setTicksFrozen(Math.max(0, i - 2));
            }
        }
        this.removeFrost();
        this.tryAddFrost();
        if (!this.level().isClientSide && this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
            this.hurt(this.damageSources().freeze(), 1.0f);
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack(axisalignedbb, this.getBoundingBox());
        }
        this.pushEntities();
        this.level().getProfiler().pop();
        if (((ServerLevel)this.level()).hasEntityMoveEvent && !(this instanceof Player) && (this.xo != this.getX() || this.yo != this.getY() || this.zo != this.getZ() || this.yRotO != this.getYRot() || this.xRotO != this.getXRot())) {
            from = new Location((World)this.level().getWorld(), this.xo, this.yo, this.zo, this.yRotO, this.xRotO);
            to = new Location((World)this.level().getWorld(), this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            event = new EntityMoveEvent((org.bukkit.entity.LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.absMoveTo(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.absMoveTo(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if (!this.level().isClientSide && this.isSensitiveToWater() && this.isInWaterRainOrBubble()) {
            this.hurt(this.damageSources().drown(), 1.0f);
        }
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    private void updateFallFlying() {
        boolean flag = this.getSharedFlag(7);
        if (flag && !this.onGround() && !this.isPassenger() && !this.hasEffect(MobEffects.LEVITATION)) {
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.CHEST);
            if (itemstack.is(Items.ELYTRA) && ElytraItem.isFlyEnabled(itemstack)) {
                flag = true;
                int i = this.fallFlyTicks + 1;
                if (!this.level().isClientSide && i % 10 == 0) {
                    int j = i / 10;
                    if (j % 2 == 0) {
                        itemstack.hurtAndBreak(1, this, EquipmentSlot.CHEST);
                    }
                    this.gameEvent(GameEvent.ELYTRA_GLIDE);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.level().isClientSide && flag != this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.setSharedFlag(7, flag);
        }
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        if (this.level().isClientSide()) {
            this.level().getEntities(EntityTypeTest.forClass(Player.class), this.getBoundingBox(), EntitySelector.pushableBy(this)).forEach(this::doPush);
        } else {
            if (!this.isPushable()) {
                return;
            }
            PlayerTeam team = this.getTeam();
            if (team != null && ((Team)team).getCollisionRule() == Team.CollisionRule.NEVER) {
                return;
            }
            int i = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            if (i <= 0 && this.level().paperConfig().collisions.maxEntityCollisions <= 0) {
                return;
            }
            List<Entity> list = this.level().getEntities(this, this.getBoundingBox(), EntitySelector.pushable(this, this.level().paperConfig().collisions.fixClimbingBypassingCrammingRule));
            if (!list.isEmpty()) {
                if (i > 0 && list.size() > i - 1 && this.random.nextInt(4) == 0) {
                    int j = 0;
                    for (Entity entity : list) {
                        if (entity.isPassenger()) continue;
                        ++j;
                    }
                    if (j > i - 1) {
                        this.hurt(this.damageSources().cramming(), 6.0f);
                    }
                }
                Iterator<Entity> iterator1 = list.iterator();
                this.numCollisions = Math.max(0, this.numCollisions - this.level().paperConfig().collisions.maxEntityCollisions);
                while (iterator1.hasNext() && this.numCollisions < this.level().paperConfig().collisions.maxEntityCollisions) {
                    Entity entity1 = iterator1.next();
                    ++entity1.numCollisions;
                    ++this.numCollisions;
                    this.doPush(entity1);
                }
            }
        }
    }

    protected void checkAutoSpinAttack(AABB a, AABB b) {
        AABB axisalignedbb2 = a.minmax(b);
        List<Entity> list = this.level().getEntities(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                this.doAutoAttackOnTouch((LivingEntity)entity);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
            this.autoSpinAttackDmg = 0.0f;
            this.autoSpinAttackItemStack = null;
        }
    }

    protected void doPush(Entity entity) {
        entity.push(this);
    }

    protected void doAutoAttackOnTouch(LivingEntity target) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity entity = this.getVehicle();
        super.stopRiding(suppressCancellation);
        if (entity != null && entity != this.getVehicle() && !this.level().isClientSide && entity.valid) {
            this.dismountVehicle(entity);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.oRun = this.run;
        this.run = 0.0f;
        this.resetFallDistance();
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = interpolationSteps;
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpHeadTo(float yaw, int interpolationSteps) {
        this.lerpYHeadRot = yaw;
        this.lerpHeadSteps = interpolationSteps;
    }

    public void setJumping(boolean jumping) {
        this.jumping = jumping;
    }

    public void onItemPickup(ItemEntity item) {
        Player entity;
        Player player = entity = item.thrower != null ? this.level().getGlobalPlayerByUUID(item.thrower) : null;
        if (entity instanceof ServerPlayer) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((ServerPlayer)entity, item.getItem(), this);
        }
    }

    public void take(Entity item, int count) {
        if (!item.isRemoved() && !this.level().isClientSide && (item instanceof ItemEntity || item instanceof AbstractArrow || item instanceof ExperienceOrb)) {
            ((ServerLevel)this.level()).getChunkSource().broadcastAndSend(this, new ClientboundTakeItemEntityPacket(item.getId(), this.getId(), count));
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec3d1 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        return vec3d1.distanceToSqr(vec3d) > 16384.0 ? false : this.level().clipDirect(vec3d, vec3d1, CollisionContext.of(this)) == HitResult.Type.MISS;
    }

    @Override
    public float getViewYRot(float tickDelta) {
        return tickDelta == 1.0f ? this.yHeadRot : Mth.lerp(tickDelta, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float tickDelta) {
        float f1 = this.attackAnim - this.oAttackAnim;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.oAttackAnim + f1 * tickDelta;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved() && this.collides;
    }

    @Override
    public boolean isPushable() {
        return this.isCollidable(this.level().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.isAlive() && !this.isSpectator() && (ignoreClimbing || !this.onClimbable()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable() && this.collides != this.collidableExemptions.contains(entity.getUUID());
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float headYaw) {
        this.yHeadRot = headYaw;
    }

    @Override
    public void setYBodyRot(float bodyYaw) {
        this.yBodyRot = bodyYaw;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis portalAxis, BlockUtil.FoundRectangle portalRect) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(portalAxis, portalRect));
    }

    public static Vec3 resetForwardDirectionOfRelativePortalPosition(Vec3 pos) {
        return new Vec3(pos.x, pos.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float absorptionAmount) {
        this.internalSetAbsorptionAmount(!Float.isNaN(absorptionAmount) ? Mth.clamp(absorptionAmount, 0.0f, this.getMaxAbsorption()) : 0.0f);
    }

    protected void internalSetAbsorptionAmount(float absorptionAmount) {
        this.absorptionAmount = absorptionAmount;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract HumanoidArm getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public InteractionHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public void resyncUsingItem(ServerPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(DATA_LIVING_ENTITY_FLAGS), serverPlayer);
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    protected void updateUsingItem(ItemStack stack) {
        boolean shouldLagCompensate;
        stack.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        if (this.shouldTriggerItemUseEffects()) {
            this.triggerItemUseEffects(stack, 5);
        }
        boolean bl = shouldLagCompensate = this.useItem.has(DataComponents.FOOD) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.useItemRemaining != 0 && !shouldLagCompensate || this.level().isClientSide || stack.useOnRelease())) {
            this.useItemRemaining = 0;
            this.completeUsingItem();
        }
    }

    private boolean shouldTriggerItemUseEffects() {
        int j;
        int i = this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks();
        boolean flag = i > (j = (int)((float)this.useItem.getUseDuration(this) * 0.21875f));
        return flag && this.getUseItemRemainingTicks() % 4 == 0;
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    public void setLivingEntityFlag(int mask, boolean value) {
        int j = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        j = value ? (j |= mask) : (j &= ~mask);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)j);
    }

    public void startUsingItem(InteractionHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(InteractionHand hand, boolean forceUpdate) {
        ItemStack itemstack = this.getItemInHand(hand);
        if (!itemstack.isEmpty() && !this.isUsingItem() || forceUpdate) {
            this.useItem = itemstack;
            this.useItemRemaining = this.totalEatTimeTicks = itemstack.getUseDuration(this);
            this.eatStartTime = System.nanoTime();
            if (!this.level().isClientSide) {
                this.setLivingEntityFlag(1, true);
                this.setLivingEntityFlag(2, hand == InteractionHand.OFF_HAND);
                this.gameEvent(GameEvent.ITEM_INTERACT_START);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (SLEEPING_POS_ID.equals(data)) {
            if (this.level().isClientSide) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(data) && this.level().isClientSide) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration(this);
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.totalEatTimeTicks = 0;
                this.useItemRemaining = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor anchorPoint, Vec3 target) {
        super.lookAt(anchorPoint, target);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    @Override
    public float getPreciseBodyRotation(float delta) {
        return Mth.lerp(delta, this.yBodyRotO, this.yBodyRot);
    }

    protected void triggerItemUseEffects(ItemStack stack, int particleCount) {
        if (!stack.isEmpty() && this.isUsingItem()) {
            if (stack.getUseAnimation() == UseAnim.DRINK) {
                this.playSound(this.getDrinkingSound(stack), 0.5f, this.level().random.nextFloat() * 0.1f + 0.9f);
            }
            if (stack.getUseAnimation() == UseAnim.EAT) {
                this.spawnItemParticles(stack, particleCount);
                this.playSound(this.getEatingSound(stack), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    private void spawnItemParticles(ItemStack stack, int count) {
        for (int j = 0; j < count; ++j) {
            Vec3 vec3d = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3d = vec3d.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec3d1 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.yRot(-this.getYRot() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, stack), vec3d1.x, vec3d1.y, vec3d1.z, vec3d.x, vec3d.y + 0.05, vec3d.z);
        }
    }

    public void completeUsingItem() {
        if (!this.level().isClientSide || this.isUsingItem()) {
            InteractionHand enumhand = this.getUsedItemHand();
            if (!this.useItem.equals(this.getItemInHand(enumhand))) {
                this.releaseUsingItem();
            } else if (!this.useItem.isEmpty() && this.isUsingItem()) {
                ItemStack itemstack;
                this.startUsingItem(this.getUsedItemHand(), true);
                this.triggerItemUseEffects(this.useItem, 16);
                PlayerItemConsumeEvent event = null;
                LivingEntity livingEntity = this;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer entityPlayer = (ServerPlayer)livingEntity;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.useItem);
                    org.bukkit.inventory.EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    event = new PlayerItemConsumeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), craftItem, hand);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.stopUsingItem();
                        net.minecraft.world.item.Item item = this.useItem.getItem();
                        if (item instanceof SuspiciousStewItem) {
                            SuspiciousStewItem itemSuspiciousStew = (SuspiciousStewItem)item;
                            itemSuspiciousStew.cancelUsingItem(entityPlayer, this.useItem);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.useItem.finishUsingItem(this.level(), this) : CraftItemStack.asNMSCopy(event.getItem()).finishUsingItem(this.level(), this);
                } else {
                    itemstack = this.useItem.finishUsingItem(this.level(), this);
                }
                ItemStack defaultReplacement = itemstack;
                if (event != null && event.getReplacement() != null) {
                    itemstack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemstack != this.useItem) {
                    this.setItemInHand(enumhand, itemstack);
                }
                this.stopUsingItem();
                if (this instanceof ServerPlayer) {
                    ((ServerPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        return this.isUsingItem() ? this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks() : 0;
    }

    public void releaseUsingItem() {
        if (!this.useItem.isEmpty()) {
            if (this instanceof ServerPlayer) {
                new PlayerStopUsingItemEvent((org.bukkit.entity.Player)this.getBukkitEntity(), this.useItem.asBukkitMirror(), this.getTicksUsingItem()).callEvent();
            }
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide) {
            boolean flag = this.isUsingItem();
            this.setLivingEntityFlag(1, false);
            if (flag) {
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.totalEatTimeTicks = 0;
        this.useItemRemaining = 0;
        this.eatStartTime = -1L;
    }

    public boolean isBlocking() {
        if (this.isUsingItem() && !this.useItem.isEmpty()) {
            net.minecraft.world.item.Item item = this.useItem.getItem();
            return item.getUseAnimation(this.useItem) != UseAnim.BLOCK ? false : item.getUseDuration(this.useItem, this) - this.useItemRemaining >= this.getShieldBlockingDelay();
        }
        return false;
    }

    public HitResult getRayTrace(int maxDistance, ClipContext.Fluid fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3 start = new Vec3(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3 end = new Vec3(start.x + dir.getX(), start.y + dir.getY(), start.z + dir.getZ());
        ClipContext raytrace = new ClipContext(start, end, ClipContext.Block.OUTLINE, fluidCollisionOption, this);
        return this.level().clip(raytrace);
    }

    @Nullable
    public EntityHitResult getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3 start = this.getEyePosition(1.0f);
        Vec3 direction = this.getLookAngle();
        Vec3 end = start.add(direction.x * (double)maxDistance, direction.y * (double)maxDistance, direction.z * (double)maxDistance);
        List<Entity> entityList = this.level().getEntities(this, this.getBoundingBox().expandTowards(direction.x * (double)maxDistance, direction.y * (double)maxDistance, direction.z * (double)maxDistance).inflate(1.0, 1.0, 1.0), EntitySelector.NO_SPECTATORS.and(Entity::isPickable));
        double distance = 0.0;
        EntityHitResult result = null;
        for (Entity entity : entityList) {
            Vec3 rayTrace;
            double distanceTo;
            double inflationAmount = entity.getPickRadius();
            AABB aabb = entity.getBoundingBox().inflate(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3> rayTraceResult = aabb.clip(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.distanceToSqr(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new EntityHitResult(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(Pose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double x, double y, double z, boolean particleEffects) {
        return this.randomTeleport(x, y, z, particleEffects, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getZ();
        double d6 = d1;
        boolean flag1 = false;
        BlockPos blockposition = BlockPos.containing(d0, d1, d2);
        Level world = this.level();
        if (world.hasChunkAt(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.getY() > world.getMinBuildHeight()) {
                BlockPos blockposition1 = blockposition.below();
                BlockState iblockdata = world.getBlockState(blockposition1);
                if (iblockdata.blocksMotion()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.setPos(d0, d6, d2);
                if (world.noCollision(this) && !world.containsAnyLiquid(this.getBoundingBox())) {
                    flag1 = true;
                }
                this.setPos(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof ServerPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.level().getWorld(), d3, d4, d5), new Location((World)this.level().getWorld(), d0, d6, d2));
                        this.level().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.teleportTo(to.getX(), to.getY(), to.getZ());
                    } else if (!((ServerPlayer)this).connection.teleport(d0, d6, d2, this.getYRot(), this.getXRot(), Collections.emptySet(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.broadcastEntityEvent(this, (byte)46);
        }
        if (!(this instanceof PathfinderMob)) return Optional.of(true);
        PathfinderMob entitycreature = (PathfinderMob)this;
        entitycreature.getNavigation().stop();
        return Optional.of(true);
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPos songPosition, boolean playing) {
    }

    public boolean canTakeItem(ItemStack stack) {
        return false;
    }

    @Override
    public final EntityDimensions getDimensions(Pose pose) {
        return pose == Pose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(pose).scale(this.getScale());
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)Pose.STANDING));
    }

    public AABB getLocalBoundsForPose(Pose pose) {
        EntityDimensions entitysize = this.getDimensions(pose);
        return new AABB(-entitysize.width() / 2.0f, 0.0, -entitysize.width() / 2.0f, entitysize.width() / 2.0f, entitysize.height(), entitysize.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose pose) {
        AABB axisalignedbb = this.getDimensions(pose).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, axisalignedbb);
    }

    @Override
    public boolean canUsePortal(boolean allowVehicles) {
        return super.canUsePortal(allowVehicles) && !this.isSleeping();
    }

    public Optional<BlockPos> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPos pos) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(pos));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPos pos) {
        BlockState iblockdata;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((iblockdata = this.level().getBlockState(pos)).getBlock() instanceof BedBlock) {
            this.level().setBlock(pos, (BlockState)iblockdata.setValue(BedBlock.OCCUPIED, true), 3);
        }
        this.setPose(Pose.SLEEPING);
        this.setPosToBed(pos);
        this.setSleepingPos(pos);
        this.setDeltaMovement(Vec3.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPos pos) {
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.6875, (double)pos.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(blockposition -> this.level().getBlockState((BlockPos)blockposition).getBlock() instanceof BedBlock).orElse(false);
    }

    public void stopSleeping() {
        Optional<BlockPos> optional = this.getSleepingPos();
        Level world = this.level();
        Objects.requireNonNull(world);
        optional.filter(world::hasChunkAt).ifPresent(blockposition -> {
            BlockState iblockdata = this.level().getBlockState((BlockPos)blockposition);
            if (iblockdata.getBlock() instanceof BedBlock) {
                Direction enumdirection = iblockdata.getValue(HorizontalDirectionalBlock.FACING);
                this.level().setBlock((BlockPos)blockposition, (BlockState)iblockdata.setValue(BedBlock.OCCUPIED, false), 3);
                Vec3 vec3d = BedBlock.findStandUpPosition(this.getType(), this.level(), blockposition, enumdirection, this.getYRot()).orElseGet(() -> {
                    BlockPos blockposition1 = blockposition.above();
                    return new Vec3((double)blockposition1.getX() + 0.5, (double)blockposition1.getY() + 0.1, (double)blockposition1.getZ() + 0.5);
                });
                Vec3 vec3d1 = Vec3.atBottomCenterOf(blockposition).subtract(vec3d).normalize();
                float f = (float)Mth.wrapDegrees(Mth.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875 - 90.0);
                this.setPos(vec3d.x, vec3d.y, vec3d.z);
                this.setYRot(f);
                this.setXRot(0.0f);
            }
        });
        Vec3 vec3d = this.position();
        this.setPose(Pose.STANDING);
        this.setPos(vec3d.x, vec3d.y, vec3d.z);
        this.clearSleepingPos();
    }

    @Nullable
    public Direction getBedOrientation() {
        BlockPos blockposition = this.getSleepingPos().orElse(null);
        return blockposition != null ? BedBlock.getBedOrientation(this.level(), blockposition) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack stack) {
        return ItemStack.EMPTY;
    }

    public final ItemStack eat(Level world, ItemStack stack) {
        FoodProperties foodinfo = stack.get(DataComponents.FOOD);
        return foodinfo != null ? this.eat(world, stack, foodinfo) : stack;
    }

    public ItemStack eat(Level world, ItemStack stack, FoodProperties foodComponent) {
        world.playSound((Player)null, this.getX(), this.getY(), this.getZ(), this.getEatingSound(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f);
        this.addEatEffect(foodComponent);
        stack.consume(1, this);
        this.gameEvent(GameEvent.EAT);
        return stack;
    }

    private void addEatEffect(FoodProperties component) {
        if (!this.level().isClientSide()) {
            List<FoodProperties.PossibleEffect> list = component.effects();
            for (FoodProperties.PossibleEffect foodinfo_b : list) {
                if (!(this.random.nextFloat() < foodinfo_b.probability())) continue;
                this.addEffect(foodinfo_b.effect(), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    public static byte entityEventForEquipmentBreak(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.MAINHAND -> 47;
            case EquipmentSlot.OFFHAND -> 48;
            case EquipmentSlot.HEAD -> 49;
            case EquipmentSlot.CHEST -> 50;
            case EquipmentSlot.FEET -> 52;
            case EquipmentSlot.LEGS -> 51;
            case EquipmentSlot.BODY -> 65;
            default -> throw new MatchException(null, null);
        };
    }

    public void onEquippedItemBroken(net.minecraft.world.item.Item item, EquipmentSlot slot) {
        this.level().broadcastEntityEvent(this, LivingEntity.entityEventForEquipmentBreak(slot));
    }

    public static EquipmentSlot getSlotForHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        if (this.getItemBySlot(EquipmentSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float f = 0.5f;
            return this.getBoundingBox().inflate(0.5, 0.5, 0.5);
        }
        return super.getBoundingBoxForCulling();
    }

    public EquipmentSlot getEquipmentSlotForItem(ItemStack stack) {
        EquipmentSlot enumitemslot;
        Equipable equipable = Equipable.get(stack);
        if (equipable != null && this.canUseSlot(enumitemslot = equipable.getEquipmentSlot())) {
            return enumitemslot;
        }
        return EquipmentSlot.MAINHAND;
    }

    private static SlotAccess createEquipmentSlotAccess(LivingEntity entity, EquipmentSlot slot) {
        return slot != EquipmentSlot.HEAD && slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND ? SlotAccess.forEquipmentSlot(entity, slot, itemstack -> itemstack.isEmpty() || entity.getEquipmentSlotForItem((ItemStack)itemstack) == slot) : SlotAccess.forEquipmentSlot(entity, slot);
    }

    @Nullable
    private static EquipmentSlot getEquipmentSlot(int slotId) {
        return slotId == 100 + EquipmentSlot.HEAD.getIndex() ? EquipmentSlot.HEAD : (slotId == 100 + EquipmentSlot.CHEST.getIndex() ? EquipmentSlot.CHEST : (slotId == 100 + EquipmentSlot.LEGS.getIndex() ? EquipmentSlot.LEGS : (slotId == 100 + EquipmentSlot.FEET.getIndex() ? EquipmentSlot.FEET : (slotId == 98 ? EquipmentSlot.MAINHAND : (slotId == 99 ? EquipmentSlot.OFFHAND : (slotId == 105 ? EquipmentSlot.BODY : null))))));
    }

    @Override
    public SlotAccess getSlot(int mappedIndex) {
        EquipmentSlot enumitemslot = LivingEntity.getEquipmentSlot(mappedIndex);
        return enumitemslot != null ? LivingEntity.createEquipmentSlotAccess(this, enumitemslot) : super.getSlot(mappedIndex);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        boolean flag = !this.getItemBySlot(EquipmentSlot.HEAD).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.CHEST).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.LEGS).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.FEET).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.BODY).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
        return flag && super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        double d0 = packet.getX();
        double d1 = packet.getY();
        double d2 = packet.getZ();
        float f = packet.getYRot();
        float f1 = packet.getXRot();
        this.syncPacketPositionCodec(d0, d1, d2);
        this.yBodyRot = packet.getYHeadRot();
        this.yHeadRot = packet.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(packet.getId());
        this.setUUID(packet.getUUID());
        this.absMoveTo(d0, d1, d2, f, f1);
        this.setDeltaMovement(packet.getXa(), packet.getYa(), packet.getZa());
    }

    public boolean canDisableShield() {
        return this.getWeaponItem().getItem() instanceof AxeItem;
    }

    @Override
    public float maxUpStep() {
        float f = (float)this.getAttributeValue(Attributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof Player ? Math.max(f, 1.0f) : f;
    }

    @Override
    public Vec3 getPassengerRidingPosition(Entity passenger) {
        return this.position().add(this.getPassengerAttachmentPoint(passenger, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int headTrackingIncrements, double serverHeadYaw) {
        this.yHeadRot = (float)Mth.rotLerp(1.0 / (double)headTrackingIncrements, (double)this.yHeadRot, serverHeadYaw);
    }

    @Override
    public void igniteForTicks(int ticks) {
        super.igniteForTicks(Mth.ceil((double)ticks * this.getAttributeValue(Attributes.BURNING_TIME)));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    @Override
    public boolean isInvulnerableTo(DamageSource damageSource) {
        ServerLevel worldserver;
        Level world;
        if (!(super.isInvulnerableTo(damageSource) || (world = this.level()) instanceof ServerLevel && EnchantmentHelper.isImmuneToDamage(worldserver = (ServerLevel)world, this, damageSource))) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static class ProcessableEffect {
        private Holder<MobEffect> type;
        private MobEffectInstance effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffectInstance effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffect> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record Fallsounds(SoundEvent small, SoundEvent big) {
    }
}

