/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class LookAndFollowTradingPlayerSink
extends Behavior<Villager> {
    private final float speedModifier;

    public LookAndFollowTradingPlayerSink(float speed) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)), Integer.MAX_VALUE);
        this.speedModifier = speed;
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, Villager entity) {
        Player player = entity.getTradingPlayer();
        return entity.isAlive() && player != null && !entity.isInWater() && !entity.hurtMarked && entity.distanceToSqr(player) <= 16.0 && player.containerMenu != null;
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel world, Villager entity, long time) {
        return this.checkExtraStartConditions(world, entity);
    }

    @Override
    @Override
    protected void start(ServerLevel serverLevel, Villager villager, long l) {
        this.followPlayer(villager);
    }

    @Override
    @Override
    protected void stop(ServerLevel serverLevel, Villager villager, long l) {
        Brain<Villager> brain = villager.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    @Override
    protected void tick(ServerLevel serverLevel, Villager villager, long l) {
        this.followPlayer(villager);
    }

    @Override
    @Override
    protected boolean timedOut(long time) {
        return false;
    }

    private void followPlayer(Villager villager) {
        Brain<Villager> brain = villager.getBrain();
        brain.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new EntityTracker(villager.getTradingPlayer(), false), this.speedModifier, 2));
        brain.setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(villager.getTradingPlayer(), true));
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel world, LivingEntity entity, long time) {
        this.stop(world, (Villager)entity, time);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel world, LivingEntity entity, long time) {
        this.tick(world, (Villager)entity, time);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel world, LivingEntity entity, long time) {
        this.start(world, (Villager)entity, time);
    }
}

