/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import org.bukkit.event.entity.EntityRemoveEvent;

public class Digging<E extends Warden>
extends Behavior<E> {
    public Digging(int duration) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), duration);
    }

    @Override
    protected boolean canStillUse(ServerLevel world, E entity, long time) {
        return ((Entity)entity).getRemovalReason() == null;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, E entity) {
        return ((Entity)entity).onGround() || ((Entity)entity).isInWater() || ((Entity)entity).isInLava();
    }

    @Override
    protected void start(ServerLevel worldserver, E e0, long i) {
        if (((Entity)e0).onGround()) {
            ((Entity)e0).setPose(Pose.DIGGING);
            ((Entity)e0).playSound(SoundEvents.WARDEN_DIG, 5.0f, 1.0f);
        } else {
            ((Entity)e0).playSound(SoundEvents.WARDEN_AGITATED, 5.0f, 1.0f);
            this.stop(worldserver, e0, i);
        }
    }

    @Override
    protected void stop(ServerLevel worldserver, E e0, long i) {
        if (((Entity)e0).getRemovalReason() == null) {
            ((LivingEntity)e0).remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.DESPAWN);
        }
    }
}

