/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class FlyingMoveControl
extends MoveControl {
    private final int maxTurn;
    private final boolean hoversInPlace;

    public FlyingMoveControl(Mob entity, int maxPitchChange, boolean noGravity) {
        super(entity);
        this.maxTurn = maxPitchChange;
        this.hoversInPlace = noGravity;
    }

    @Override
    @Override
    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            float j;
            this.operation = MoveControl.Operation.WAIT;
            this.mob.setNoGravity(true);
            double d = this.wantedX - this.mob.getX();
            double e = this.wantedY - this.mob.getY();
            double f = this.wantedZ - this.mob.getZ();
            double g = d * d + e * e + f * f;
            if (g < 2.500000277905201E-7) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            float h = (float)(Mth.atan2(f, d) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), h, 90.0f));
            if (this.mob.onGround()) {
                float i = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
            } else {
                j = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
            }
            this.mob.setSpeed(j);
            double k = Math.sqrt(d * d + f * f);
            if (Math.abs(e) > (double)1.0E-5f || Math.abs(k) > (double)1.0E-5f) {
                float l = (float)(-(Mth.atan2(e, k) * 57.2957763671875));
                this.mob.setXRot(this.rotlerp(this.mob.getXRot(), l, this.maxTurn));
                this.mob.setYya(e > 0.0 ? j : -j);
            }
        } else {
            if (!this.hoversInPlace) {
                this.mob.setNoGravity(false);
            }
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }
}

