/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;

public class CatSitOnBlockGoal
extends MoveToBlockGoal {
    private final Cat cat;

    public CatSitOnBlockGoal(Cat cat, double speed) {
        super(cat, speed, 8);
        this.cat = cat;
    }

    @Override
    @Override
    public boolean canUse() {
        return this.cat.isTame() && !this.cat.isOrderedToSit() && super.canUse();
    }

    @Override
    @Override
    public void start() {
        super.start();
        this.cat.setInSittingPose(false);
    }

    @Override
    @Override
    public void stop() {
        super.stop();
        this.cat.setInSittingPose(false);
    }

    @Override
    @Override
    public void tick() {
        super.tick();
        this.cat.setInSittingPose(this.isReachedTarget());
    }

    @Override
    @Override
    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        if (!world.isEmptyBlock(pos.above())) {
            return false;
        }
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(Blocks.CHEST)) {
            return ChestBlockEntity.getOpenCount(world, pos) < 1;
        }
        if (blockState.is(Blocks.FURNACE) && blockState.getValue(AbstractFurnaceBlock.LIT).booleanValue()) {
            return true;
        }
        return blockState.is(BlockTags.BEDS, state -> state.getOptionalValue(BedBlock.PART).map(part -> part != BedPart.HEAD).orElse(true));
    }
}

