/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.GossipType;
import org.slf4j.Logger;

public class GossipContainer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DISCARD_THRESHOLD = 2;
    public final Map<UUID, EntityGossips> gossips = Maps.newHashMap();

    @VisibleForDebug
    public Map<UUID, Object2IntMap<GossipType>> getGossipEntries() {
        HashMap map = Maps.newHashMap();
        this.gossips.keySet().forEach(uuid -> {
            EntityGossips entityGossips = this.gossips.get(uuid);
            map.put(uuid, entityGossips.entries);
        });
        return map;
    }

    public void decay() {
        Iterator<EntityGossips> iterator = this.gossips.values().iterator();
        while (iterator.hasNext()) {
            EntityGossips entityGossips = iterator.next();
            entityGossips.decay();
            if (!entityGossips.isEmpty()) continue;
            iterator.remove();
        }
    }

    private Stream<GossipEntry> unpack() {
        return this.gossips.entrySet().stream().flatMap(entry -> ((EntityGossips)entry.getValue()).unpack((UUID)entry.getKey()));
    }

    private List<GossipEntry> decompress() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map.Entry<UUID, EntityGossips> entry : this.gossips.entrySet()) {
            for (GossipEntry cur : entry.getValue().decompress(entry.getKey())) {
                if (cur.weightedValue() == 0) continue;
                list.add(cur);
            }
        }
        return list;
    }

    private Collection<GossipEntry> selectGossipsForTransfer(RandomSource random, int count) {
        List<GossipEntry> list = this.decompress();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] is = new int[list.size()];
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            GossipEntry gossipEntry = list.get(j);
            is[j] = (i += Math.abs(gossipEntry.weightedValue())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int k = 0; k < count; ++k) {
            int l = random.nextInt(i);
            int m = Arrays.binarySearch(is, l);
            set.add(list.get(m < 0 ? -m - 1 : m));
        }
        return set;
    }

    private EntityGossips getOrCreate(UUID target) {
        return this.gossips.computeIfAbsent(target, uuid -> new EntityGossips());
    }

    public void transferFrom(GossipContainer from, RandomSource random, int count) {
        Collection<GossipEntry> collection = from.selectGossipsForTransfer(random, count);
        collection.forEach(gossip -> {
            int i = gossip.value - gossip.type.decayPerTransfer;
            if (i >= 2) {
                this.getOrCreate((UUID)gossip.target).entries.mergeInt((Object)gossip.type, i, GossipContainer::mergeValuesForTransfer);
            }
        });
    }

    public int getReputation(UUID target, Predicate<GossipType> gossipTypeFilter) {
        EntityGossips entityGossips = this.gossips.get(target);
        return entityGossips != null ? entityGossips.weightedValue(gossipTypeFilter) : 0;
    }

    public long getCountForType(GossipType type, DoublePredicate predicate) {
        return this.gossips.values().stream().filter(reputation -> predicate.test(reputation.entries.getOrDefault((Object)type, 0) * type.weight)).count();
    }

    public void add(UUID target, GossipType type, int value) {
        EntityGossips entityGossips = this.getOrCreate(target);
        entityGossips.entries.mergeInt((Object)type, value, (left, right) -> this.mergeValuesForAddition(type, left, right));
        entityGossips.makeSureValueIsntTooLowOrTooHigh(type);
        if (entityGossips.isEmpty()) {
            this.gossips.remove(target);
        }
    }

    public void remove(UUID target, GossipType type, int value) {
        this.add(target, type, -value);
    }

    public void remove(UUID target, GossipType type) {
        EntityGossips entityGossips = this.gossips.get(target);
        if (entityGossips != null) {
            entityGossips.remove(type);
            if (entityGossips.isEmpty()) {
                this.gossips.remove(target);
            }
        }
    }

    public void remove(GossipType type) {
        Iterator<EntityGossips> iterator = this.gossips.values().iterator();
        while (iterator.hasNext()) {
            EntityGossips entityGossips = iterator.next();
            entityGossips.remove(type);
            if (!entityGossips.isEmpty()) continue;
            iterator.remove();
        }
    }

    public <T> T store(DynamicOps<T> ops) {
        return (T)GossipEntry.LIST_CODEC.encodeStart(ops, this.decompress()).resultOrPartial(error -> LOGGER.warn("Failed to serialize gossips: {}", error)).orElseGet(() -> ops.emptyList());
    }

    public void update(Dynamic<?> dynamic) {
        GossipEntry.LIST_CODEC.decode(dynamic).resultOrPartial(error -> LOGGER.warn("Failed to deserialize gossips: {}", error)).stream().flatMap(pair -> ((List)pair.getFirst()).stream()).forEach(entry -> this.getOrCreate((UUID)entry.target).entries.put((Object)entry.type, entry.value));
    }

    private static int mergeValuesForTransfer(int left, int right) {
        return Math.max(left, right);
    }

    private int mergeValuesForAddition(GossipType type, int left, int right) {
        int i = left + right;
        return i > type.max ? Math.max(type.max, left) : i;
    }

    public static class EntityGossips {
        final Object2IntMap<GossipType> entries = new Object2IntOpenHashMap();
        private static final GossipType[] TYPES = GossipType.values();

        public int weightedValue(Predicate<GossipType> gossipTypeFilter) {
            int weight = 0;
            for (Object2IntMap.Entry entry : this.entries.object2IntEntrySet()) {
                if (!gossipTypeFilter.test((GossipType)entry.getKey())) continue;
                weight += entry.getIntValue() * ((GossipType)entry.getKey()).weight;
            }
            return weight;
        }

        public List<GossipEntry> decompress(UUID uuid) {
            ObjectArrayList list = new ObjectArrayList();
            for (Object2IntMap.Entry entry : this.entries.object2IntEntrySet()) {
                list.add(new GossipEntry(uuid, (GossipType)entry.getKey(), entry.getIntValue()));
            }
            return list;
        }

        public Stream<GossipEntry> unpack(UUID target) {
            return this.entries.object2IntEntrySet().stream().map(entry -> new GossipEntry(target, (GossipType)entry.getKey(), entry.getIntValue()));
        }

        public void decay() {
            ObjectIterator objectIterator = this.entries.object2IntEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
                int i = entry.getIntValue() - ((GossipType)entry.getKey()).decayPerDay;
                if (i < 2) {
                    objectIterator.remove();
                    continue;
                }
                entry.setValue(i);
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void makeSureValueIsntTooLowOrTooHigh(GossipType gossipType) {
            int i = this.entries.getInt((Object)gossipType);
            if (i > gossipType.max) {
                this.entries.put((Object)gossipType, gossipType.max);
            }
            if (i < 2) {
                this.remove(gossipType);
            }
        }

        public void remove(GossipType gossipType) {
            this.entries.removeInt((Object)gossipType);
        }

        public Reputation getPaperReputation() {
            EnumMap<ReputationType, Integer> map = new EnumMap<ReputationType, Integer>(ReputationType.class);
            for (Object2IntMap.Entry type : this.entries.object2IntEntrySet()) {
                map.put(EntityGossips.toApi((GossipType)type.getKey()), type.getIntValue());
            }
            return new Reputation(map);
        }

        public void assignFromPaperReputation(Reputation rep) {
            for (GossipType type : TYPES) {
                ReputationType api = EntityGossips.toApi(type);
                if (!rep.hasReputationSet(api)) continue;
                int reputation = rep.getReputation(api);
                if (reputation == 0) {
                    this.entries.removeInt((Object)type);
                    continue;
                }
                this.entries.put((Object)type, reputation);
            }
        }

        private static ReputationType toApi(GossipType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case GossipType.MAJOR_NEGATIVE -> ReputationType.MAJOR_NEGATIVE;
                case GossipType.MINOR_NEGATIVE -> ReputationType.MINOR_NEGATIVE;
                case GossipType.MINOR_POSITIVE -> ReputationType.MINOR_POSITIVE;
                case GossipType.MAJOR_POSITIVE -> ReputationType.MAJOR_POSITIVE;
                case GossipType.TRADING -> ReputationType.TRADING;
            };
        }
    }

    record GossipEntry(UUID target, GossipType type, int value) {
        public static final Codec<GossipEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("Target").forGetter(GossipEntry::target), (App)GossipType.CODEC.fieldOf("Type").forGetter(GossipEntry::type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("Value").forGetter(GossipEntry::value)).apply((Applicative)instance, GossipEntry::new));
        public static final Codec<List<GossipEntry>> LIST_CODEC = CODEC.listOf();

        public int weightedValue() {
            return this.value * this.type.weight;
        }
    }
}

