/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface HoglinBase {
    public static final int ATTACK_ANIMATION_DURATION = 10;

    public int getAttackAnimationRemainingTicks();

    public static boolean hurtAndThrowTarget(LivingEntity attacker, LivingEntity target) {
        float f = (float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float g = !attacker.isBaby() && (int)f > 0 ? f / 2.0f + (float)attacker.level().random.nextInt((int)f) : f;
        DamageSource damageSource = attacker.damageSources().mobAttack(attacker);
        boolean bl = target.hurt(damageSource, g);
        if (bl) {
            Level level = attacker.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects(serverLevel, target, damageSource);
            }
            if (!attacker.isBaby()) {
                HoglinBase.throwTarget(attacker, target);
            }
        }
        return bl;
    }

    public static void throwTarget(LivingEntity attacker, LivingEntity target) {
        double e;
        double d = attacker.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        double f = d - (e = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        if (!(f <= 0.0)) {
            double g = target.getX() - attacker.getX();
            double h = target.getZ() - attacker.getZ();
            float i = attacker.level().random.nextInt(21) - 10;
            double j = f * (double)(attacker.level().random.nextFloat() * 0.5f + 0.2f);
            Vec3 vec3 = new Vec3(g, 0.0, h).normalize().scale(j).yRot(i);
            double k = f * (double)attacker.level().random.nextFloat() * 0.5;
            target.push(vec3.x, k, vec3.z, attacker);
            target.hurtMarked = true;
        }
    }
}

