/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExpBottleEvent;

public class ThrownExperienceBottle
extends ThrowableItemProjectile {
    public ThrownExperienceBottle(EntityType<? extends ThrownExperienceBottle> type, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)type, world);
    }

    public ThrownExperienceBottle(Level world, LivingEntity owner) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.EXPERIENCE_BOTTLE, owner, world);
    }

    public ThrownExperienceBottle(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.EXPERIENCE_BOTTLE, x, y, z, world);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.EXPERIENCE_BOTTLE;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.07;
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (this.level() instanceof ServerLevel) {
            int i = 3 + this.level().random.nextInt(5) + this.level().random.nextInt(5);
            ExpBottleEvent event = CraftEventFactory.callExpBottleEvent(this, hitResult, i);
            i = event.getExperience();
            if (event.getShowEffect()) {
                this.level().levelEvent(2002, this.blockPosition(), PotionContents.getColor(Potions.WATER));
            }
            ExperienceOrb.award((ServerLevel)this.level(), this.position(), i, ExperienceOrb.SpawnReason.EXP_BOTTLE, this.getOwner(), this);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

