/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class AbstractMinecart
extends VehicleEntity {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.BOOLEAN);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)Pose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private boolean onRails;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3 targetDeltaMovement = Vec3.ZERO;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Util.make(Maps.newEnumMap(RailShape.class), enummap -> {
        Vec3i baseblockposition = Direction.WEST.getNormal();
        Vec3i baseblockposition1 = Direction.EAST.getNormal();
        Vec3i baseblockposition2 = Direction.NORTH.getNormal();
        Vec3i baseblockposition3 = Direction.SOUTH.getNormal();
        Vec3i baseblockposition4 = baseblockposition.below();
        Vec3i baseblockposition5 = baseblockposition1.below();
        Vec3i baseblockposition6 = baseblockposition2.below();
        Vec3i baseblockposition7 = baseblockposition3.below();
        enummap.put(RailShape.NORTH_SOUTH, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(RailShape.EAST_WEST, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(RailShape.ASCENDING_EAST, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(RailShape.ASCENDING_WEST, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(RailShape.ASCENDING_NORTH, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(RailShape.SOUTH_EAST, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(RailShape.SOUTH_WEST, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(RailShape.NORTH_WEST, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(RailShape.NORTH_EAST, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public double maxSpeed = 0.4;

    protected AbstractMinecart(EntityType<?> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    protected AbstractMinecart(EntityType<?> type, Level world, double x, double y, double z) {
        this(type, world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public static AbstractMinecart createMinecart(ServerLevel world, double x, double y, double z, Type type, ItemStack stack, @Nullable Player player) {
        AbstractMinecart object1 = switch (type.ordinal()) {
            case 1 -> new MinecartChest(world, x, y, z);
            case 2 -> new MinecartFurnace(world, x, y, z);
            case 3 -> new MinecartTNT(world, x, y, z);
            case 4 -> new MinecartSpawner(world, x, y, z);
            case 5 -> new MinecartHopper(world, x, y, z);
            case 6 -> new MinecartCommandBlock(world, x, y, z);
            default -> new Minecart(world, x, y, z);
        };
        EntityType.createDefaultStackConfig(world, stack, player).accept(object1);
        return object1;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        builder.define(DATA_ID_DISPLAY_OFFSET, 6);
        builder.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    @Override
    public boolean canCollideWith(Entity other) {
        boolean collides = Boat.canVehicleCollide(this, other);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)other.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis portalAxis, BlockUtil.FoundRectangle portalRect) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(portalAxis, portalRect));
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        boolean flag = passenger instanceof Villager || passenger instanceof WanderingTrader;
        return flag ? LOWERED_PASSENGER_ATTACHMENT : super.getPassengerAttachmentPoint(passenger, dimensions, scaleFactor);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction enumdirection = this.getMotionDirection();
        if (enumdirection.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(passenger);
        }
        int[][] aint = DismountHelper.offsetsForDirection(enumdirection);
        BlockPos blockposition = this.blockPosition();
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = passenger.getDismountPoses();
        for (Pose entitypose : immutablelist) {
            EntityDimensions entitysize = passenger.getDimensions(entitypose);
            float f = Math.min(entitysize.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j = aint.length;
                for (int k = 0; k < j; ++k) {
                    int[] aint2 = aint1[k];
                    blockposition_mutableblockposition.set(blockposition.getX() + aint2[0], blockposition.getY() + i, blockposition.getZ() + aint2[1]);
                    double d0 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape(this.level(), blockposition_mutableblockposition), () -> DismountHelper.nonClimbableShape(this.level(), (BlockPos)blockposition_mutableblockposition.below()));
                    if (!DismountHelper.isBlockFloorValid(d0)) continue;
                    AABB axisalignedbb = new AABB(-f, 0.0, -f, f, entitysize.height(), f);
                    Vec3 vec3d = Vec3.upFromBottomCenterOf(blockposition_mutableblockposition, d0);
                    if (!DismountHelper.canDismountTo(this.level(), passenger, axisalignedbb.move(vec3d))) continue;
                    passenger.setPose(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockposition_mutableblockposition.set((double)blockposition.getX(), d1, (double)blockposition.getZ());
        for (Pose entitypose1 : immutablelist) {
            int l;
            double d3;
            double d2 = passenger.getDimensions(entitypose1).height();
            if (!(d1 + d2 <= (d3 = DismountHelper.findCeilingFrom(blockposition_mutableblockposition, l = Mth.ceil(d1 - (double)blockposition_mutableblockposition.getY() + d2), blockposition1 -> this.level().getBlockState((BlockPos)blockposition1).getCollisionShape(this.level(), (BlockPos)blockposition1))))) continue;
            passenger.setPose(entitypose1);
            break;
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    @Override
    protected float getBlockSpeedFactor() {
        BlockState iblockdata = this.level().getBlockState(this.blockPosition());
        return iblockdata.is(BlockTags.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float yaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    private static Pair<Vec3i, Vec3i> exits(RailShape shape) {
        return EXITS.get(shape);
    }

    @Override
    public Direction getMotionDirection() {
        return this.flipped ? this.getDirection().getOpposite().getClockWise() : this.getDirection().getClockWise();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        double prevX = this.getX();
        double prevY = this.getY();
        double prevZ = this.getZ();
        float prevYaw = this.getYRot();
        float prevPitch = this.getXRot();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            double d2;
            this.applyGravity();
            int i = Mth.floor(this.getX());
            int j = Mth.floor(this.getY());
            int k = Mth.floor(this.getZ());
            if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
                --j;
            }
            BlockPos blockposition = new BlockPos(i, j, k);
            BlockState iblockdata = this.level().getBlockState(blockposition);
            this.onRails = BaseRailBlock.isRail(iblockdata);
            if (this.onRails) {
                this.moveAlongTrack(blockposition, iblockdata);
                if (iblockdata.is(Blocks.ACTIVATOR_RAIL)) {
                    this.activateMinecart(i, j, k, iblockdata.getValue(PoweredRailBlock.POWERED));
                }
            } else {
                this.comeOffTrack();
            }
            this.checkInsideBlocks();
            this.setXRot(0.0f);
            double d0 = this.xo - this.getX();
            double d1 = this.zo - this.getZ();
            if (d0 * d0 + d1 * d1 > 0.001) {
                this.setYRot((float)(Mth.atan2(d1, d0) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.setYRot(this.getYRot() + 180.0f);
                }
            }
            if ((d2 = (double)Mth.wrapDegrees(this.getYRot() - this.yRotO)) < -170.0 || d2 >= 170.0) {
                this.setYRot(this.getYRot() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.setRot(this.getYRot(), this.getXRot());
            CraftWorld bworld = this.level().getWorld();
            Location from = new Location((World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
            Location to = CraftLocation.toBukkit(this.position(), (World)bworld, this.getYRot(), this.getXRot());
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
            if (!from.equals((Object)to)) {
                this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
            }
            if (this.getMinecartType() == Type.RIDEABLE && this.getDeltaMovement().horizontalDistanceSqr() > 0.01) {
                List<Entity> list = this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f), EntitySelector.pushableBy(this));
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        VehicleEntityCollisionEvent collisionEvent;
                        if (!(entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || this.isVehicle() || entity.isPassenger())) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                            entity.startRiding(this);
                            continue;
                        }
                        if (!this.isPassengerOfSameVehicle(entity)) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                        }
                        entity.push(this);
                    }
                }
            } else {
                for (Entity entity1 : this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f))) {
                    if (this.hasPassenger(entity1) || !entity1.isPushable() || !(entity1 instanceof AbstractMinecart)) continue;
                    VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                    this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                    if (collisionEvent.isCancelled()) continue;
                    entity1.push(this);
                }
            }
            this.updateInWaterStateAndDoFluidPushing();
            if (this.isInLava()) {
                this.lavaHurt();
                this.fallDistance *= 0.5f;
            }
            this.firstTick = false;
        }
    }

    protected double getMaxSpeed() {
        return this.isInWater() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    public void activateMinecart(int x, int y, int z, boolean powered) {
    }

    protected void comeOffTrack() {
        double d0 = this.getMaxSpeed();
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp(vec3d.x, -d0, d0), vec3d.y, Mth.clamp(vec3d.z, -d0, d0));
        if (this.onGround()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.derailedX, this.getDeltaMovement().y * this.derailedY, this.getDeltaMovement().z * this.derailedZ));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.flyingX, this.getDeltaMovement().y * this.flyingY, this.getDeltaMovement().z * this.flyingZ));
        }
    }

    @Override
    public Vec3 getKnownMovement() {
        double d0 = this.getMaxSpeed();
        Vec3 vec3d = super.getKnownMovement();
        return new Vec3(Mth.clamp(vec3d.x, -d0, d0), vec3d.y, Mth.clamp(vec3d.z, -d0, d0));
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state) {
        double d18;
        Vec3 vec3d4;
        double d17;
        double d16;
        double d15;
        this.resetFallDistance();
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        Vec3 vec3d = this.getPos(d0, d1, d2);
        d1 = pos.getY();
        boolean flag = false;
        boolean flag1 = false;
        if (state.is(Blocks.POWERED_RAIL)) {
            flag = state.getValue(PoweredRailBlock.POWERED);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.isInWater()) {
            d3 *= 0.2;
        }
        Vec3 vec3d1 = this.getDeltaMovement();
        RailShape blockpropertytrackposition = state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
        switch (blockpropertytrackposition) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(vec3d1.add(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(vec3d1.add(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(vec3d1.add(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(vec3d1.add(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.getDeltaMovement();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
        Vec3i baseblockposition = (Vec3i)pair.getFirst();
        Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
        double d4 = baseblockposition1.getX() - baseblockposition.getX();
        double d5 = baseblockposition1.getZ() - baseblockposition.getZ();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.x * d4 + vec3d1.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.horizontalDistance());
        vec3d1 = new Vec3(d8 * d4 / d6, vec3d1.y, d8 * d5 / d6);
        this.setDeltaMovement(vec3d1);
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Vec3 vec3d2 = entity.getDeltaMovement();
            double d9 = vec3d2.horizontalDistanceSqr();
            double d10 = this.getDeltaMovement().horizontalDistanceSqr();
            if (d9 > 1.0E-4 && d10 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(vec3d2.x * 0.1, 0.0, vec3d2.z * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d11 = this.getDeltaMovement().horizontalDistance();
            if (d11 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double d11 = (double)pos.getX() + 0.5 + (double)baseblockposition.getX() * 0.5;
        double d12 = (double)pos.getZ() + 0.5 + (double)baseblockposition.getZ() * 0.5;
        double d13 = (double)pos.getX() + 0.5 + (double)baseblockposition1.getX() * 0.5;
        double d14 = (double)pos.getZ() + 0.5 + (double)baseblockposition1.getZ() * 0.5;
        d4 = d13 - d11;
        d5 = d14 - d12;
        if (d4 == 0.0) {
            d15 = d2 - (double)pos.getZ();
        } else if (d5 == 0.0) {
            d15 = d0 - (double)pos.getX();
        } else {
            d16 = d0 - d11;
            d17 = d2 - d12;
            d15 = (d16 * d4 + d17 * d5) * 2.0;
        }
        d0 = d11 + d4 * d15;
        d2 = d12 + d5 * d15;
        this.setPos(d0, d1, d2);
        d16 = this.isVehicle() ? 0.75 : 1.0;
        d17 = this.getMaxSpeed();
        vec3d1 = this.getDeltaMovement();
        this.move(MoverType.SELF, new Vec3(Mth.clamp(d16 * vec3d1.x, -d17, d17), 0.0, Mth.clamp(d16 * vec3d1.z, -d17, d17)));
        if (baseblockposition.getY() != 0 && Mth.floor(this.getX()) - pos.getX() == baseblockposition.getX() && Mth.floor(this.getZ()) - pos.getZ() == baseblockposition.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)baseblockposition.getY(), this.getZ());
        } else if (baseblockposition1.getY() != 0 && Mth.floor(this.getX()) - pos.getX() == baseblockposition1.getX() && Mth.floor(this.getZ()) - pos.getZ() == baseblockposition1.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)baseblockposition1.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3 vec3d3 = this.getPos(this.getX(), this.getY(), this.getZ());
        if (vec3d3 != null && vec3d != null) {
            double d19 = (vec3d.y - vec3d3.y) * 0.05;
            vec3d4 = this.getDeltaMovement();
            d18 = vec3d4.horizontalDistance();
            if (d18 > 0.0) {
                this.setDeltaMovement(vec3d4.multiply((d18 + d19) / d18, 1.0, (d18 + d19) / d18));
            }
            this.setPos(this.getX(), vec3d3.y, this.getZ());
        }
        int i = Mth.floor(this.getX());
        int j = Mth.floor(this.getZ());
        if (i != pos.getX() || j != pos.getZ()) {
            vec3d4 = this.getDeltaMovement();
            d18 = vec3d4.horizontalDistance();
            this.setDeltaMovement(d18 * (double)(i - pos.getX()), vec3d4.y, d18 * (double)(j - pos.getZ()));
        }
        if (flag) {
            vec3d4 = this.getDeltaMovement();
            d18 = vec3d4.horizontalDistance();
            if (d18 > 0.01) {
                double d20 = 0.06;
                this.setDeltaMovement(vec3d4.add(vec3d4.x / d18 * 0.06, 0.0, vec3d4.z / d18 * 0.06));
            } else {
                Vec3 vec3d5 = this.getDeltaMovement();
                double d21 = vec3d5.x;
                double d22 = vec3d5.z;
                if (blockpropertytrackposition == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(pos.west())) {
                        d21 = 0.02;
                    } else if (this.isRedstoneConductor(pos.east())) {
                        d21 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isRedstoneConductor(pos.north())) {
                        d22 = 0.02;
                    } else if (this.isRedstoneConductor(pos.south())) {
                        d22 = -0.02;
                    }
                }
                this.setDeltaMovement(d21, vec3d5.y, d22);
            }
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    private boolean isRedstoneConductor(BlockPos pos) {
        return this.level().getBlockState(pos).isRedstoneConductor(this.level(), pos);
    }

    protected void applyNaturalSlowdown() {
        double d0 = this.isVehicle() || !this.slowWhenEmpty ? 0.997 : 0.96;
        Vec3 vec3d = this.getDeltaMovement();
        vec3d = vec3d.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3d = vec3d.scale(0.95f);
        }
        this.setDeltaMovement(vec3d);
    }

    @Nullable
    public Vec3 getPosOffs(double x, double y, double z, double offset) {
        BlockState iblockdata;
        int i = Mth.floor(x);
        int j = Mth.floor(y);
        int k = Mth.floor(z);
        if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(iblockdata = this.level().getBlockState(new BlockPos(i, j, k)))) {
            RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
            y = j;
            if (blockpropertytrackposition.isAscending()) {
                y = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
            Vec3i baseblockposition = (Vec3i)pair.getFirst();
            Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
            double d4 = baseblockposition1.getX() - baseblockposition.getX();
            double d5 = baseblockposition1.getZ() - baseblockposition.getZ();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.getY() != 0 && Mth.floor(x += (d4 /= d6) * offset) - i == baseblockposition.getX() && Mth.floor(z += (d5 /= d6) * offset) - k == baseblockposition.getZ()) {
                y += (double)baseblockposition.getY();
            } else if (baseblockposition1.getY() != 0 && Mth.floor(x) - i == baseblockposition1.getX() && Mth.floor(z) - k == baseblockposition1.getZ()) {
                y += (double)baseblockposition1.getY();
            }
            return this.getPos(x, y, z);
        }
        return null;
    }

    @Nullable
    public Vec3 getPos(double x, double y, double z) {
        BlockState iblockdata;
        int i = Mth.floor(x);
        int j = Mth.floor(y);
        int k = Mth.floor(z);
        if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(iblockdata = this.level().getBlockState(new BlockPos(i, j, k)))) {
            double d12;
            RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
            Vec3i baseblockposition = (Vec3i)pair.getFirst();
            Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
            double d3 = (double)i + 0.5 + (double)baseblockposition.getX() * 0.5;
            double d4 = (double)j + 0.0625 + (double)baseblockposition.getY() * 0.5;
            double d5 = (double)k + 0.5 + (double)baseblockposition.getZ() * 0.5;
            double d6 = (double)i + 0.5 + (double)baseblockposition1.getX() * 0.5;
            double d7 = (double)j + 0.0625 + (double)baseblockposition1.getY() * 0.5;
            double d8 = (double)k + 0.5 + (double)baseblockposition1.getZ() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = z - (double)k;
            } else if (d11 == 0.0) {
                d12 = x - (double)i;
            } else {
                double d13 = x - d3;
                double d14 = z - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            x = d3 + d9 * d12;
            y = d4 + d10 * d12;
            z = d5 + d11 * d12;
            if (d10 < 0.0) {
                y += 1.0;
            } else if (d10 > 0.0) {
                y += 0.5;
            }
            return new Vec3(x, y, z);
        }
        return null;
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        AABB axisalignedbb = this.getBoundingBox();
        return this.hasCustomDisplay() ? axisalignedbb.inflate((double)Math.abs(this.getDisplayOffset()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), nbt.getCompound("DisplayState")));
            this.setDisplayOffset(nbt.getInt("DisplayOffset"));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        if (this.hasCustomDisplay()) {
            nbt.putBoolean("CustomDisplayTile", true);
            nbt.put("DisplayState", NbtUtils.writeBlockState(this.getDisplayBlockState()));
            nbt.putInt("DisplayOffset", this.getDisplayOffset());
        }
    }

    @Override
    public void push(Entity entity) {
        if (!(this.level().isClientSide || entity.noPhysics || this.noPhysics)) {
            if (!this.level().paperConfig().collisions.allowVehicleCollisions && this.level().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof Player)) {
                return;
            }
            if (!this.hasPassenger(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.getX() - this.getX();
                double d2 = d0 * d0 + (d1 = entity.getZ() - this.getZ()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof AbstractMinecart) {
                        Vec3 vec3d1;
                        double d5;
                        double d4 = entity.getX() - this.getX();
                        Vec3 vec3d = new Vec3(d4, 0.0, d5 = entity.getZ() - this.getZ()).normalize();
                        double d6 = Math.abs(vec3d.dot(vec3d1 = new Vec3(Mth.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, Mth.sin(this.getYRot() * ((float)Math.PI / 180))).normalize()));
                        if (d6 < (double)0.8f) {
                            return;
                        }
                        Vec3 vec3d2 = this.getDeltaMovement();
                        Vec3 vec3d3 = entity.getDeltaMovement();
                        if (((AbstractMinecart)entity).getMinecartType() == Type.FURNACE && this.getMinecartType() != Type.FURNACE) {
                            this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                            this.push(vec3d3.x - d0, 0.0, vec3d3.z - d1);
                            entity.setDeltaMovement(vec3d3.multiply(0.95, 1.0, 0.95));
                        } else if (((AbstractMinecart)entity).getMinecartType() != Type.FURNACE && this.getMinecartType() == Type.FURNACE) {
                            entity.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                            entity.push(vec3d2.x + d0, 0.0, vec3d2.z + d1);
                            this.setDeltaMovement(vec3d2.multiply(0.95, 1.0, 0.95));
                        } else {
                            double d7 = (vec3d3.x + vec3d2.x) / 2.0;
                            double d8 = (vec3d3.z + vec3d2.z) / 2.0;
                            this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                            this.push(d7 - d0, 0.0, d8 - d1);
                            entity.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                            entity.push(d7 + d0, 0.0, d8 + d1);
                        }
                    } else {
                        this.push(-d0, 0.0, -d1);
                        entity.push(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = interpolationSteps + 2;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpMotion(double x, double y, double z) {
        this.targetDeltaMovement = new Vec3(x, y, z);
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    public abstract Type getMinecartType();

    public BlockState getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : this.getEntityData().get(DATA_ID_DISPLAY_OFFSET).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState state) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(state));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int offset) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, offset);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean present) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, present);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(switch (this.getMinecartType().ordinal()) {
            case 1 -> Items.CHEST_MINECART;
            case 2 -> Items.FURNACE_MINECART;
            case 3 -> Items.TNT_MINECART;
            default -> Items.MINECART;
            case 5 -> Items.HOPPER_MINECART;
            case 6 -> Items.COMMAND_BLOCK_MINECART;
        });
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

