/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.inventory.ContainerData;

public abstract class DataSlot {
    private int prevValue;

    public static DataSlot forContainer(final ContainerData delegate, final int index) {
        return new DataSlot(){

            @Override
            @Override
            public int get() {
                return delegate.get(index);
            }

            @Override
            @Override
            public void set(int value) {
                delegate.set(index, value);
            }
        };
    }

    public static DataSlot shared(final int[] array, final int index) {
        return new DataSlot(){

            @Override
            @Override
            public int get() {
                return array[index];
            }

            @Override
            @Override
            public void set(int value) {
                array[index] = value;
            }
        };
    }

    public static DataSlot standalone() {
        return new DataSlot(){
            private int value;

            @Override
            @Override
            public int get() {
                return this.value;
            }

            @Override
            @Override
            public void set(int value) {
                this.value = value;
            }
        };
    }

    public abstract int get();

    public abstract void set(int var1);

    public boolean checkAndClearUpdateFlag() {
        int i = this.get();
        boolean bl = i != this.prevValue;
        this.prevValue = i;
        return bl;
    }
}

