/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.event.player.PlayerLecternPageChangeEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.inventory.view.CraftLecternView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;

public class LecternMenu
extends AbstractContainerMenu {
    private CraftLecternView bukkitEntity = null;
    private Player player;
    private static final int DATA_COUNT = 1;
    private static final int SLOT_COUNT = 1;
    public static final int BUTTON_PREV_PAGE = 1;
    public static final int BUTTON_NEXT_PAGE = 2;
    public static final int BUTTON_TAKE_BOOK = 3;
    public static final int BUTTON_PAGE_JUMP_RANGE_START = 100;
    private final Container lectern;
    private final ContainerData lecternData;

    @Override
    public CraftLecternView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLectern inventory = new CraftInventoryLectern(this.lectern);
        this.bukkitEntity = new CraftLecternView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public LecternMenu(int i, Inventory playerinventory) {
        this(i, new SimpleContainer(1), new SimpleContainerData(1), playerinventory);
    }

    public LecternMenu(int i, Container iinventory, ContainerData icontainerproperties, Inventory playerinventory) {
        super(MenuType.LECTERN, i);
        LecternMenu.checkContainerSize(iinventory, 1);
        LecternMenu.checkContainerDataCount(icontainerproperties, 1);
        this.lectern = iinventory;
        this.lecternData = icontainerproperties;
        this.addSlot(new Slot(iinventory, 0, 0, 0){

            @Override
            public void setChanged() {
                super.setChanged();
                LecternMenu.this.slotsChanged(this.container);
            }
        });
        this.addDataSlots(icontainerproperties);
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public boolean clickMenuButton(net.minecraft.world.entity.player.Player player, int id) {
        if (id >= 100) {
            int j = id - 100;
            this.setData(0, j);
            return true;
        }
        switch (id) {
            case 1: {
                int j = this.lecternData.get(0);
                CraftInventoryLectern bukkitView = (CraftInventoryLectern)this.getBukkitView().getTopInventory();
                PlayerLecternPageChangeEvent playerLecternPageChangeEvent = new PlayerLecternPageChangeEvent((Player)player.getBukkitEntity(), bukkitView.getHolder(), bukkitView.getBook(), PlayerLecternPageChangeEvent.PageChangeDirection.LEFT, j, j - 1);
                if (!playerLecternPageChangeEvent.callEvent()) {
                    return false;
                }
                this.setData(0, playerLecternPageChangeEvent.getNewPage());
                return true;
            }
            case 2: {
                int j = this.lecternData.get(0);
                CraftInventoryLectern bukkitView = (CraftInventoryLectern)this.getBukkitView().getTopInventory();
                PlayerLecternPageChangeEvent playerLecternPageChangeEvent = new PlayerLecternPageChangeEvent((Player)player.getBukkitEntity(), bukkitView.getHolder(), bukkitView.getBook(), PlayerLecternPageChangeEvent.PageChangeDirection.RIGHT, j, j + 1);
                if (!playerLecternPageChangeEvent.callEvent()) {
                    return false;
                }
                this.setData(0, playerLecternPageChangeEvent.getNewPage());
                return true;
            }
            case 3: {
                if (!player.mayBuild()) {
                    return false;
                }
                PlayerTakeLecternBookEvent event = new PlayerTakeLecternBookEvent(this.player, ((CraftInventoryLectern)this.getBukkitView().getTopInventory()).getHolder());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return false;
                }
                ItemStack itemstack = this.lectern.removeItemNoUpdate(0);
                this.lectern.setChanged();
                if (!player.getInventory().add(itemstack)) {
                    player.drop(itemstack, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack quickMoveStack(net.minecraft.world.entity.player.Player player, int slot) {
        return ItemStack.EMPTY;
    }

    @Override
    public void setData(int id, int value) {
        super.setData(id, value);
        this.broadcastChanges();
    }

    @Override
    public boolean stillValid(net.minecraft.world.entity.player.Player player) {
        if (this.lectern instanceof LecternBlockEntity.LecternInventory && !((LecternBlockEntity.LecternInventory)this.lectern).getLectern().hasBook()) {
            return false;
        }
        if (!this.checkReachable) {
            return true;
        }
        return this.lectern.stillValid(player);
    }

    public ItemStack getBook() {
        return this.lectern.getItem(0);
    }

    public int getPage() {
        return this.lecternData.get(0);
    }
}

