/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.event.player.PlayerPurchaseEvent;
import io.papermc.paper.event.player.PlayerTradeEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import org.bukkit.craftbukkit.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.inventory.CraftMerchantRecipe;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MerchantRecipe;

public class MerchantResultSlot
extends Slot {
    private final MerchantContainer slots;
    private final net.minecraft.world.entity.player.Player player;
    private int removeCount;
    private final Merchant merchant;

    public MerchantResultSlot(net.minecraft.world.entity.player.Player player, Merchant merchant, MerchantContainer merchantInventory, int index, int x, int y) {
        super(merchantInventory, index, x, y);
        this.player = player;
        this.merchant = merchant;
        this.slots = merchantInventory;
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    @Override
    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    @Override
    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        this.removeCount = 0;
    }

    @Override
    public void onTake(net.minecraft.world.entity.player.Player player, ItemStack stack) {
        MerchantOffer merchantOffer = this.slots.getActiveOffer();
        PlayerPurchaseEvent event = null;
        if (merchantOffer != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Merchant merchant = this.merchant;
            if (merchant instanceof AbstractVillager) {
                AbstractVillager abstractVillager = (AbstractVillager)merchant;
                event = new PlayerTradeEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.entity.AbstractVillager)abstractVillager.getBukkitEntity(), (MerchantRecipe)merchantOffer.asBukkit(), true, true);
            } else if (this.merchant instanceof CraftMerchantCustom.MinecraftMerchant) {
                event = new PlayerPurchaseEvent((Player)serverPlayer.getBukkitEntity(), (MerchantRecipe)merchantOffer.asBukkit(), false, true);
            }
            if (event != null) {
                if (!event.callEvent()) {
                    stack.setCount(0);
                    event.getPlayer().updateInventory();
                    return;
                }
                merchantOffer = CraftMerchantRecipe.fromBukkit(event.getTrade()).toMinecraft();
            }
        }
        this.checkTakeAchievements(stack);
        if (merchantOffer != null) {
            ItemStack itemStack2;
            ItemStack itemStack = this.slots.getItem(0);
            if (merchantOffer.take(itemStack, itemStack2 = this.slots.getItem(1)) || merchantOffer.take(itemStack2, itemStack)) {
                this.merchant.processTrade(merchantOffer, event);
                player.awardStat(Stats.TRADED_WITH_VILLAGER);
                this.slots.setItem(0, itemStack);
                this.slots.setItem(1, itemStack2);
            }
            this.merchant.overrideXp(this.merchant.getVillagerXp() + merchantOffer.getXp());
        }
    }
}

