/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;

public class FishingRodItem
extends Item {
    public FishingRodItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, net.minecraft.world.entity.player.Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (user.fishing != null) {
            if (!world.isClientSide) {
                int i = user.fishing.retrieve(hand, itemstack);
                itemstack.hurtAndBreak(i, user, LivingEntity.getSlotForHand(hand));
            }
            world.playSound((net.minecraft.world.entity.player.Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            user.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
        } else {
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                int j = (int)(EnchantmentHelper.getFishingTimeReduction(worldserver, itemstack, user) * 20.0f);
                int k = EnchantmentHelper.getFishingLuckBonus(worldserver, itemstack, user);
                FishingHook entityfishinghook = new FishingHook(user, world, k, j);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)user.getBukkitEntity(), null, (FishHook)entityfishinghook.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.FISHING);
                world.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    user.fishing = null;
                    return InteractionResultHolder.pass(itemstack);
                }
                world.playSound((net.minecraft.world.entity.player.Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
                world.addFreshEntity(entityfishinghook);
            }
            user.awardStat(Stats.ITEM_USED.get(this));
            user.gameEvent(GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess(itemstack, world.isClientSide());
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }
}

