/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;

public class ItemCooldowns {
    public final Map<Item, CooldownInstance> cooldowns = Maps.newHashMap();
    public int tickCount;

    public boolean isOnCooldown(Item item) {
        return this.getCooldownPercent(item, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(Item item, float tickDelta) {
        CooldownInstance cooldownInstance = this.cooldowns.get(item);
        if (cooldownInstance != null) {
            float f = cooldownInstance.endTime - cooldownInstance.startTime;
            float g = (float)cooldownInstance.endTime - ((float)this.tickCount + tickDelta);
            return Mth.clamp(g / f, 0.0f, 1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<Item, CooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Item, CooldownInstance> entry = iterator.next();
                if (entry.getValue().endTime > this.tickCount) continue;
                iterator.remove();
                this.onCooldownEnded(entry.getKey());
            }
        }
    }

    public void addCooldown(Item item, int duration) {
        this.cooldowns.put(item, new CooldownInstance(this.tickCount, this.tickCount + duration));
        this.onCooldownStarted(item, duration);
    }

    public void removeCooldown(Item item) {
        this.cooldowns.remove(item);
        this.onCooldownEnded(item);
    }

    protected void onCooldownStarted(Item item, int duration) {
    }

    protected void onCooldownEnded(Item item) {
    }

    public static class CooldownInstance {
        final int startTime;
        public final int endTime;

        CooldownInstance(int startTick, int endTick) {
            this.startTime = startTick;
            this.endTime = endTick;
        }
    }
}

