/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CapturedBlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    public static final Codec<Holder<Item>> ITEM_NON_AIR_CODEC = BuiltInRegistries.ITEM.holderByNameCodec().validate(holder -> holder.is(Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)holder));
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemstack -> itemstack.components.asPatch())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemstack -> itemstack.components.asPatch())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), itemstack -> itemstack.isEmpty() ? Optional.empty() : Optional.of(itemstack));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = ITEM_NON_AIR_CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ITEM);

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i = registryfriendlybytebuf.readVarInt();
            if (i <= 0) {
                return EMPTY;
            }
            Holder holder = (Holder)ITEM_STREAM_CODEC.decode(registryfriendlybytebuf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode(registryfriendlybytebuf);
            ItemStack itemstack = new ItemStack(holder, i, datacomponentpatch);
            return itemstack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.isEmpty() || itemstack.getItem() == null) {
                registryfriendlybytebuf.writeVarInt(0);
            } else {
                registryfriendlybytebuf.writeVarInt(itemstack.getCount());
                ITEM_STREAM_CODEC.encode(registryfriendlybytebuf, itemstack.getItemHolder());
                boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                try {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                    DataComponentPatch.STREAM_CODEC.encode(registryfriendlybytebuf, itemstack.components.asPatch());
                }
                finally {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                }
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            ItemStack itemstack = (ItemStack)OPTIONAL_STREAM_CODEC.decode(registryfriendlybytebuf);
            if (itemstack.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemstack;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode(registryfriendlybytebuf, itemstack);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final Component DISABLED_ITEM_TOOLTIP = Component.translatable("item.disabled").withStyle(ChatFormatting.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private Item item;
    private PatchedDataComponentMap components;
    @Nullable
    private net.minecraft.world.entity.Entity entityRepresentation;
    private CraftItemStack bukkitStack;

    private static DataResult<ItemStack> validateStrict(ItemStack stack) {
        DataResult<Unit> dataresult = ItemStack.validateComponents(stack.getComponents());
        return dataresult.isError() ? dataresult.map(unit -> stack) : (stack.getCount() > stack.getMaxStackSize() ? DataResult.error(() -> {
            int i = stack.getCount();
            return "Item stack with stack size of " + i + " was larger than maximum: " + stack.getMaxStackSize();
        }) : DataResult.success((Object)stack));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> basePacketCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)basePacketCodec.decode(registryfriendlybytebuf);
                if (!itemstack.isEmpty()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                basePacketCodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public ItemStack(ItemLike item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> entry) {
        this(entry.value(), 1);
    }

    public ItemStack(Holder<Item> item, int count, DataComponentPatch changes) {
        this(item.value(), count, PatchedDataComponentMap.fromPatch(item.value().components(), changes));
    }

    public ItemStack(Holder<Item> itemEntry, int count) {
        this(itemEntry.value(), count);
    }

    public ItemStack(ItemLike item, int count) {
        this(item, count, new PatchedDataComponentMap(item.asItem().components()));
    }

    private ItemStack(ItemLike item, int count, PatchedDataComponentMap components) {
        this.item = item.asItem();
        this.count = count;
        this.components = components;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void v) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap components) {
        int j;
        ItemStack itemstack;
        int i;
        if (components.has(DataComponents.MAX_DAMAGE) && components.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = components.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        Iterator<ItemStack> iterator = itemcontainercontents.nonEmptyItems().iterator();
        do {
            if (iterator.hasNext()) continue;
            return DataResult.success((Object)((Object)Unit.INSTANCE));
        } while ((i = (itemstack = iterator.next()).getCount()) <= (j = itemstack.getMaxStackSize()));
        int finalI = i;
        int finalJ = j;
        return DataResult.error(() -> "Item stack with count of " + finalI + " was larger than maximum: " + finalJ);
    }

    public static Optional<ItemStack> parse(HolderLookup.Provider registries, Tag nbt) {
        return CODEC.parse(registries.createSerializationContext(NbtOps.INSTANCE), (Object)nbt).resultOrPartial(s -> LOGGER.error("Tried to load invalid item: '{}'", s));
    }

    public static ItemStack parseOptional(HolderLookup.Provider registries, CompoundTag nbt) {
        return nbt.isEmpty() ? EMPTY : ItemStack.parse(registries, nbt).orElse(EMPTY);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet enabledFeatures) {
        return this.isEmpty() || this.getItem().isEnabled(enabledFeatures);
    }

    public ItemStack split(int amount) {
        int j = Math.min(amount, this.getCount());
        ItemStack itemstack = this.copyWithCount(j);
        this.shrink(j);
        return itemstack;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        this.setCount(0);
        return itemstack;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> tag) {
        return this.getItem().builtInRegistryHolder().is(tag);
    }

    public boolean is(Item item) {
        return this.getItem() == item;
    }

    public boolean is(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> itemEntry) {
        return this.getItem().builtInRegistryHolder() == itemEntry;
    }

    public boolean is(HolderSet<Item> registryEntryList) {
        return registryEntryList.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult enuminteractionresult;
        Player entityhuman = context.getPlayer();
        BlockPos blockposition = context.getClickedPos();
        if (entityhuman != null && !entityhuman.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new BlockInWorld(context.getLevel(), blockposition, false))) {
            return InteractionResult.PASS;
        }
        Item item = this.getItem();
        DataComponentPatch oldData = this.components.asPatch();
        int oldCount = this.getCount();
        ServerLevel world = (ServerLevel)context.getLevel();
        if (!(item instanceof BucketItem)) {
            world.captureBlockStates = true;
            if (item == Items.BONE_MEAL) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.useOn(context);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.components.asPatch();
        int newCount = this.getCount();
        this.setCount(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.consumesAction() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = SaplingBlock.treeType;
            SaplingBlock.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.getItem() == Items.BONE_MEAL;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (org.bukkit.entity.Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (org.bukkit.entity.Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), oldData)) {
                    this.restorePatch(newData);
                    this.setCount(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                    world.checkCapturedTreeStateForObserverNotify(blockposition, blockstate);
                }
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
            }
            SignItem.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.indicateItemUse()) {
            InteractionHand enumhand = context.getHand();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.getX(), blockposition.getY(), blockposition.getZ());
            } else if (blocks.size() == 1 && item != Items.POWDER_SNOW_BUCKET) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.getX(), blockposition.getY(), blockposition.getZ());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = InteractionResult.FAIL;
                placeEvent.getPlayer().updateInventory();
                world.capturedTileEntities.clear();
                world.preventPoiUpdated = true;
                world.isBlockPlaceCancelled = true;
                for (BlockState blockstate : blocks) {
                    blockstate.update(true, false);
                }
                world.isBlockPlaceCancelled = false;
                world.preventPoiUpdated = false;
                SignItem.openSign = null;
            } else {
                BlockPos position;
                net.minecraft.world.level.block.state.BlockState blockData;
                BlockEntity te;
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), oldData)) {
                    this.restorePatch(newData);
                    this.setCount(newCount);
                }
                for (Map.Entry<BlockPos, BlockEntity> e : world.capturedTileEntities.entrySet()) {
                    world.setBlockEntity(e.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    net.minecraft.world.level.block.state.BlockState oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPos newblockposition = ((CraftBlockState)blockstate).getPosition();
                    net.minecraft.world.level.block.state.BlockState block = world.getBlockState(newblockposition);
                    if (!(block.getBlock() instanceof BaseEntityBlock)) {
                        block.onPlace(world, newblockposition, oldBlock, true, context);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.getBlockState(newblockposition), updateFlag, 512);
                }
                if (this.item == Items.WITHER_SKELETON_SKULL) {
                    BlockPos bp = blockposition;
                    if (!world.getBlockState(blockposition).canBeReplaced()) {
                        bp = !world.getBlockState(blockposition).isSolid() ? null : bp.relative(context.getClickedFace());
                    }
                    if (bp != null && (te = world.getBlockEntity(bp)) instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn(world, bp, (SkullBlockEntity)te);
                    }
                }
                if (this.item instanceof SignItem && SignItem.openSign != null) {
                    try {
                        te = world.getBlockEntity(SignItem.openSign);
                        if (te instanceof SignBlockEntity) {
                            SignBlockEntity tileentitysign = (SignBlockEntity)te;
                            Block updateFlag = world.getBlockState(SignItem.openSign).getBlock();
                            if (updateFlag instanceof SignBlock) {
                                SignBlock blocksign = (SignBlock)updateFlag;
                                blocksign.openTextEdit(entityhuman, tileentitysign, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        SignItem.openSign = null;
                    }
                }
                if (placeEvent != null && this.item instanceof BedItem && (blockData = world.getBlockState(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).getBlock() instanceof BedBlock) {
                    world.blockUpdated(position, Blocks.AIR);
                    blockData.updateNeighbourShapes(world, position, 3);
                }
                if (this.item instanceof BlockItem) {
                    position = new BlockPlaceContext(context).getClickedPos();
                    blockData = world.getBlockState(position);
                    SoundType soundeffecttype = blockData.getSoundType();
                    world.playSound(entityhuman, blockposition, soundeffecttype.getPlaceSound(), SoundSource.BLOCKS, (soundeffecttype.getVolume() + 1.0f) / 2.0f, soundeffecttype.getPitch() * 0.8f);
                }
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float getDestroySpeed(net.minecraft.world.level.block.state.BlockState state) {
        return this.getItem().getDestroySpeed(this, state);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return this.getItem().use(world, user, hand);
    }

    public ItemStack finishUsingItem(Level world, LivingEntity user) {
        return this.getItem().finishUsingItem(this, world, user);
    }

    public Tag save(HolderLookup.Provider registries, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (Tag)CODEC.encode((Object)this, registries.createSerializationContext(NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    public Tag save(HolderLookup.Provider registries) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (Tag)CODEC.encodeStart(registries.createSerializationContext(NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public Tag saveOptional(HolderLookup.Provider registries) {
        return this.isEmpty() ? new CompoundTag() : this.save(registries, new CompoundTag());
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return Mth.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int damage) {
        this.set(DataComponents.DAMAGE, Mth.clamp(damage, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public void hurtAndBreak(int amount, ServerLevel world, @Nullable LivingEntity player, Consumer<Item> breakCallback) {
        this.hurtAndBreak(amount, world, player, breakCallback, false);
    }

    public void hurtAndBreak(int amount, ServerLevel world, @Nullable LivingEntity player, Consumer<Item> breakCallback, boolean force) {
        if (this.isDamageableItem() && (player == null || !player.hasInfiniteMaterials() || force)) {
            if (amount > 0) {
                int originalDamage = amount;
                amount = EnchantmentHelper.processDurabilityChange(world, this, amount);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    event = new PlayerItemDamageEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount, originalDamage);
                    event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                    if (amount != event.getDamage() || event.isCancelled()) {
                        event.getPlayer().updateInventory();
                    }
                    if (event.isCancelled()) {
                        return;
                    }
                    amount = event.getDamage();
                } else if (player != null) {
                    event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
                    if (!event.callEvent()) {
                        return;
                    }
                    amount = event.getDamage();
                }
                if (amount <= 0) {
                    return;
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (amount != 0) {
                    CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(serverPlayer, this, this.getDamageValue() + amount);
                }
            }
            int j = this.getDamageValue() + amount;
            this.setDamageValue(j);
            if (j >= this.getMaxDamage()) {
                Item item = this.getItem();
                if (this.count == 1 && player != null && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CraftEventFactory.callPlayerItemBreakEvent(serverPlayer, this);
                }
                this.shrink(1);
                breakCallback.accept(item);
            }
        }
    }

    public void hurtAndBreak(int amount, LivingEntity entity, EquipmentSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, LivingEntity entity, EquipmentSlot slot, boolean force) {
        Level world = entity.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer1;
                ServerPlayer entityplayer = entityplayer1 = (ServerPlayer)entity;
            } else {
                Object entityplayer = null;
            }
            this.hurtAndBreak(amount, worldserver, entity, item -> {
                if (slot != null) {
                    entity.onEquippedItemBroken((Item)item, slot);
                }
            }, force);
        }
    }

    public ItemStack hurtAndConvertOnBreak(int amount, ItemLike itemAfterBreaking, LivingEntity entity, EquipmentSlot slot) {
        this.hurtAndBreak(amount, entity, slot);
        if (this.isEmpty()) {
            ItemStack itemstack = this.transmuteCopyIgnoreEmpty(itemAfterBreaking, 1);
            if (itemstack.isDamageableItem()) {
                itemstack.setDamageValue(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot slot, ClickAction clickType, Player player) {
        return this.getItem().overrideStackedOnOther(this, slot, clickType, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return this.getItem().overrideOtherStackedOnMe(this, stack, slot, clickType, player, cursorStackReference);
    }

    public boolean hurtEnemy(LivingEntity target, Player player) {
        Item item = this.getItem();
        if (item.hurtEnemy(this, target, player)) {
            player.awardStat(Stats.ITEM_USED.get(item));
            return true;
        }
        return false;
    }

    public void postHurtEnemy(LivingEntity target, Player player) {
        this.getItem().postHurtEnemy(this, target, player);
    }

    public void mineBlock(Level world, net.minecraft.world.level.block.state.BlockState state, BlockPos pos, Player miner) {
        Item item = this.getItem();
        if (item.mineBlock(this, world, state, pos, miner)) {
            miner.awardStat(Stats.ITEM_USED.get(item));
        }
    }

    public boolean isCorrectToolForDrops(net.minecraft.world.level.block.state.BlockState state) {
        return this.getItem().isCorrectToolForDrops(this, state);
    }

    public InteractionResult interactLivingEntity(Player user, LivingEntity entity, InteractionHand hand) {
        return this.getItem().interactLivingEntity(this, user, entity, hand);
    }

    public ItemStack copy() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = new ItemStack(originalItem ? this.item : this.getItem(), this.count, this.components.copy());
        itemstack.setPopTime(this.getPopTime());
        return itemstack;
    }

    public ItemStack copyWithCount(int count) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        itemstack.setCount(count);
        return itemstack;
    }

    public ItemStack transmuteCopy(ItemLike item) {
        return this.transmuteCopy(item, this.getCount());
    }

    public ItemStack transmuteCopy(ItemLike item, int count) {
        return this.isEmpty() ? EMPTY : this.transmuteCopyIgnoreEmpty(item, count);
    }

    private ItemStack transmuteCopyIgnoreEmpty(ItemLike item, int count) {
        return new ItemStack(item.asItem().builtInRegistryHolder(), count, this.components.asPatch());
    }

    public static boolean matches(ItemStack left, ItemStack right) {
        return left == right ? true : (left.getCount() != right.getCount() ? false : ItemStack.isSameItemSameComponents(left, right));
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> left, List<ItemStack> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (ItemStack.matches(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack left, ItemStack right) {
        return left.is(right.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack stack, ItemStack otherStack) {
        return !stack.is(otherStack.getItem()) ? false : (stack.isEmpty() && otherStack.isEmpty() ? true : Objects.equals(stack.components, otherStack.components));
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String fieldName) {
        return CODEC.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(EMPTY), itemstack -> itemstack.isEmpty() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int hashItemAndComponents(@Nullable ItemStack stack) {
        if (stack != null) {
            int i = 31 + stack.getItem().hashCode();
            return 31 * i + stack.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> stacks) {
        int i = 0;
        for (ItemStack itemstack : stacks) {
            i = i * 31 + ItemStack.hashItemAndComponents(itemstack);
        }
        return i;
    }

    public String getDescriptionId() {
        return this.getItem().getDescriptionId(this);
    }

    public String toString() {
        int i = this.getCount();
        return i + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(Level world, net.minecraft.world.entity.Entity entity, int slot, boolean selected) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (this.getItem() != null) {
            this.getItem().inventoryTick(this, world, entity, slot, selected);
        }
    }

    public void onCraftedBy(Level world, Player player, int amount) {
        player.awardStat(Stats.ITEM_CRAFTED.get(this.getItem()), amount);
        this.getItem().onCraftedBy(this, world, player);
    }

    public void onCraftedBySystem(Level world) {
        this.getItem().onCraftedPostProcess(this, world);
    }

    public int getUseDuration(LivingEntity user) {
        return this.getItem().getUseDuration(this, user);
    }

    public UseAnim getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(Level world, LivingEntity user, int remainingUseTicks) {
        this.getItem().releaseUsing(this, world, user, remainingUseTicks);
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.components.restorePatch(datacomponentpatch);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> type, @Nullable T value) {
        return this.components.set(type, value);
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> type, T defaultValue, U change, BiFunction<T, U, T> applier) {
        return this.set(type, applier.apply(this.getOrDefault(type, defaultValue), change));
    }

    @Nullable
    public <T> T update(DataComponentType<T> type, T defaultValue, UnaryOperator<T> applier) {
        T t1 = this.getOrDefault(type, defaultValue);
        return this.set(type, applier.apply(t1));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> type) {
        return this.components.remove(type);
    }

    public void applyComponentsAndValidate(DataComponentPatch changes) {
        DataComponentPatch datacomponentpatch1 = this.components.asPatch();
        this.components.applyPatch(changes);
        Optional optional = ItemStack.validateStrict(this).error();
        if (optional.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)changes, (Object)((DataResult.Error)optional.get()).message());
            this.components.restorePatch(datacomponentpatch1);
        } else {
            this.getItem().verifyComponentsAfterLoad(this);
        }
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.copy());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void applyComponents(DataComponentPatch changes) {
        this.components.applyPatch(changes);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap components) {
        this.components.setAll(components);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public Component getHoverName() {
        Component ichatbasecomponent = this.get(DataComponents.CUSTOM_NAME);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        Component ichatbasecomponent1 = this.get(DataComponents.ITEM_NAME);
        return ichatbasecomponent1 != null ? ichatbasecomponent1 : this.getItem().getName(this);
    }

    private <T extends TooltipProvider> void addToTooltip(DataComponentType<T> componentType, Item.TooltipContext context, Consumer<Component> textConsumer, TooltipFlag type) {
        TooltipProvider t0 = (TooltipProvider)this.get(componentType);
        if (t0 != null) {
            t0.addToTooltip(context, textConsumer, type);
        }
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, @Nullable Player player, TooltipFlag type) {
        AdventureModePredicate adventuremodepredicate1;
        MapId mapid;
        if (!type.isCreative() && this.has(DataComponents.HIDE_TOOLTIP)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        MutableComponent ichatmutablecomponent = Component.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            ichatmutablecomponent.withStyle(ChatFormatting.ITALIC);
        }
        list.add(ichatmutablecomponent);
        if (!type.isAdvanced() && !this.has(DataComponents.CUSTOM_NAME) && this.is(Items.FILLED_MAP) && (mapid = this.get(DataComponents.MAP_ID)) != null) {
            list.add(MapItem.getTooltipForId(mapid));
        }
        Objects.requireNonNull(list);
        Consumer<Component> consumer = list::add;
        if (!this.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            this.getItem().appendHoverText(this, context, list, type);
        }
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, context, consumer, type);
        this.addToTooltip(DataComponents.TRIM, context, consumer, type);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, context, consumer, type);
        this.addToTooltip(DataComponents.ENCHANTMENTS, context, consumer, type);
        this.addToTooltip(DataComponents.DYED_COLOR, context, consumer, type);
        this.addToTooltip(DataComponents.LORE, context, consumer, type);
        this.addAttributeTooltips(consumer, player);
        this.addToTooltip(DataComponents.UNBREAKABLE, context, consumer, type);
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_BREAK);
        if (adventuremodepredicate != null && adventuremodepredicate.showInTooltip()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            adventuremodepredicate.addToTooltip(consumer);
        }
        if ((adventuremodepredicate1 = this.get(DataComponents.CAN_PLACE_ON)) != null && adventuremodepredicate1.showInTooltip()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            adventuremodepredicate1.addToTooltip(consumer);
        }
        if (type.isAdvanced()) {
            if (this.isDamaged()) {
                list.add(Component.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            list.add(Component.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            int i = this.components.size();
            if (i > 0) {
                list.add(Component.translatable("item.components", i).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (player != null && !this.getItem().isEnabled(player.level().enabledFeatures())) {
            list.add(DISABLED_ITEM_TOOLTIP);
        }
        return list;
    }

    private void addAttributeTooltips(Consumer<Component> textConsumer, @Nullable Player player) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (itemattributemodifiers.showInTooltip()) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.forEachModifier(equipmentslotgroup, (Holder<Attribute> holder, AttributeModifier attributemodifier) -> {
                    if (mutableboolean.isTrue()) {
                        textConsumer.accept(CommonComponents.EMPTY);
                        textConsumer.accept(Component.translatable("item.modifiers." + equipmentslotgroup.getSerializedName()).withStyle(ChatFormatting.GRAY));
                        mutableboolean.setFalse();
                    }
                    this.addModifierTooltip(textConsumer, player, (Holder<Attribute>)holder, (AttributeModifier)attributemodifier);
                });
            }
        }
    }

    private void addModifierTooltip(Consumer<Component> textConsumer, @Nullable Player player, Holder<Attribute> attribute, AttributeModifier modifier) {
        double d0 = modifier.amount();
        boolean flag = false;
        if (player != null) {
            if (modifier.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                d0 += player.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                flag = true;
            } else if (modifier.is(Item.BASE_ATTACK_SPEED_ID)) {
                d0 += player.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                flag = true;
            }
        }
        double d1 = modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? (attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (flag) {
            textConsumer.accept(CommonComponents.space().append(Component.translatable("attribute.modifier.equals." + modifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable(attribute.value().getDescriptionId()))).withStyle(ChatFormatting.DARK_GREEN));
        } else if (d0 > 0.0) {
            textConsumer.accept(Component.translatable("attribute.modifier.plus." + modifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable(attribute.value().getDescriptionId())).withStyle(attribute.value().getStyle(true)));
        } else if (d0 < 0.0) {
            textConsumer.accept(Component.translatable("attribute.modifier.take." + modifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d1), Component.translatable(attribute.value().getDescriptionId())).withStyle(attribute.value().getStyle(false)));
        }
    }

    public boolean hasFoil() {
        Boolean obool = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        return obool != null ? obool.booleanValue() : this.getItem().isFoil(this);
    }

    public Rarity getRarity() {
        Rarity enumitemrarity = this.getOrDefault(DataComponents.RARITY, Rarity.COMMON);
        if (!this.isEnchanted()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            default -> enumitemrarity;
        };
    }

    public boolean isEnchantable() {
        if (!this.getItem().isEnchantable(this)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.get(DataComponents.ENCHANTMENTS);
        return itemenchantments != null && itemenchantments.isEmpty();
    }

    public void enchant(Holder<Enchantment> enchantment, int level) {
        EnchantmentHelper.updateEnchantments(this, itemenchantments_a -> itemenchantments_a.upgrade(enchantment, level));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof ItemFrame;
    }

    public void setEntityRepresentation(@Nullable net.minecraft.world.entity.Entity holder) {
        if (!this.isEmpty()) {
            this.entityRepresentation = holder;
        }
    }

    @Nullable
    public ItemFrame getFrame() {
        return this.entityRepresentation instanceof ItemFrame ? (ItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributeModifierConsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (!itemattributemodifiers.modifiers().isEmpty()) {
            itemattributemodifiers.forEach(slot, attributeModifierConsumer);
        } else {
            this.getItem().getDefaultAttributeModifiers().forEach(slot, attributeModifierConsumer);
        }
        EnchantmentHelper.forEachModifier(this, slot, attributeModifierConsumer);
    }

    public void forEachModifier(EquipmentSlot slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributeModifierConsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (!itemattributemodifiers.modifiers().isEmpty()) {
            itemattributemodifiers.forEach(slot, attributeModifierConsumer);
        } else {
            this.getItem().getDefaultAttributeModifiers().forEach(slot, attributeModifierConsumer);
        }
        EnchantmentHelper.forEachModifier(this, slot, attributeModifierConsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.item = item;
        DataComponentPatch patch = this.getComponentsPatch();
        this.components = new PatchedDataComponentMap(this.item.components());
        this.applyComponents(patch);
    }

    public Component getDisplayName() {
        MutableComponent ichatmutablecomponent = Component.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            ichatmutablecomponent.withStyle(ChatFormatting.ITALIC);
        }
        MutableComponent ichatmutablecomponent1 = ComponentUtils.wrapInSquareBrackets(ichatmutablecomponent);
        if (!this.isEmpty()) {
            ichatmutablecomponent1.withStyle(this.getRarity().color()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new HoverEvent.ItemStackInfo(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean canPlaceOnBlockInAdventureMode(BlockInWorld pos) {
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_PLACE_ON);
        return adventuremodepredicate != null && adventuremodepredicate.test(pos);
    }

    public boolean canBreakBlockInAdventureMode(BlockInWorld pos) {
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_BREAK);
        return adventuremodepredicate != null && adventuremodepredicate.test(pos);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int bobbingAnimationTime) {
        this.popTime = bobbingAnimationTime;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void limitSize(int maxCount) {
        if (!this.isEmpty() && this.getCount() > maxCount) {
            this.setCount(maxCount);
        }
    }

    public void grow(int amount) {
        this.setCount(this.getCount() + amount);
    }

    public void shrink(int amount) {
        this.grow(-amount);
    }

    public void consume(int amount, @Nullable LivingEntity entity) {
        if (!(entity != null && entity.hasInfiniteMaterials() || this == EMPTY)) {
            this.shrink(amount);
        }
    }

    public ItemStack consumeAndReturn(int amount, @Nullable LivingEntity entity) {
        ItemStack itemstack = this.copyWithCount(amount);
        this.consume(amount, entity);
        return itemstack;
    }

    public void onUseTick(Level world, LivingEntity user, int remainingUseTicks) {
        this.getItem().onUseTick(world, user, this, remainingUseTicks);
    }

    public void onDestroyed(ItemEntity entity) {
        this.getItem().onDestroyed(entity);
    }

    public SoundEvent getDrinkingSound() {
        return this.getItem().getDrinkingSound();
    }

    public SoundEvent getEatingSound() {
        return this.getItem().getEatingSound();
    }

    public SoundEvent getBreakingSound() {
        return this.getItem().getBreakingSound();
    }

    public boolean canBeHurtBy(DamageSource source) {
        return !this.has(DataComponents.FIRE_RESISTANT) || !source.is(DamageTypeTags.IS_FIRE);
    }
}

