/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class ProjectileWeaponItem
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = itemstack -> itemstack.is(ItemTags.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(itemstack -> itemstack.is(Items.FIREWORK_ROCKET));

    public ProjectileWeaponItem(Item.Properties settings) {
        super(settings);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(LivingEntity entity, Predicate<ItemStack> predicate) {
        return predicate.test(entity.getItemInHand(InteractionHand.OFF_HAND)) ? entity.getItemInHand(InteractionHand.OFF_HAND) : (predicate.test(entity.getItemInHand(InteractionHand.MAIN_HAND)) ? entity.getItemInHand(InteractionHand.MAIN_HAND) : ItemStack.EMPTY);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(ServerLevel world, LivingEntity shooter, InteractionHand hand, ItemStack stack, List<ItemStack> projectiles, float speed, float divergence, boolean critical, @Nullable LivingEntity target) {
        float f2 = EnchantmentHelper.processProjectileSpread(world, stack, shooter, 0.0f);
        float f3 = projectiles.size() == 1 ? 0.0f : 2.0f * f2 / (float)(projectiles.size() - 1);
        float f4 = (float)((projectiles.size() - 1) % 2) * f3 / 2.0f;
        float f5 = 1.0f;
        for (int i = 0; i < projectiles.size(); ++i) {
            ItemStack itemstack1 = projectiles.get(i);
            if (itemstack1.isEmpty()) continue;
            float f6 = f4 + f5 * (float)((i + 1) / 2) * f3;
            f5 = -f5;
            Projectile iprojectile = this.createProjectile(world, shooter, stack, itemstack1, critical);
            this.shootProjectile(shooter, iprojectile, i, speed, divergence, f6, target);
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(shooter, stack, itemstack1, iprojectile, hand, speed, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == iprojectile.getBukkitEntity() && !world.addFreshEntity(iprojectile)) {
                if (shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).getBukkitEntity().updateInventory();
                }
                return;
            }
            stack.hurtAndBreak(this.getDurabilityUse(itemstack1), shooter, LivingEntity.getSlotForHand(hand));
            if (stack.isEmpty()) break;
        }
    }

    protected int getDurabilityUse(ItemStack projectile) {
        return 1;
    }

    protected abstract void shootProjectile(LivingEntity var1, Projectile var2, int var3, float var4, float var5, float var6, @Nullable LivingEntity var7);

    protected Projectile createProjectile(Level world, LivingEntity shooter, ItemStack weaponStack, ItemStack projectileStack, boolean critical) {
        ArrowItem itemarrow1;
        Item item = projectileStack.getItem();
        ArrowItem itemarrow = item instanceof ArrowItem ? (itemarrow1 = (ArrowItem)item) : (ArrowItem)Items.ARROW;
        ArrowItem itemarrow2 = itemarrow;
        AbstractArrow entityarrow = itemarrow2.createArrow(world, projectileStack, shooter, weaponStack);
        if (critical) {
            entityarrow.setCritArrow(true);
        }
        return entityarrow;
    }

    protected static List<ItemStack> draw(ItemStack stack, ItemStack projectileStack, LivingEntity shooter) {
        return ProjectileWeaponItem.draw(stack, projectileStack, shooter, true);
    }

    protected static List<ItemStack> draw(ItemStack stack, ItemStack projectileStack, LivingEntity shooter, boolean consume) {
        int i;
        if (projectileStack.isEmpty()) {
            return List.of();
        }
        Level world = shooter.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            i = EnchantmentHelper.processProjectileCount(worldserver, stack, shooter, 1);
        } else {
            i = 1;
        }
        int j = i;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(j);
        ItemStack itemstack2 = projectileStack.copy();
        for (int k = 0; k < j; ++k) {
            ItemStack itemstack3 = ProjectileWeaponItem.useAmmo(stack, k == 0 ? projectileStack : itemstack2, shooter, k > 0 || !consume);
            if (itemstack3.isEmpty()) continue;
            list.add(itemstack3);
        }
        return list;
    }

    protected static ItemStack useAmmo(ItemStack stack, ItemStack projectileStack, LivingEntity shooter, boolean multishot) {
        ItemStack itemstack2;
        int i;
        Level world;
        if (!multishot && !shooter.hasInfiniteMaterials() && (world = shooter.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            i = EnchantmentHelper.processAmmoUse(worldserver, stack, projectileStack, 1);
        } else {
            i = 0;
        }
        int j = i;
        if (j > projectileStack.getCount()) {
            return ItemStack.EMPTY;
        }
        if (j == 0) {
            itemstack2 = projectileStack.copyWithCount(1);
            itemstack2.set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return itemstack2;
        }
        itemstack2 = projectileStack.split(j);
        if (projectileStack.isEmpty() && shooter instanceof Player) {
            Player entityhuman = (Player)shooter;
            entityhuman.getInventory().removeItem(projectileStack);
        }
        return itemstack2;
    }
}

