/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;

public class PotentialCalculator {
    private final List<PointCharge> charges = Lists.newArrayList();

    public void addCharge(BlockPos pos, double mass) {
        if (mass != 0.0) {
            this.charges.add(new PointCharge(pos, mass));
        }
    }

    public double getPotentialEnergyChange(BlockPos pos, double mass) {
        if (mass == 0.0) {
            return 0.0;
        }
        double d = 0.0;
        for (PointCharge pointCharge : this.charges) {
            d += pointCharge.getPotentialChange(pos);
        }
        return d * mass;
    }

    static class PointCharge {
        private final BlockPos pos;
        private final double charge;

        public PointCharge(BlockPos pos, double mass) {
            this.pos = pos;
            this.charge = mass;
        }

        public double getPotentialChange(BlockPos pos) {
            double d = this.pos.distSqr(pos);
            if (d == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return this.charge / Math.sqrt(d);
        }
    }
}

