/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.block.BlockBreakBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class Block
extends BlockBehaviour
implements ItemLike {
    public static final MapCodec<Block> CODEC = Block.simpleCodec(Block::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Holder.Reference<Block> builtInRegistryHolder = BuiltInRegistries.BLOCK.createIntrusiveHolder(this);
    public static final IdMapper<BlockState> BLOCK_STATE_REGISTRY = new IdMapper();
    private static final LoadingCache<VoxelShape, Boolean> SHAPE_FULL_BLOCK_CACHE = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape voxelshape) {
            return !Shapes.joinIsNotEmpty(Shapes.block(), voxelshape, BooleanOp.NOT_SAME);
        }
    });
    public static final int UPDATE_NEIGHBORS = 1;
    public static final int UPDATE_CLIENTS = 2;
    public static final int UPDATE_INVISIBLE = 4;
    public static final int UPDATE_IMMEDIATE = 8;
    public static final int UPDATE_KNOWN_SHAPE = 16;
    public static final int UPDATE_SUPPRESS_DROPS = 32;
    public static final int UPDATE_MOVE_BY_PISTON = 64;
    public static final int UPDATE_NONE = 4;
    public static final int UPDATE_ALL = 3;
    public static final int UPDATE_ALL_IMMEDIATE = 11;
    public static final float INDESTRUCTIBLE = -1.0f;
    public static final float INSTANT = 0.0f;
    public static final int UPDATE_LIMIT = 512;
    protected final StateDefinition<Block, BlockState> stateDefinition;
    private BlockState defaultBlockState;
    public Timing timing;
    @Nullable
    private String descriptionId;
    @Nullable
    private Item item;
    private static final int CACHE_SIZE = 2048;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<BlockStatePairKey>(2048, 0.25f){

            protected void rehash(int i) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public final boolean isDestroyable() {
        return GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || this != Blocks.BARRIER && this != Blocks.BEDROCK && this != Blocks.END_PORTAL_FRAME && this != Blocks.END_PORTAL && this != Blocks.END_GATEWAY && this != Blocks.COMMAND_BLOCK && this != Blocks.REPEATING_COMMAND_BLOCK && this != Blocks.CHAIN_COMMAND_BLOCK && this != Blocks.STRUCTURE_BLOCK && this != Blocks.JIGSAW;
    }

    public Timing getTiming() {
        if (this.timing == null) {
            this.timing = MinecraftTimings.getBlockTiming(this);
        }
        return this.timing;
    }

    @Override
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public static int getId(@Nullable BlockState state) {
        if (state == null) {
            return 0;
        }
        int i = BLOCK_STATE_REGISTRY.getId(state);
        return i == -1 ? 0 : i;
    }

    public static BlockState stateById(int stateId) {
        BlockState iblockdata = BLOCK_STATE_REGISTRY.byId(stateId);
        return iblockdata == null ? Blocks.AIR.defaultBlockState() : iblockdata;
    }

    public static Block byItem(@Nullable Item item) {
        return item instanceof BlockItem ? ((BlockItem)item).getBlock() : Blocks.AIR;
    }

    public static BlockState pushEntitiesUp(BlockState from, BlockState to, LevelAccessor world, BlockPos pos) {
        VoxelShape voxelshape = Shapes.joinUnoptimized(from.getCollisionShape(world, pos), to.getCollisionShape(world, pos), BooleanOp.ONLY_SECOND).move(pos.getX(), pos.getY(), pos.getZ());
        if (voxelshape.isEmpty()) {
            return to;
        }
        List<Entity> list = world.getEntities(null, voxelshape.bounds());
        for (Entity entity : list) {
            double d0 = Shapes.collide(Direction.Axis.Y, entity.getBoundingBox().move(0.0, 1.0, 0.0), List.of(voxelshape), -1.0);
            entity.teleportRelative(0.0, 1.0 + d0, 0.0);
        }
        return to;
    }

    public static VoxelShape box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Shapes.box(minX / 16.0, minY / 16.0, minZ / 16.0, maxX / 16.0, maxY / 16.0, maxZ / 16.0);
    }

    public static BlockState updateFromNeighbourShapes(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState iblockdata1 = state;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : BlockBehaviour.UPDATE_SHAPE_ORDER) {
            blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection);
            iblockdata1 = iblockdata1.updateShape(enumdirection, world.getBlockState(blockposition_mutableblockposition), world, pos, blockposition_mutableblockposition);
        }
        return iblockdata1;
    }

    public static void updateOrDestroy(BlockState state, BlockState newState, LevelAccessor world, BlockPos pos, int flags) {
        Block.updateOrDestroy(state, newState, world, pos, flags, 512);
    }

    public static void updateOrDestroy(BlockState state, BlockState newState, LevelAccessor world, BlockPos pos, int flags, int maxUpdateDepth) {
        if (newState != state) {
            if (newState.isAir()) {
                if (!world.isClientSide()) {
                    world.destroyBlock(pos, (flags & 0x20) == 0, null, maxUpdateDepth);
                }
            } else {
                world.setBlock(pos, newState, flags & 0xFFFFFFDF, maxUpdateDepth);
            }
        }
    }

    public Block(BlockBehaviour.Properties settings) {
        super(settings);
        String s;
        StateDefinition.Builder<Block, BlockState> blockstatelist_a = new StateDefinition.Builder<Block, BlockState>(this);
        this.createBlockStateDefinition(blockstatelist_a);
        this.stateDefinition = blockstatelist_a.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState(this.stateDefinition.any());
        if (SharedConstants.IS_RUNNING_IN_IDE && !(s = this.getClass().getSimpleName()).endsWith("Block")) {
            LOGGER.error("Block classes should end with Block and {} doesn't.", (Object)s);
        }
    }

    public static boolean isExceptionForConnection(BlockState state) {
        return state.getBlock() instanceof LeavesBlock || state.is(Blocks.BARRIER) || state.is(Blocks.CARVED_PUMPKIN) || state.is(Blocks.JACK_O_LANTERN) || state.is(Blocks.MELON) || state.is(Blocks.PUMPKIN) || state.is(BlockTags.SHULKER_BOXES);
    }

    public static boolean shouldRenderFace(BlockState state, BlockGetter world, BlockPos pos, Direction side, BlockPos otherPos) {
        BlockState iblockdata1 = world.getBlockState(otherPos);
        if (state.skipRendering(iblockdata1, side)) {
            return false;
        }
        if (iblockdata1.canOcclude()) {
            BlockStatePairKey block_a = new BlockStatePairKey(state, iblockdata1, side);
            Object2ByteLinkedOpenHashMap<BlockStatePairKey> object2bytelinkedopenhashmap = OCCLUSION_CACHE.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block_a);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = state.getFaceOcclusionShape(world, pos, side);
            if (voxelshape.isEmpty()) {
                return true;
            }
            VoxelShape voxelshape1 = iblockdata1.getFaceOcclusionShape(world, otherPos, side.getOpposite());
            boolean flag = Shapes.joinIsNotEmpty(voxelshape, voxelshape1, BooleanOp.ONLY_FIRST);
            if (object2bytelinkedopenhashmap.size() == 2048) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block_a, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    public static boolean canSupportRigidBlock(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos).isFaceSturdy(world, pos, Direction.UP, SupportType.RIGID);
    }

    public static boolean canSupportCenter(LevelReader world, BlockPos pos, Direction side) {
        BlockState iblockdata = world.getBlockState(pos);
        return side == Direction.DOWN && iblockdata.is(BlockTags.UNSTABLE_BOTTOM_CENTER) ? false : iblockdata.isFaceSturdy(world, pos, side, SupportType.CENTER);
    }

    public static boolean isFaceFull(VoxelShape shape, Direction side) {
        VoxelShape voxelshape1 = shape.getFaceShape(side);
        return Block.isShapeFullBlock(voxelshape1);
    }

    public static boolean isShapeFullBlock(VoxelShape shape) {
        return shape.moonrise$isFullBlock();
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
    }

    public static List<net.minecraft.world.item.ItemStack> getDrops(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity blockEntity) {
        LootParams.Builder lootparams_a = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withParameter(LootContextParams.TOOL, net.minecraft.world.item.ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, blockEntity);
        return state.getDrops(lootparams_a);
    }

    public static List<net.minecraft.world.item.ItemStack> getDrops(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack stack) {
        LootParams.Builder lootparams_a = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withParameter(LootContextParams.TOOL, stack).withOptionalParameter(LootContextParams.THIS_ENTITY, entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, blockEntity);
        return state.getDrops(lootparams_a);
    }

    public static void dropResources(BlockState state, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            Block.getDrops(state, (ServerLevel)world, pos, null).forEach(itemstack -> Block.popResource(world, pos, itemstack));
            state.spawnAfterBreak((ServerLevel)world, pos, net.minecraft.world.item.ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(BlockState state, LevelAccessor world, BlockPos pos, @Nullable BlockEntity blockEntity) {
        if (world instanceof ServerLevel) {
            Block.getDrops(state, (ServerLevel)world, pos, blockEntity).forEach(itemstack -> Block.popResource((Level)((ServerLevel)world), pos, itemstack));
            state.spawnAfterBreak((ServerLevel)world, pos, net.minecraft.world.item.ItemStack.EMPTY, true);
        }
    }

    public static boolean dropResources(BlockState state, LevelAccessor levelAccessor, BlockPos pos, @Nullable BlockEntity blockEntity, BlockPos source) {
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (net.minecraft.world.item.ItemStack drop : Block.getDrops(state, serverLevel, pos, blockEntity)) {
                items.add(CraftItemStack.asBukkitCopy(drop));
            }
            Block block = state.getBlock();
            BlockBreakBlockEvent event = new BlockBreakBlockEvent((org.bukkit.block.Block)CraftBlock.at(levelAccessor, pos), (org.bukkit.block.Block)CraftBlock.at(levelAccessor, source), items);
            event.setExpToDrop(block.getExpDrop(state, serverLevel, pos, net.minecraft.world.item.ItemStack.EMPTY, true));
            event.callEvent();
            for (ItemStack drop : event.getDrops()) {
                Block.popResource((Level)serverLevel, pos, CraftItemStack.asNMSCopy(drop));
            }
            state.spawnAfterBreak(serverLevel, pos, net.minecraft.world.item.ItemStack.EMPTY, false);
            block.popExperience(serverLevel, pos, event.getExpToDrop());
        }
        return true;
    }

    public static void dropResources(BlockState state, Level world, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool) {
        Block.dropResources(state, world, pos, blockEntity, entity, tool, true);
    }

    public static void dropResources(BlockState state, Level world, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool, boolean dropExperience) {
        if (world instanceof ServerLevel) {
            Block.getDrops(state, (ServerLevel)world, pos, blockEntity, entity, tool).forEach(itemstack1 -> Block.popResource(world, pos, itemstack1));
            state.spawnAfterBreak((ServerLevel)world, pos, tool, dropExperience);
        }
    }

    public static void popResource(Level world, BlockPos pos, net.minecraft.world.item.ItemStack stack) {
        double d0 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d1 = (double)pos.getX() + 0.5 + Mth.nextDouble(world.random, -0.25, 0.25);
        double d2 = (double)pos.getY() + 0.5 + Mth.nextDouble(world.random, -0.25, 0.25) - d0;
        double d3 = (double)pos.getZ() + 0.5 + Mth.nextDouble(world.random, -0.25, 0.25);
        Block.popResource(world, () -> new ItemEntity(world, d1, d2, d3, stack), stack);
    }

    public static void popResourceFromFace(Level world, BlockPos pos, Direction direction, net.minecraft.world.item.ItemStack stack) {
        int i = direction.getStepX();
        int j = direction.getStepY();
        int k = direction.getStepZ();
        double d0 = (double)EntityType.ITEM.getWidth() / 2.0;
        double d1 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d2 = (double)pos.getX() + 0.5 + (i == 0 ? Mth.nextDouble(world.random, -0.25, 0.25) : (double)i * (0.5 + d0));
        double d3 = (double)pos.getY() + 0.5 + (j == 0 ? Mth.nextDouble(world.random, -0.25, 0.25) : (double)j * (0.5 + d1)) - d1;
        double d4 = (double)pos.getZ() + 0.5 + (k == 0 ? Mth.nextDouble(world.random, -0.25, 0.25) : (double)k * (0.5 + d0));
        double d5 = i == 0 ? Mth.nextDouble(world.random, -0.1, 0.1) : (double)i * 0.1;
        double d6 = j == 0 ? Mth.nextDouble(world.random, 0.0, 0.1) : (double)j * 0.1 + 0.1;
        double d7 = k == 0 ? Mth.nextDouble(world.random, -0.1, 0.1) : (double)k * 0.1;
        Block.popResource(world, () -> new ItemEntity(world, d2, d3, d4, stack, d5, d6, d7), stack);
    }

    private static void popResource(Level world, Supplier<ItemEntity> itemEntitySupplier, net.minecraft.world.item.ItemStack stack) {
        if (!world.isClientSide && !stack.isEmpty() && world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ItemEntity entityitem = itemEntitySupplier.get();
            entityitem.setDefaultPickUpDelay();
            if (world.captureDrops != null) {
                world.captureDrops.add(entityitem);
            } else {
                world.addFreshEntity(entityitem);
            }
        }
    }

    public void popExperience(ServerLevel world, BlockPos pos, int size) {
        this.popExperience(world, pos, size, null);
    }

    public void popExperience(ServerLevel world, BlockPos pos, int size, Entity entity) {
        if (world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ExperienceOrb.award(world, Vec3.atCenterOf(pos), size, ExperienceOrb.SpawnReason.BLOCK_BREAK, entity);
        }
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public void wasExploded(Level world, BlockPos pos, Explosion explosion) {
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.defaultBlockState();
    }

    @DoNotUse
    @Deprecated
    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, net.minecraft.world.item.ItemStack tool) {
        this.playerDestroy(world, player, pos, state, blockEntity, tool, true, true);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, net.minecraft.world.item.ItemStack tool, boolean includeDrops, boolean dropExp) {
        player.awardStat(Stats.BLOCK_MINED.get(this));
        player.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        if (includeDrops) {
            Block.dropResources(state, world, pos, blockEntity, player, tool, dropExp);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, net.minecraft.world.item.ItemStack itemStack) {
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return !state.isSolid() && !state.liquid();
    }

    public MutableComponent getName() {
        return Component.translatable(this.getDescriptionId());
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId("block", BuiltInRegistries.BLOCK.getKey(this));
        }
        return this.descriptionId;
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 1.0f, entity.damageSources().fall());
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    public net.minecraft.world.item.ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new net.minecraft.world.item.ItemStack(this);
    }

    public float getFriction() {
        return this.friction;
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    public float getJumpFactor() {
        return this.jumpFactor;
    }

    protected void spawnDestroyParticles(Level world, Player player, BlockPos pos, BlockState state) {
        world.levelEvent(player, 2001, pos, Block.getId(state));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        this.spawnDestroyParticles(world, player, pos, state);
        if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
            PiglinAi.angerNearbyPiglins(player, false);
        }
        world.gameEvent(GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(player, state));
        return state;
    }

    public void handlePrecipitation(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.stateDefinition;
    }

    protected final void registerDefaultState(BlockState state) {
        this.defaultBlockState = state;
    }

    public final BlockState defaultBlockState() {
        return this.defaultBlockState;
    }

    public final BlockState withPropertiesOf(BlockState state) {
        BlockState iblockdata1 = this.defaultBlockState();
        for (Property<?> iblockstate : state.getBlock().getStateDefinition().getProperties()) {
            if (!iblockdata1.hasProperty(iblockstate)) continue;
            iblockdata1 = Block.copyProperty(state, iblockdata1, iblockstate);
        }
        return iblockdata1;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState source, BlockState target, Property<T> property) {
        return (BlockState)target.setValue(property, source.getValue(property));
    }

    @Override
    public Item asItem() {
        if (this.item == null) {
            this.item = Item.byBlock(this);
        }
        return this.item;
    }

    public boolean hasDynamicShape() {
        return this.dynamicShape;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.BLOCK.wrapAsHolder(this).getRegisteredName() + "}";
    }

    public void appendHoverText(net.minecraft.world.item.ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
    }

    @Override
    protected Block asBlock() {
        return this;
    }

    protected ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> stateToShape) {
        return (ImmutableMap)this.stateDefinition.getPossibleStates().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), stateToShape));
    }

    @Deprecated
    public Holder.Reference<Block> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    protected int tryDropExperience(ServerLevel worldserver, BlockPos blockposition, net.minecraft.world.item.ItemStack itemstack, IntProvider intprovider) {
        int i = EnchantmentHelper.processBlockExperience(worldserver, itemstack, intprovider.sample(worldserver.getRandom()));
        if (i > 0) {
            return i;
        }
        return 0;
    }

    public int getExpDrop(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        return 0;
    }

    public static float range(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final class BlockStatePairKey {
        private final BlockState first;
        private final BlockState second;
        private final Direction direction;

        public BlockStatePairKey(BlockState self, BlockState other, Direction facing) {
            this.first = self;
            this.second = other;
            this.direction = facing;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BlockStatePairKey)) {
                return false;
            }
            BlockStatePairKey block_a = (BlockStatePairKey)object;
            return this.first == block_a.first && this.second == block_a.second && this.direction == block_a.direction;
        }

        public int hashCode() {
            int i = this.first.hashCode();
            i = 31 * i + this.second.hashCode();
            i = 31 * i + this.direction.hashCode();
            return i;
        }
    }
}

