/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.slf4j.Logger;

public class CommandBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<CommandBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("automatic").forGetter(blockcommand -> blockcommand.automatic), CommandBlock.propertiesCodec()).apply((Applicative)instance, CommandBlock::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty CONDITIONAL = BlockStateProperties.CONDITIONAL;
    private final boolean automatic;

    public MapCodec<CommandBlock> codec() {
        return CODEC;
    }

    public CommandBlock(boolean auto, BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(FACING, Direction.NORTH)).setValue(CONDITIONAL, false));
        this.automatic = auto;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        CommandBlockEntity tileentitycommand = new CommandBlockEntity(pos, state);
        tileentitycommand.setAutomatic(this.automatic);
        return tileentitycommand;
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        BlockEntity tileentity;
        if (!world.isClientSide && (tileentity = world.getBlockEntity(pos)) instanceof CommandBlockEntity) {
            CommandBlockEntity tileentitycommand = (CommandBlockEntity)tileentity;
            boolean flag1 = world.hasNeighborSignal(pos);
            boolean flag2 = tileentitycommand.isPowered();
            org.bukkit.block.Block bukkitBlock = world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            int old = flag2 ? 15 : 0;
            int current = flag1 ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bukkitBlock, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            flag1 = eventRedstone.getNewCurrent() > 0;
            tileentitycommand.setPowered(flag1);
            if (!flag2 && !tileentitycommand.isAutomatic() && tileentitycommand.getMode() != CommandBlockEntity.Mode.SEQUENCE && flag1) {
                tileentitycommand.markConditionMet();
                world.scheduleTick(pos, this, 1);
            }
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CommandBlockEntity) {
            CommandBlockEntity tileentitycommand = (CommandBlockEntity)tileentity;
            BaseCommandBlock commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            boolean flag = !StringUtil.isNullOrEmpty(commandblocklistenerabstract.getCommand());
            CommandBlockEntity.Mode tileentitycommand_type = tileentitycommand.getMode();
            boolean flag1 = tileentitycommand.wasConditionMet();
            if (tileentitycommand_type == CommandBlockEntity.Mode.AUTO) {
                tileentitycommand.markConditionMet();
                if (flag1) {
                    this.execute(state, world, pos, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.isConditional()) {
                    commandblocklistenerabstract.setSuccessCount(0);
                }
                if (tileentitycommand.isPowered() || tileentitycommand.isAutomatic()) {
                    world.scheduleTick(pos, this, 1);
                }
            } else if (tileentitycommand_type == CommandBlockEntity.Mode.REDSTONE) {
                if (flag1) {
                    this.execute(state, world, pos, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.isConditional()) {
                    commandblocklistenerabstract.setSuccessCount(0);
                }
            }
            world.updateNeighbourForOutputSignal(pos, this);
        }
    }

    private void execute(BlockState state, Level world, BlockPos pos, BaseCommandBlock executor, boolean hasCommand) {
        if (hasCommand) {
            executor.performCommand(world);
        } else {
            executor.setSuccessCount(0);
        }
        CommandBlock.executeChain(world, pos, state.getValue(FACING));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CommandBlockEntity && (player.canUseGameMasterBlocks() || player.isCreative() && player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            player.openCommandBlock((CommandBlockEntity)tileentity);
            return InteractionResult.sidedSuccess(world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        return tileentity instanceof CommandBlockEntity ? ((CommandBlockEntity)tileentity).getCommandBlock().getSuccessCount() : 0;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof CommandBlockEntity) {
            CommandBlockEntity tileentitycommand = (CommandBlockEntity)tileentity;
            BaseCommandBlock commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            if (!world.isClientSide) {
                if (!itemStack.has(DataComponents.BLOCK_ENTITY_DATA)) {
                    commandblocklistenerabstract.setTrackOutput(world.getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK));
                    tileentitycommand.setAutomatic(this.automatic);
                }
                boolean flag = world.hasNeighborSignal(pos);
                tileentitycommand.setPowered(flag);
            }
        }
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, rotation.rotate(state.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(FACING, CONDITIONAL);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, ctx.getNearestLookingDirection().getOpposite());
    }

    private static void executeChain(Level world, BlockPos pos, Direction facing) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        GameRules gamerules = world.getGameRules();
        int i = gamerules.getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH);
        while (i-- > 0) {
            CommandBlockEntity tileentitycommand;
            BlockEntity tileentity;
            blockposition_mutableblockposition.move(facing);
            BlockState iblockdata = world.getBlockState(blockposition_mutableblockposition);
            Block block = iblockdata.getBlock();
            if (!iblockdata.is(Blocks.CHAIN_COMMAND_BLOCK) || !((tileentity = world.getBlockEntity(blockposition_mutableblockposition)) instanceof CommandBlockEntity) || (tileentitycommand = (CommandBlockEntity)tileentity).getMode() != CommandBlockEntity.Mode.SEQUENCE) break;
            if (tileentitycommand.isPowered() || tileentitycommand.isAutomatic()) {
                BaseCommandBlock commandblocklistenerabstract = tileentitycommand.getCommandBlock();
                if (tileentitycommand.markConditionMet()) {
                    if (!commandblocklistenerabstract.performCommand(world)) break;
                    world.updateNeighbourForOutputSignal(blockposition_mutableblockposition, block);
                } else if (tileentitycommand.isConditional()) {
                    commandblocklistenerabstract.setSuccessCount(0);
                }
            }
            facing = iblockdata.getValue(FACING);
        }
        if (i <= 0) {
            int j = Math.max(gamerules.getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH), 0);
            LOGGER.warn("Command Block chain tried to execute more than {} steps!", (Object)j);
        }
    }
}

