/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class InfestedBlock
extends Block {
    public static final MapCodec<InfestedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("host").forGetter(InfestedBlock::getHostBlock), InfestedBlock.propertiesCodec()).apply((Applicative)instance, InfestedBlock::new));
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public MapCodec<? extends InfestedBlock> codec() {
        return CODEC;
    }

    public InfestedBlock(Block regularBlock, BlockBehaviour.Properties settings) {
        super(settings.destroyTime(regularBlock.defaultDestroyTime() / 2.0f).explosionResistance(0.75f));
        this.hostBlock = regularBlock;
        BLOCK_BY_HOST_BLOCK.put(regularBlock, this);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(BlockState block) {
        return BLOCK_BY_HOST_BLOCK.containsKey(block.getBlock());
    }

    private void spawnInfestation(ServerLevel world, BlockPos pos) {
        Silverfish entitysilverfish = EntityType.SILVERFISH.create(world);
        if (entitysilverfish != null) {
            entitysilverfish.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
            entitysilverfish.spawnAnim();
        }
    }

    @Override
    protected void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        super.spawnAfterBreak(state, world, pos, tool, dropExperience);
        if (world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !EnchantmentHelper.hasTag(tool, EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            this.spawnInfestation(world, pos);
        }
    }

    public static BlockState infestedStateByHost(BlockState regularState) {
        return InfestedBlock.getNewStateWithProperties(HOST_TO_INFESTED_STATES, regularState, () -> BLOCK_BY_HOST_BLOCK.get(regularState.getBlock()).defaultBlockState());
    }

    public BlockState hostStateByInfested(BlockState infestedState) {
        return InfestedBlock.getNewStateWithProperties(INFESTED_TO_HOST_STATES, infestedState, () -> this.getHostBlock().defaultBlockState());
    }

    private static BlockState getNewStateWithProperties(Map<BlockState, BlockState> stateMap, BlockState fromState, Supplier<BlockState> toStateSupplier) {
        return stateMap.computeIfAbsent(fromState, iblockdata1 -> {
            BlockState iblockdata2 = (BlockState)toStateSupplier.get();
            for (Property<?> iblockstate : iblockdata1.getProperties()) {
                iblockdata2 = iblockdata2.hasProperty(iblockstate) ? (BlockState)iblockdata2.setValue(iblockstate, iblockdata1.getValue(iblockstate)) : iblockdata2;
            }
            return iblockdata2;
        });
    }
}

