/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class PressurePlateBlock
extends BasePressurePlateBlock {
    public static final MapCodec<PressurePlateBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(blockpressureplatebinary -> blockpressureplatebinary.type), PressurePlateBlock.propertiesCodec()).apply((Applicative)instance, PressurePlateBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<PressurePlateBlock> codec() {
        return CODEC;
    }

    protected PressurePlateBlock(BlockSetType type, BlockBehaviour.Properties settings) {
        super(settings, type);
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(POWERED, false));
    }

    @Override
    protected int getSignalForState(BlockState state) {
        return state.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected BlockState setSignalForState(BlockState state, int rsOut) {
        return (BlockState)state.setValue(POWERED, rsOut > 0);
    }

    @Override
    protected int getSignalStrength(Level world, BlockPos pos) {
        Class<net.minecraft.world.entity.Entity> oclass = switch (this.type.pressurePlateSensitivity()) {
            case BlockSetType.PressurePlateSensitivity.EVERYTHING -> net.minecraft.world.entity.Entity.class;
            case BlockSetType.PressurePlateSensitivity.MOBS -> LivingEntity.class;
            default -> throw new MatchException(null, null);
        };
        Class<net.minecraft.world.entity.Entity> oclass1 = oclass;
        for (net.minecraft.world.entity.Entity entity : PressurePlateBlock.getEntities(world, BasePressurePlateBlock.TOUCH_AABB.move(pos), oclass)) {
            if (this.getSignalForState(world.getBlockState(pos)) == 0) {
                PlayerInteractEvent cancellable;
                CraftWorld bworld = world.getWorld();
                PluginManager manager = world.getCraftServer().getPluginManager();
                if (entity instanceof Player) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, pos, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), bworld.getBlockAt(pos.getX(), pos.getY(), pos.getZ()));
                    manager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
            }
            return 15;
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(POWERED);
    }
}

