/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.event.block.BellRevealRaiderEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Raider;

public class BellBlockEntity
extends BlockEntity {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 60;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_RAIDERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<net.minecraft.world.entity.LivingEntity> nearbyEntities;
    public boolean resonating;
    public int resonationTicks;

    public BellBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.BELL, pos, state);
    }

    @Override
    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.from3DDataValue(data);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.triggerEvent(type, data);
    }

    private static void tick(Level world, BlockPos pos, BlockState state, BellBlockEntity blockEntity, ResonationEndAction bellEffect) {
        if (blockEntity.shaking) {
            ++blockEntity.ticks;
        }
        if (blockEntity.ticks >= 50) {
            blockEntity.shaking = false;
            if (!blockEntity.resonating) {
                blockEntity.nearbyEntities.clear();
            }
            blockEntity.ticks = 0;
        }
        if (blockEntity.ticks >= 5 && blockEntity.resonationTicks == 0 && BellBlockEntity.areRaidersNearby(pos, blockEntity.nearbyEntities)) {
            blockEntity.resonating = true;
            world.playSound((Player)null, pos, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (blockEntity.resonating) {
            if (blockEntity.resonationTicks < 40) {
                ++blockEntity.resonationTicks;
            } else {
                bellEffect.run(world, pos, blockEntity.nearbyEntities);
                blockEntity.nearbyEntities.clear();
                blockEntity.resonating = false;
            }
        }
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, BellBlockEntity blockEntity) {
        BellBlockEntity.tick(world, pos, state, blockEntity, BellBlockEntity::showBellParticles);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, BellBlockEntity blockEntity) {
        BellBlockEntity.tick(world, pos, state, blockEntity, BellBlockEntity::makeRaidersGlow);
    }

    public void onHit(Direction direction) {
        BlockPos blockposition = this.getBlockPos();
        this.clickDirection = direction;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.level.blockEvent(blockposition, this.getBlockState().getBlock(), 1, direction.get3DDataValue());
    }

    private void updateEntities() {
        BlockPos blockposition = this.getBlockPos();
        if (this.level.getGameTime() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.level.getGameTime();
            AABB axisalignedbb = new AABB(blockposition).inflate(48.0);
            this.nearbyEntities = this.level.getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, axisalignedbb);
        }
        if (!this.level.isClientSide) {
            for (net.minecraft.world.entity.LivingEntity entityliving : this.nearbyEntities) {
                if (!entityliving.isAlive() || entityliving.isRemoved() || !blockposition.closerToCenterThan(entityliving.position(), 32.0)) continue;
                entityliving.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, this.level.getGameTime());
            }
        }
        this.nearbyEntities.removeIf(e -> !e.isAlive());
    }

    private static boolean areRaidersNearby(BlockPos pos, List<net.minecraft.world.entity.LivingEntity> hearingEntities) {
        net.minecraft.world.entity.LivingEntity entityliving;
        Iterator<net.minecraft.world.entity.LivingEntity> iterator = hearingEntities.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityliving = iterator.next()).isAlive() || entityliving.isRemoved() || !pos.closerToCenterThan(entityliving.position(), 32.0) || !entityliving.getType().is(EntityTypeTags.RAIDERS));
        return true;
    }

    private static void makeRaidersGlow(Level world, BlockPos pos, List<net.minecraft.world.entity.LivingEntity> hearingEntities) {
        List entities = hearingEntities.stream().filter(entityliving -> BellBlockEntity.isRaiderWithinRange(pos, entityliving)).map(entity -> (LivingEntity)entity.getBukkitEntity()).collect(Collectors.toCollection(ArrayList::new));
        CraftEventFactory.handleBellResonateEvent(world, pos, entities).forEach(entity -> BellBlockEntity.glow(entity, pos));
    }

    private static void showBellParticles(Level world, BlockPos pos, List<net.minecraft.world.entity.LivingEntity> hearingEntities) {
        MutableInt mutableint = new MutableInt(16700985);
        int i = (int)hearingEntities.stream().filter(entityliving -> pos.closerToCenterThan(entityliving.position(), 48.0)).count();
        hearingEntities.stream().filter(entityliving -> BellBlockEntity.isRaiderWithinRange(pos, entityliving)).forEach(entityliving -> {
            float f = 1.0f;
            double d0 = Math.sqrt((entityliving.getX() - (double)pos.getX()) * (entityliving.getX() - (double)pos.getX()) + (entityliving.getZ() - (double)pos.getZ()) * (entityliving.getZ() - (double)pos.getZ()));
            double d1 = (double)((float)pos.getX() + 0.5f) + 1.0 / d0 * (entityliving.getX() - (double)pos.getX());
            double d2 = (double)((float)pos.getZ() + 0.5f) + 1.0 / d0 * (entityliving.getZ() - (double)pos.getZ());
            int j = Mth.clamp((i - 21) / -2, 3, 15);
            for (int k = 0; k < j; ++k) {
                int l = mutableint.addAndGet(5);
                world.addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, l), d1, (float)pos.getY() + 0.5f, d2, 0.0, 0.0, 0.0);
            }
        });
    }

    private static boolean isRaiderWithinRange(BlockPos pos, net.minecraft.world.entity.LivingEntity entity) {
        return entity.isAlive() && !entity.isRemoved() && pos.closerToCenterThan(entity.position(), 48.0) && entity.getType().is(EntityTypeTags.RAIDERS);
    }

    private static void glow(net.minecraft.world.entity.LivingEntity entity) {
        BellBlockEntity.glow(entity, null);
    }

    private static void glow(net.minecraft.world.entity.LivingEntity entity, @Nullable BlockPos pos) {
        if (pos != null && !new BellRevealRaiderEvent((Block)CraftBlock.at(entity.level(), pos), (Raider)entity.getBukkitEntity()).callEvent()) {
            return;
        }
        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60));
    }

    @FunctionalInterface
    private static interface ResonationEndAction {
        public void run(Level var1, BlockPos var2, List<net.minecraft.world.entity.LivingEntity> var3);
    }
}

