/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.event.inventory.PaperInventoryMoveItemEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;

public class HopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private static final int[][] CACHED_SLOTS = new int[54][];
    private NonNullList<ItemStack> items;
    public int cooldownTime = -1;
    private long tickedGameTime;
    private Direction facing;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    private static final int HOPPER_EMPTY = 0;
    private static final int HOPPER_HAS_ITEMS = 1;
    private static final int HOPPER_IS_FULL = 2;
    private static boolean skipPullModeEventFire;
    private static boolean skipPushModeEventFire;
    public static boolean skipHopperEvents;
    private static final BiPredicate<ItemStack, Integer> STACK_SIZE_TEST;
    private static final BiPredicate<ItemStack, Integer> IS_EMPTY_TEST;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public HopperBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.HOPPER, pos, state);
        this.items = NonNullList.withSize(5, ItemStack.EMPTY);
        this.facing = state.getValue(HopperBlock.FACING);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbt)) {
            ContainerHelper.loadAllItems(nbt, this.items, registryLookup);
        }
        this.cooldownTime = nbt.getInt("TransferCooldown");
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems(nbt, this.items, registryLookup);
        }
        nbt.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), slot, amount);
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.unpackLootTable(null);
        this.getItems().set(slot, stack);
        stack.limitSize(this.getMaxStackSize(stack));
    }

    @Override
    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.facing = state.getValue(HopperBlock.FACING);
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.hopper");
    }

    public static void pushItemsTick(Level world, BlockPos pos, BlockState state, HopperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = world.getGameTime();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            boolean result = HopperBlockEntity.tryMoveItems(world, pos, state, blockEntity, () -> HopperBlockEntity.suckInItems(world, blockEntity));
            if (!result && blockEntity.level.spigotConfig.hopperCheck > 1) {
                blockEntity.setCooldown(blockEntity.level.spigotConfig.hopperCheck);
            }
        }
    }

    private static int getFullState(HopperBlockEntity tileEntity) {
        tileEntity.unpackLootTable(null);
        NonNullList<ItemStack> hopperItems = tileEntity.getItems();
        boolean empty = true;
        boolean full = true;
        int len = hopperItems.size();
        for (int i = 0; i < len; ++i) {
            ItemStack stack = (ItemStack)hopperItems.get(i);
            if (stack.isEmpty()) {
                full = false;
                continue;
            }
            if (!full) {
                return 1;
            }
            empty = false;
            if (stack.getCount() == stack.getMaxStackSize()) continue;
            return 1;
        }
        return empty ? 0 : (full ? 2 : 1);
    }

    private static boolean tryMoveItems(Level world, BlockPos pos, BlockState state, HopperBlockEntity blockEntity, BooleanSupplier booleansupplier) {
        if (world.isClientSide) {
            return false;
        }
        if (!blockEntity.isOnCooldown() && state.getValue(HopperBlock.ENABLED).booleanValue()) {
            boolean flag = false;
            int fullState = HopperBlockEntity.getFullState(blockEntity);
            if (fullState != 0) {
                flag = HopperBlockEntity.ejectItems(world, pos, blockEntity);
            }
            if (fullState != 2 || flag) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.setCooldown(world.spigotConfig.hopperTransfer);
                HopperBlockEntity.setChanged(world, pos, state);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (ItemStack)iterator.next()).isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize());
        return false;
    }

    private static boolean hopperPush(Level level, Container destination, Direction direction, HopperBlockEntity hopper) {
        skipPushModeEventFire = skipHopperEvents;
        boolean foundItem = false;
        for (int i = 0; i < hopper.getContainerSize(); ++i) {
            ItemStack origItemStack;
            ItemStack item = hopper.getItem(i);
            if (item.isEmpty()) continue;
            foundItem = true;
            ItemStack movedItem = origItemStack = item;
            int originalItemCount = origItemStack.getCount();
            int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
            origItemStack.setCount(movedItemCount);
            if (!skipPushModeEventFire && (movedItem = HopperBlockEntity.callPushMoveEvent(destination, movedItem, hopper)) == null) {
                origItemStack.setCount(originalItemCount);
                return false;
            }
            ItemStack remainingItem = HopperBlockEntity.addItem(hopper, destination, movedItem, direction);
            int remainingItemCount = remainingItem.getCount();
            if (remainingItemCount != movedItemCount) {
                origItemStack = origItemStack.copy(true);
                origItemStack.setCount(originalItemCount);
                if (!origItemStack.isEmpty()) {
                    origItemStack.setCount(originalItemCount - movedItemCount + remainingItemCount);
                }
                hopper.setItem(i, origItemStack);
                destination.setChanged();
                return true;
            }
            origItemStack.setCount(originalItemCount);
        }
        if (foundItem && level.paperConfig().hopper.cooldownWhenFull) {
            hopper.setCooldown(level.spigotConfig.hopperTransfer);
        }
        return false;
    }

    private static boolean hopperPull(Level level, Hopper hopper, Container container, ItemStack origItemStack, int i) {
        ItemStack movedItem = origItemStack;
        int originalItemCount = origItemStack.getCount();
        int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
        container.setChanged();
        movedItem.setCount(movedItemCount);
        if (!skipPullModeEventFire && (movedItem = HopperBlockEntity.callPullMoveEvent(hopper, container, movedItem)) == null) {
            origItemStack.setCount(originalItemCount);
            return true;
        }
        ItemStack remainingItem = HopperBlockEntity.addItem(container, hopper, movedItem, null);
        int remainingItemCount = remainingItem.getCount();
        if (remainingItemCount != movedItemCount) {
            origItemStack = origItemStack.copy(true);
            origItemStack.setCount(originalItemCount);
            if (!origItemStack.isEmpty()) {
                origItemStack.setCount(originalItemCount - movedItemCount + remainingItemCount);
            }
            BlockEntity.ignoreTileUpdates = true;
            container.setItem(i, origItemStack);
            BlockEntity.ignoreTileUpdates = false;
            container.setChanged();
            return true;
        }
        origItemStack.setCount(originalItemCount);
        if (level.paperConfig().hopper.cooldownWhenFull) {
            HopperBlockEntity.cooldownHopper(hopper);
        }
        return false;
    }

    @Nullable
    private static ItemStack callPushMoveEvent(Container iinventory, ItemStack itemstack, HopperBlockEntity hopper) {
        Inventory destinationInventory = HopperBlockEntity.getInventory(iinventory);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(hopper.getOwner(false).getInventory(), CraftItemStack.asCraftMirror(itemstack), destinationInventory, true);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPushModeEventFire = true;
        }
        if (!result) {
            HopperBlockEntity.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    @Nullable
    private static ItemStack callPullMoveEvent(Hopper hopper, Container container, ItemStack itemstack) {
        Inventory sourceInventory = HopperBlockEntity.getInventory(container);
        Inventory destination = HopperBlockEntity.getInventory(hopper);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(sourceInventory, CraftItemStack.asCraftMirror(itemstack), destination, false);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPullModeEventFire = true;
        }
        if (!result) {
            HopperBlockEntity.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static Inventory getInventory(Container container) {
        CraftInventory sourceInventory;
        if (container instanceof CompoundContainer) {
            CompoundContainer compoundContainer = (CompoundContainer)container;
            sourceInventory = new CraftInventoryDoubleChest(compoundContainer);
        } else if (container instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)((Object)container);
            sourceInventory = blockEntity.getOwner(false).getInventory();
        } else {
            sourceInventory = container.getOwner() != null ? container.getOwner().getInventory() : new CraftInventory(container);
        }
        return sourceInventory;
    }

    private static void cooldownHopper(Hopper hopper) {
        HopperBlockEntity blockEntity;
        if (hopper instanceof HopperBlockEntity && (blockEntity = (HopperBlockEntity)hopper).getLevel() != null) {
            blockEntity.setCooldown(blockEntity.getLevel().spigotConfig.hopperTransfer);
        }
    }

    private static boolean allMatch(Container iinventory, Direction enumdirection, BiPredicate<ItemStack, Integer> test) {
        if (iinventory instanceof WorldlyContainer) {
            for (int i : ((WorldlyContainer)iinventory).getSlotsForFace(enumdirection)) {
                if (test.test(iinventory.getItem(i), i)) continue;
                return false;
            }
        } else {
            int size = iinventory.getContainerSize();
            for (int i = 0; i < size; ++i) {
                if (test.test(iinventory.getItem(i), i)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean anyMatch(Container iinventory, Direction enumdirection, BiPredicate<ItemStack, Integer> test) {
        if (iinventory instanceof WorldlyContainer) {
            for (int i : ((WorldlyContainer)iinventory).getSlotsForFace(enumdirection)) {
                if (!test.test(iinventory.getItem(i), i)) continue;
                return true;
            }
        } else {
            int size = iinventory.getContainerSize();
            for (int i = 0; i < size; ++i) {
                if (!test.test(iinventory.getItem(i), i)) continue;
                return true;
            }
        }
        return true;
    }

    private static boolean ejectItems(Level world, BlockPos pos, HopperBlockEntity blockEntity) {
        Container iinventory = HopperBlockEntity.getAttachedContainer(world, pos, blockEntity);
        if (iinventory == null) {
            return false;
        }
        Direction enumdirection = blockEntity.facing.getOpposite();
        if (HopperBlockEntity.isFullContainer(iinventory, enumdirection)) {
            return false;
        }
        return HopperBlockEntity.hopperPush(world, iinventory, enumdirection, blockEntity);
    }

    private static int[] getSlots(Container inventory, Direction side) {
        if (inventory instanceof WorldlyContainer) {
            WorldlyContainer iworldinventory = (WorldlyContainer)inventory;
            return iworldinventory.getSlotsForFace(side);
        }
        int i = inventory.getContainerSize();
        if (i < CACHED_SLOTS.length) {
            int[] aint = CACHED_SLOTS[i];
            if (aint != null) {
                return aint;
            }
            int[] aint1 = HopperBlockEntity.createFlatSlots(i);
            HopperBlockEntity.CACHED_SLOTS[i] = aint1;
            return aint1;
        }
        return HopperBlockEntity.createFlatSlots(i);
    }

    private static int[] createFlatSlots(int size) {
        int[] aint = new int[size];
        int j = 0;
        while (j < aint.length) {
            aint[j] = j++;
        }
        return aint;
    }

    private static boolean isFullContainer(Container inventory, Direction direction) {
        int[] aint;
        int[] aint1 = aint = HopperBlockEntity.getSlots(inventory, direction);
        int i = aint.length;
        for (int j = 0; j < i; ++j) {
            int k = aint1[j];
            ItemStack itemstack = inventory.getItem(k);
            if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean suckInItems(Level world, Hopper hopper) {
        boolean flag;
        BlockState iblockdata;
        BlockPos blockposition = BlockPos.containing(hopper.getLevelX(), hopper.getLevelY() + 1.0, hopper.getLevelZ());
        Container iinventory = HopperBlockEntity.getSourceContainer(world, hopper, blockposition, iblockdata = world.getBlockState(blockposition));
        if (iinventory != null) {
            Direction enumdirection = Direction.DOWN;
            skipPullModeEventFire = skipHopperEvents;
            for (int k : HopperBlockEntity.getSlots(iinventory, enumdirection)) {
                if (!HopperBlockEntity.tryTakeInItemFromSlot(hopper, iinventory, k, enumdirection, world)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = hopper.isGridAligned() && iblockdata.isCollisionShapeFullBlock(world, blockposition) && !iblockdata.is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
        if (!flag) {
            for (ItemEntity entityitem : HopperBlockEntity.getItemsAtAndAbove(world, hopper)) {
                if (!HopperBlockEntity.addItem(hopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(Hopper ihopper, Container iinventory, int i, Direction enumdirection, Level world) {
        ItemStack itemstack = iinventory.getItem(i);
        if (!itemstack.isEmpty() && HopperBlockEntity.canTakeItemFromContainer(ihopper, iinventory, itemstack, i, enumdirection)) {
            return HopperBlockEntity.hopperPull(world, ihopper, iinventory, itemstack, i);
        }
        return false;
    }

    public static boolean addItem(Container inventory, ItemEntity itemEntity) {
        ItemStack itemstack;
        ItemStack itemstack1;
        boolean flag = false;
        if (InventoryPickupItemEvent.getHandlerList().getRegisteredListeners().length > 0) {
            InventoryPickupItemEvent event = new InventoryPickupItemEvent(HopperBlockEntity.getInventory(inventory), (Item)itemEntity.getBukkitEntity());
            itemEntity.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
        }
        if ((itemstack1 = HopperBlockEntity.addItem(null, inventory, itemstack = itemEntity.getItem().copy(), null)).isEmpty()) {
            flag = true;
            itemEntity.setItem(ItemStack.EMPTY);
            itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            itemEntity.setItem(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable Container from, Container to, ItemStack stack, @Nullable Direction side) {
        if (to instanceof WorldlyContainer) {
            WorldlyContainer iworldinventory = (WorldlyContainer)to;
            if (side != null) {
                int[] aint = iworldinventory.getSlotsForFace(side);
                for (int i = 0; i < aint.length && !stack.isEmpty(); ++i) {
                    stack = HopperBlockEntity.tryMoveInItem(from, to, stack, aint[i], side);
                }
                return stack;
            }
        }
        int j = to.getContainerSize();
        for (int i = 0; i < j && !stack.isEmpty(); ++i) {
            stack = HopperBlockEntity.tryMoveInItem(from, to, stack, i, side);
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container inventory, ItemStack stack, int slot, @Nullable Direction side) {
        WorldlyContainer iworldinventory;
        if (!inventory.canPlaceItem(slot, stack)) {
            return false;
        }
        if (inventory instanceof WorldlyContainer && !(iworldinventory = (WorldlyContainer)inventory).canPlaceItemThroughFace(slot, stack, side)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean canTakeItemFromContainer(Container hopperInventory, Container fromInventory, ItemStack stack, int slot, Direction facing) {
        WorldlyContainer iworldinventory;
        if (!fromInventory.canTakeItem(hopperInventory, slot, stack)) {
            return false;
        }
        if (fromInventory instanceof WorldlyContainer && !(iworldinventory = (WorldlyContainer)fromInventory).canTakeItemThroughFace(slot, stack, facing)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static ItemStack tryMoveInItem(@Nullable Container from, Container to, ItemStack stack, int slot, @Nullable Direction side) {
        ItemStack itemstack1 = to.getItem(slot);
        if (HopperBlockEntity.canPlaceItemInContainer(to, stack, slot, side)) {
            boolean flag = false;
            boolean flag1 = to.isEmpty();
            if (itemstack1.isEmpty()) {
                ItemStack leftover = ItemStack.EMPTY;
                if (!stack.isEmpty() && stack.getCount() > to.getMaxStackSize()) {
                    leftover = stack;
                    stack = stack.split(to.getMaxStackSize());
                }
                BlockEntity.ignoreTileUpdates = true;
                to.setItem(slot, stack);
                BlockEntity.ignoreTileUpdates = false;
                stack = leftover;
                flag = true;
            } else if (HopperBlockEntity.canMergeItems(itemstack1, stack)) {
                int j = Math.min(stack.getMaxStackSize(), to.getMaxStackSize()) - itemstack1.getCount();
                int k = Math.min(stack.getCount(), j);
                stack.shrink(k);
                itemstack1.grow(k);
                boolean bl = flag = k > 0;
            }
            if (flag) {
                HopperBlockEntity tileentityhopper;
                if (flag1 && to instanceof HopperBlockEntity && !(tileentityhopper = (HopperBlockEntity)to).isOnCustomCooldown()) {
                    int b0 = 0;
                    if (from instanceof HopperBlockEntity) {
                        HopperBlockEntity tileentityhopper1 = (HopperBlockEntity)from;
                        if (tileentityhopper.tickedGameTime >= tileentityhopper1.tickedGameTime) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.setCooldown(tileentityhopper.level.spigotConfig.hopperTransfer - b0);
                }
                to.setChanged();
            }
        }
        return stack;
    }

    @Nullable
    private static Container runHopperInventorySearchEvent(Container inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static Container getAttachedContainer(Level world, BlockPos pos, HopperBlockEntity blockEntity) {
        BlockPos searchPosition = pos.relative(blockEntity.facing);
        Container inventory = HopperBlockEntity.getContainerAt(world, searchPosition);
        CraftBlock hopper = CraftBlock.at(world, pos);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return HopperBlockEntity.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static Container getSourceContainer(Level world, Hopper hopper, BlockPos pos, BlockState state) {
        Container inventory = HopperBlockEntity.getContainerAt(world, pos, state, hopper.getLevelX(), hopper.getLevelY() + 1.0, hopper.getLevelZ());
        BlockPos blockPosition = BlockPos.containing(hopper.getLevelX(), hopper.getLevelY(), hopper.getLevelZ());
        CraftBlock hopper1 = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.above());
        return HopperBlockEntity.runHopperInventorySearchEvent(inventory, hopper1, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level world, Hopper hopper) {
        AABB axisalignedbb = hopper.getSuckAabb().move(hopper.getLevelX() - 0.5, hopper.getLevelY() - 0.5, hopper.getLevelZ() - 0.5);
        return world.getEntitiesOfClass(ItemEntity.class, axisalignedbb, EntitySelector.ENTITY_STILL_ALIVE);
    }

    @Nullable
    public static Container getContainerAt(Level world, BlockPos pos) {
        return HopperBlockEntity.getContainerAt(world, pos, world.getBlockState(pos), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, true);
    }

    @Nullable
    private static Container getContainerAt(Level world, BlockPos pos, BlockState state, double x, double y, double z) {
        return HopperBlockEntity.getContainerAt(world, pos, state, x, y, z, false);
    }

    @Nullable
    private static Container getContainerAt(Level world, BlockPos pos, BlockState state, double x, double y, double z, boolean optimizeEntities) {
        Container iinventory = HopperBlockEntity.getBlockContainer(world, pos, state);
        if (!(iinventory != null || optimizeEntities && world.paperConfig().hopper.ignoreOccludingBlocks && state.getBukkitMaterial().isOccluding())) {
            iinventory = HopperBlockEntity.getEntityContainer(world, x, y, z);
        }
        return iinventory;
    }

    @Nullable
    private static Container getBlockContainer(Level world, BlockPos pos, BlockState state) {
        BlockEntity tileentity;
        if (!world.spigotConfig.hopperCanLoadChunks && !world.hasChunkAt(pos)) {
            return null;
        }
        Block block = state.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            return ((WorldlyContainerHolder)((Object)block)).getContainer(state, world, pos);
        }
        if (state.hasBlockEntity() && (tileentity = world.getBlockEntity(pos)) instanceof Container) {
            Container iinventory = (Container)((Object)tileentity);
            if (iinventory instanceof ChestBlockEntity && block instanceof ChestBlock) {
                iinventory = ChestBlock.getContainer((ChestBlock)block, state, world, pos, true);
            }
            return iinventory;
        }
        return null;
    }

    @Nullable
    private static Container getEntityContainer(Level world, double x, double y, double z) {
        List<Entity> list = world.getEntitiesOfClass(Container.class, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR);
        return !list.isEmpty() ? (Container)((Object)list.get(world.random.nextInt(list.size()))) : null;
    }

    private static boolean canMergeItems(ItemStack first, ItemStack second) {
        return first.getCount() < first.getMaxStackSize() && ItemStack.isSameItemSameComponents(first, second);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public boolean isGridAligned() {
        return true;
    }

    public void setCooldown(int transferCooldown) {
        this.cooldownTime = transferCooldown;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> inventory) {
        this.items = inventory;
    }

    public static void entityInside(Level world, BlockPos pos, BlockState state, Entity entity, HopperBlockEntity blockEntity) {
        ItemEntity entityitem;
        if (entity instanceof ItemEntity && !(entityitem = (ItemEntity)entity).getItem().isEmpty() && entity.getBoundingBox().move(-pos.getX(), -pos.getY(), -pos.getZ()).intersects(blockEntity.getSuckAabb())) {
            HopperBlockEntity.tryMoveItems(world, pos, state, blockEntity, () -> HopperBlockEntity.addItem(blockEntity, entityitem));
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int syncId, net.minecraft.world.entity.player.Inventory playerInventory) {
        return new HopperMenu(syncId, playerInventory, this);
    }

    static {
        STACK_SIZE_TEST = (itemstack, i) -> itemstack.getCount() >= itemstack.getMaxStackSize();
        IS_EMPTY_TEST = (itemstack, i) -> itemstack.isEmpty();
    }
}

