/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.list.IBlockDataList;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.FluidState;

public class LevelChunkSection
implements BlockCountingChunkSection {
    public static final int SECTION_WIDTH = 16;
    public static final int SECTION_HEIGHT = 16;
    public static final int SECTION_SIZE = 4096;
    public static final int BIOME_CONTAINER_BITS = 2;
    short nonEmptyBlockCount;
    private short tickingBlockCount;
    private short tickingFluidCount;
    public final PalettedContainer<BlockState> states;
    private PalettedContainer<Holder<Biome>> biomes;
    private static final IntArrayList FULL_LIST = new IntArrayList(4096);
    private int specialCollidingBlocks;
    private final IBlockDataList tickingBlocks = new IBlockDataList();

    @Override
    public final int moonrise$getSpecialCollidingBlocks() {
        return this.specialCollidingBlocks;
    }

    @Override
    public final IBlockDataList moonrise$getTickingBlockList() {
        return this.tickingBlocks;
    }

    public LevelChunkSection(PalettedContainer<BlockState> datapaletteblock, PalettedContainer<Holder<Biome>> palettedcontainerro) {
        this.states = datapaletteblock;
        this.biomes = palettedcontainerro;
        this.recalcBlockCounts();
    }

    @Deprecated
    @DoNotUse
    public LevelChunkSection(Registry<Biome> biomeRegistry) {
        this(biomeRegistry, null, null, 0);
    }

    public LevelChunkSection(Registry<Biome> biomeRegistry, Level level, ChunkPos chunkPos, int chunkSectionY) {
        this.states = new PalettedContainer<BlockState>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES, level == null || level.chunkPacketBlockController == null ? null : level.chunkPacketBlockController.getPresetBlockStates(level, chunkPos, chunkSectionY));
        this.biomes = new PalettedContainer<Holder.Reference<Biome>>(biomeRegistry.asHolderIdMap(), biomeRegistry.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES, null);
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.states.get(x, y, z);
    }

    public FluidState getFluidState(int x, int y, int z) {
        return this.states.get(x, y, z).getFluidState();
    }

    public void acquire() {
        this.states.acquire();
    }

    public void release() {
        this.states.release();
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state) {
        return this.setBlockState(x, y, z, state, true);
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state, boolean lock) {
        BlockState iblockdata1 = lock ? this.states.getAndSet(x, y, z, state) : this.states.getAndSetUnchecked(x, y, z, state);
        FluidState fluid = iblockdata1.getFluidState();
        FluidState fluid1 = state.getFluidState();
        if (!iblockdata1.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount - 1);
            if (iblockdata1.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount - 1);
            }
        }
        if (!fluid.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount - 1);
        }
        if (!state.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + 1);
            if (state.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount + 1);
            }
        }
        if (!fluid1.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount + 1);
        }
        if (CollisionUtil.isSpecialCollidingBlock(iblockdata1)) {
            --this.specialCollidingBlocks;
        }
        if (CollisionUtil.isSpecialCollidingBlock(state)) {
            ++this.specialCollidingBlocks;
        }
        if (iblockdata1.isRandomlyTicking()) {
            this.tickingBlocks.remove(x, y, z);
        }
        if (state.isRandomlyTicking()) {
            this.tickingBlocks.add(x, y, z, state);
        }
        return iblockdata1;
    }

    public boolean hasOnlyAir() {
        return this.nonEmptyBlockCount == 0;
    }

    public boolean isRandomlyTicking() {
        return this.isRandomlyTickingBlocks() || this.isRandomlyTickingFluids();
    }

    public boolean isRandomlyTickingBlocks() {
        return this.tickingBlockCount > 0;
    }

    public boolean isRandomlyTickingFluids() {
        return this.tickingFluidCount > 0;
    }

    public void recalcBlockCounts() {
        this.nonEmptyBlockCount = 0;
        this.tickingBlockCount = 0;
        this.tickingFluidCount = 0;
        this.specialCollidingBlocks = 0;
        this.tickingBlocks.clear();
        if (this.maybeHas(state -> !state.isAir())) {
            Int2ObjectOpenHashMap counts;
            PalettedContainer.Data data = this.states.data;
            Palette palette = data.palette();
            int paletteSize = palette.getSize();
            BitStorage storage = data.storage();
            if (paletteSize == 1) {
                counts = new Int2ObjectOpenHashMap(1);
                counts.put(0, (Object)FULL_LIST);
            } else {
                counts = storage.moonrise$countEntries();
            }
            ObjectIterator iterator = counts.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                FluidState fluid;
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                int paletteIdx = entry.getIntKey();
                IntArrayList coordinates = (IntArrayList)entry.getValue();
                int paletteCount = coordinates.size();
                BlockState state2 = (BlockState)palette.valueFor(paletteIdx);
                if (state2.isAir()) continue;
                if (CollisionUtil.isSpecialCollidingBlock(state2)) {
                    this.specialCollidingBlocks += paletteCount;
                }
                this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + paletteCount);
                if (state2.isRandomlyTicking()) {
                    this.tickingBlockCount = (short)(this.tickingBlockCount + paletteCount);
                    int[] raw = coordinates.elements();
                    Objects.checkFromToIndex(0, paletteCount, raw.length);
                    for (int i = 0; i < paletteCount; ++i) {
                        this.tickingBlocks.add(raw[i], state2);
                    }
                }
                if ((fluid = state2.getFluidState()).isEmpty() || !fluid.isRandomlyTicking()) continue;
                this.tickingFluidCount = (short)(this.tickingFluidCount + paletteCount);
            }
        }
    }

    public PalettedContainer<BlockState> getStates() {
        return this.states;
    }

    public PalettedContainerRO<Holder<Biome>> getBiomes() {
        return this.biomes;
    }

    public void read(FriendlyByteBuf buf) {
        this.nonEmptyBlockCount = buf.readShort();
        this.states.read(buf);
        PalettedContainer<Holder<Biome>> datapaletteblock = this.biomes.recreate();
        datapaletteblock.read(buf);
        this.biomes = datapaletteblock;
        this.recalcBlockCounts();
    }

    public void readBiomes(FriendlyByteBuf buf) {
        PalettedContainer<Holder<Biome>> datapaletteblock = this.biomes.recreate();
        datapaletteblock.read(buf);
        this.biomes = datapaletteblock;
    }

    @Deprecated
    @DoNotUse
    public void write(FriendlyByteBuf buf) {
        this.write(buf, null, 0);
    }

    public void write(FriendlyByteBuf buf, ChunkPacketInfo<BlockState> chunkPacketInfo, int chunkSectionIndex) {
        buf.writeShort(this.nonEmptyBlockCount);
        this.states.write(buf, chunkPacketInfo, chunkSectionIndex);
        this.biomes.write(buf, null, chunkSectionIndex);
    }

    public int getSerializedSize() {
        return 2 + this.states.getSerializedSize() + this.biomes.getSerializedSize();
    }

    public boolean maybeHas(Predicate<BlockState> predicate) {
        return this.states.maybeHas(predicate);
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        return this.biomes.get(x, y, z);
    }

    public void setBiome(int i, int j, int k, Holder<Biome> biome) {
        this.biomes.set(i, j, k, biome);
    }

    public void fillBiomesFromNoise(BiomeResolver biomeSupplier, Climate.Sampler sampler, int x, int y, int z) {
        PalettedContainer<Holder<Biome>> datapaletteblock = this.biomes.recreate();
        boolean flag = true;
        for (int l = 0; l < 4; ++l) {
            for (int i1 = 0; i1 < 4; ++i1) {
                for (int j1 = 0; j1 < 4; ++j1) {
                    datapaletteblock.getAndSetUnchecked(l, i1, j1, biomeSupplier.getNoiseBiome(x + l, y + i1, z + j1, sampler));
                }
            }
        }
        this.biomes = datapaletteblock;
    }

    static {
        for (int i = 0; i < 4096; ++i) {
            FULL_LIST.add(i);
        }
    }
}

