/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;

public class LinearPalette<T>
implements Palette<T> {
    private final IdMap<T> registry;
    private final T[] values;
    private final PaletteResize<T> resizeHandler;
    private final int bits;
    private int size;

    private LinearPalette(IdMap<T> idList, int bits, PaletteResize<T> listener, List<T> list) {
        this.registry = idList;
        this.values = new Object[1 << bits];
        this.bits = bits;
        this.resizeHandler = listener;
        Validate.isTrue((list.size() <= this.values.length ? 1 : 0) != 0, (String)"Can't initialize LinearPalette of size %d with %d entries", (Object[])new Object[]{this.values.length, list.size()});
        for (int i = 0; i < list.size(); ++i) {
            this.values[i] = list.get(i);
        }
        this.size = list.size();
    }

    private LinearPalette(IdMap<T> idList, T[] array, PaletteResize<T> listener, int indexBits, int size) {
        this.registry = idList;
        this.values = array;
        this.resizeHandler = listener;
        this.bits = indexBits;
        this.size = size;
    }

    public static <A> Palette<A> create(int bits, IdMap<A> idList, PaletteResize<A> listener, List<A> list) {
        return new LinearPalette<A>(idList, bits, listener, list);
    }

    @Override
    @Override
    public int idFor(T object) {
        int j;
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != object) continue;
            return i;
        }
        if ((j = this.size++) < this.values.length) {
            this.values[j] = object;
            return j;
        }
        return this.resizeHandler.onResize(this.bits + 1, object);
    }

    @Override
    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    @Override
    public T valueFor(int id) {
        if (id >= 0 && id < this.size) {
            return this.values[id];
        }
        throw new MissingPaletteEntryException(id);
    }

    @Override
    @Override
    public void read(FriendlyByteBuf buf) {
        this.size = buf.readVarInt();
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = this.registry.byIdOrThrow(buf.readVarInt());
        }
    }

    @Override
    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            buf.writeVarInt(this.registry.getId(this.values[i]));
        }
    }

    @Override
    @Override
    public int getSerializedSize() {
        int i = VarInt.getByteSize(this.getSize());
        for (int j = 0; j < this.getSize(); ++j) {
            i += VarInt.getByteSize(this.registry.getId(this.values[j]));
        }
        return i;
    }

    @Override
    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @Override
    public Palette<T> copy() {
        return new LinearPalette<Object>(this.registry, (Object[])this.values.clone(), this.resizeHandler, this.bits, this.size);
    }
}

