/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    public final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage = new EntityLookup();
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<ChunkLoadStatus> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> entityClass, LevelCallback<T> handler, EntityPersistentStorage<T> dataAccess) {
        this.sectionStorage = new EntitySectionStorage<T>(entityClass, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)ChunkLoadStatus.FRESH);
        this.callbacks = handler;
        this.permanentStorage = dataAccess;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    public List<Entity> getEntities(ChunkPos chunkCoordIntPair) {
        return this.sectionStorage.getExistingSectionsInChunk(chunkCoordIntPair.toLong()).flatMap(EntitySection::getEntities).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.chunkLoadStatuses.get(pair) == ChunkLoadStatus.PENDING;
    }

    void removeSectionIfEmpty(long sectionPos, EntitySection<T> section) {
        if (section.isEmpty()) {
            this.sectionStorage.remove(sectionPos);
        }
    }

    private boolean addEntityUuid(T entity) {
        AsyncCatcher.catchOp("Entity add by UUID");
        if (!this.knownUuids.add(entity.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", entity);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T entity) {
        return this.addEntity(entity, false);
    }

    private boolean addEntity(T entity, boolean existing) {
        Visibility visibility;
        AsyncCatcher.catchOp("Entity add");
        if (existing) {
            Entity entityCasted = (Entity)entity;
            boolean wasRemoved = entityCasted.isRemoved();
            boolean screened = ChunkSystem.screenEntity((ServerLevel)entityCasted.level(), entityCasted);
            if (!wasRemoved && entityCasted.isRemoved() || !screened) {
                return false;
            }
        }
        if (!this.addEntityUuid(entity)) {
            return false;
        }
        long i = SectionPos.asLong(entity.blockPosition());
        EntitySection<T> entitysection = this.sectionStorage.getOrCreateSection(i);
        entitysection.add(entity);
        entity.setLevelCallback(new Callback((EntityAccess)entity, i, entitysection));
        if (!existing) {
            this.callbacks.onCreated(entity);
        }
        if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(entity, entitysection.getStatus())).isAccessible()) {
            this.startTracking(entity);
        }
        if (visibility.isTicking()) {
            this.startTicking(entity);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T entity, Visibility current) {
        return entity.isAlwaysTicking() ? Visibility.TICKING : current;
    }

    public void addLegacyChunkEntities(Stream<T> entities) {
        entities.forEach(entityaccess -> this.addEntity(entityaccess, true));
    }

    public void addWorldGenChunkEntities(Stream<T> entities) {
        entities.forEach(entityaccess -> this.addEntity(entityaccess, false));
    }

    void startTicking(T entity) {
        AsyncCatcher.catchOp("Entity start ticking");
        this.callbacks.onTickingStart(entity);
    }

    void stopTicking(T entity) {
        AsyncCatcher.catchOp("Entity stop ticking");
        this.callbacks.onTickingEnd(entity);
    }

    void startTracking(T entity) {
        AsyncCatcher.catchOp("Entity start tracking");
        this.visibleEntityStorage.add(entity);
        this.callbacks.onTrackingStart(entity);
    }

    void stopTracking(T entity) {
        AsyncCatcher.catchOp("Entity stop tracking");
        this.callbacks.onTrackingEnd(entity);
        this.visibleEntityStorage.remove(entity);
    }

    public void updateChunkStatus(ChunkPos chunkPos, FullChunkStatus levelType) {
        Visibility visibility = Visibility.fromFullChunkStatus(levelType);
        this.updateChunkStatus(chunkPos, visibility);
    }

    public void updateChunkStatus(ChunkPos chunkPos, Visibility trackingStatus) {
        AsyncCatcher.catchOp("Update chunk status");
        long i = chunkPos.toLong();
        if (trackingStatus == Visibility.HIDDEN) {
            this.chunkVisibility.remove(i);
            this.chunksToUnload.add(i);
        } else {
            this.chunkVisibility.put(i, (Object)trackingStatus);
            this.chunksToUnload.remove(i);
            this.ensureChunkQueuedForLoad(i);
        }
        this.sectionStorage.getExistingSectionsInChunk(i).forEach(entitysection -> {
            Visibility visibility1 = entitysection.updateChunkStatus(trackingStatus);
            boolean flag = visibility1.isAccessible();
            boolean flag1 = trackingStatus.isAccessible();
            boolean flag2 = visibility1.isTicking();
            boolean flag3 = trackingStatus.isTicking();
            if (flag2 && !flag3) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if (flag && !flag1) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!flag && flag1) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!flag2 && flag3) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    public void ensureChunkQueuedForLoad(long chunkPos) {
        AsyncCatcher.catchOp("Entity chunk save");
        ChunkLoadStatus persistententitysectionmanager_b = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(chunkPos));
        if (persistententitysectionmanager_b == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(chunkPos);
        }
    }

    private boolean storeChunkSections(long chunkPos, Consumer<T> action) {
        return this.storeChunkSections(chunkPos, action, false);
    }

    private boolean storeChunkSections(long i, Consumer<T> consumer, boolean callEvent) {
        ChunkLoadStatus persistententitysectionmanager_b = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(i));
        if (persistententitysectionmanager_b == ChunkLoadStatus.PENDING) {
            return false;
        }
        List<T> list = this.sectionStorage.getExistingSectionsInChunk(i).flatMap(entitysection -> entitysection.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (persistententitysectionmanager_b == ChunkLoadStatus.LOADED) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkPos(i), (List<Entity>)ImmutableList.of());
                }
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(i), ImmutableList.of()));
            }
            return true;
        }
        if (persistententitysectionmanager_b == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(i);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkPos(i), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(i), list));
        list.forEach(consumer);
        return true;
    }

    private void requestChunkLoad(long chunkPos) {
        AsyncCatcher.catchOp("Entity chunk load request");
        this.chunkLoadStatuses.put(chunkPos, (Object)ChunkLoadStatus.PENDING);
        ChunkPos chunkcoordintpair = new ChunkPos(chunkPos);
        CompletableFuture<ChunkEntities<T>> completablefuture = this.permanentStorage.loadEntities(chunkcoordintpair);
        Queue<ChunkEntities<T>> queue = this.loadingInbox;
        Objects.requireNonNull(this.loadingInbox);
        ((CompletableFuture)completablefuture.thenAccept(queue::add)).exceptionally(throwable -> {
            LOGGER.error("Failed to read chunk {}", (Object)chunkcoordintpair, throwable);
            return null;
        });
    }

    private boolean processChunkUnload(long chunkPos) {
        AsyncCatcher.catchOp("Entity chunk unload process");
        boolean flag = this.storeChunkSections(chunkPos, entityaccess -> entityaccess.getPassengersAndSelf().forEach(this::unloadEntity), true);
        if (!flag) {
            return false;
        }
        this.chunkLoadStatuses.remove(chunkPos);
        return true;
    }

    private void unloadEntity(EntityAccess entity) {
        entity.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK, EntityRemoveEvent.Cause.UNLOAD);
        entity.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(i -> this.chunkVisibility.get(i) != Visibility.HIDDEN ? true : this.processChunkUnload(i));
    }

    private void processPendingLoads() {
        ChunkEntities<T> chunkentities;
        AsyncCatcher.catchOp("Entity chunk process pending loads");
        while ((chunkentities = this.loadingInbox.poll()) != null) {
            chunkentities.getEntities().forEach(entityaccess -> this.addEntity(entityaccess, true));
            this.chunkLoadStatuses.put(chunkentities.getPos().toLong(), (Object)ChunkLoadStatus.LOADED);
            List<Entity> entities = this.getEntities(chunkentities.getPos());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.permanentStorage).level, chunkentities.getPos(), entities);
        }
    }

    public void tick() {
        AsyncCatcher.catchOp("Entity manager tick");
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet longset = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if (entry.getValue() != ChunkLoadStatus.LOADED) continue;
            longset.add(entry.getLongKey());
        }
        return longset;
    }

    public void autoSave() {
        AsyncCatcher.catchOp("Entity manager autosave");
        this.getAllChunksToSave().forEach(i -> {
            boolean flag;
            boolean bl = flag = this.chunkVisibility.get(i) == Visibility.HIDDEN;
            if (flag) {
                this.processChunkUnload(i);
            } else {
                this.storeChunkSections(i, entityaccess -> {});
            }
        });
    }

    public void saveAll() {
        AsyncCatcher.catchOp("Entity manager save");
        LongSet longset = this.getAllChunksToSave();
        while (!longset.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            longset.removeIf(i -> {
                boolean flag = this.chunkVisibility.get(i) == Visibility.HIDDEN;
                return flag ? this.processChunkUnload(i) : this.storeChunkSections(i, entityaccess -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.saveAll();
        }
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID uuid) {
        return this.knownUuids.contains(uuid);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPos pos) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkPos.asLong(pos)))).isTicking();
    }

    public boolean canPositionTick(ChunkPos pos) {
        return ((Visibility)((Object)this.chunkVisibility.get(pos.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long chunkPos) {
        return this.chunkLoadStatuses.get(chunkPos) == ChunkLoadStatus.LOADED;
    }

    public void dumpSections(Writer writer) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(writer);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(i -> {
            ChunkLoadStatus persistententitysectionmanager_b = (ChunkLoadStatus)((Object)((Object)this.chunkLoadStatuses.get(i)));
            this.sectionStorage.getExistingSectionPositionsInChunk(i).forEach(j -> {
                EntitySection<T> entitysection = this.sectionStorage.getSection(j);
                if (entitysection != null) {
                    try {
                        csvwriter.writeRow(new Object[]{SectionPos.x(j), SectionPos.y(j), SectionPos.z(j), entitysection.getStatus(), persistententitysectionmanager_b, entitysection.size()});
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException(ioexception);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        int i = this.knownUuids.size();
        return i + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    @VisibleForDebug
    public int count() {
        return this.visibleEntityStorage.count();
    }

    private static enum ChunkLoadStatus {
        FRESH,
        PENDING,
        LOADED;

    }

    private class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;

        Callback(EntityAccess entityaccess, long i, EntitySection entitysection) {
            this.entity = entityaccess;
            this.currentSectionKey = i;
            this.currentSection = entitysection;
        }

        @Override
        public void onMove() {
            BlockPos blockposition = this.entity.blockPosition();
            long i = SectionPos.asLong(blockposition);
            if (i != this.currentSectionKey) {
                AsyncCatcher.catchOp("Entity move");
                Visibility visibility = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), i});
                }
                PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection entitysection = PersistentEntitySectionManager.this.sectionStorage.getOrCreateSection(i);
                entitysection.add(this.entity);
                this.currentSection = entitysection;
                this.currentSectionKey = i;
                this.updateStatus(visibility, entitysection.getStatus());
            }
        }

        private void updateStatus(Visibility oldStatus, Visibility newStatus) {
            Visibility visibility3;
            Visibility visibility2 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, oldStatus);
            if (visibility2 == (visibility3 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, newStatus))) {
                if (visibility3.isAccessible()) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
            } else {
                boolean flag = visibility2.isAccessible();
                boolean flag1 = visibility3.isAccessible();
                if (flag && !flag1) {
                    PersistentEntitySectionManager.this.stopTracking(this.entity);
                } else if (!flag && flag1) {
                    PersistentEntitySectionManager.this.startTracking(this.entity);
                }
                boolean flag2 = visibility2.isTicking();
                boolean flag3 = visibility3.isTicking();
                if (flag2 && !flag3) {
                    PersistentEntitySectionManager.this.stopTicking(this.entity);
                } else if (!flag2 && flag3) {
                    PersistentEntitySectionManager.this.startTicking(this.entity);
                }
                if (flag1) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason reason) {
            Visibility visibility;
            AsyncCatcher.catchOp("Entity remove");
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), reason});
            }
            if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                PersistentEntitySectionManager.this.stopTicking(this.entity);
            }
            if (visibility.isAccessible()) {
                PersistentEntitySectionManager.this.stopTracking(this.entity);
            }
            if (reason.shouldDestroy()) {
                PersistentEntitySectionManager.this.callbacks.onDestroyed(this.entity);
            }
            PersistentEntitySectionManager.this.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

