/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftGameEvent;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.GenericGameEvent;

public class GameEventDispatcher {
    private final ServerLevel level;

    public GameEventDispatcher(ServerLevel world) {
        this.level = world;
    }

    public void post(Holder<GameEvent> event, Vec3 emitterPos, GameEvent.Context emitter) {
        int i = event.value().notificationRadius();
        BlockPos blockposition = BlockPos.containing(emitterPos);
        GenericGameEvent event1 = new GenericGameEvent(CraftGameEvent.minecraftToBukkit(event.value()), CraftLocation.toBukkit(blockposition, (World)this.level.getWorld()), (Entity)(emitter.sourceEntity() == null ? null : emitter.sourceEntity().getBukkitEntity()), i, !Bukkit.isPrimaryThread());
        this.level.getCraftServer().getPluginManager().callEvent((Event)event1);
        if (event1.isCancelled()) {
            return;
        }
        i = event1.getRadius();
        int j = SectionPos.blockToSectionCoord(blockposition.getX() - i);
        int k = SectionPos.blockToSectionCoord(blockposition.getY() - i);
        int l = SectionPos.blockToSectionCoord(blockposition.getZ() - i);
        int i1 = SectionPos.blockToSectionCoord(blockposition.getX() + i);
        int j1 = SectionPos.blockToSectionCoord(blockposition.getY() + i);
        int k1 = SectionPos.blockToSectionCoord(blockposition.getZ() + i);
        ArrayList<GameEvent.ListenerInfo> list = new ArrayList<GameEvent.ListenerInfo>();
        GameEventListenerRegistry.ListenerVisitor gameeventlistenerregistry_a = (gameeventlistener, vec3d1) -> {
            if (gameeventlistener.getDeliveryMode() == GameEventListener.DeliveryMode.BY_DISTANCE) {
                list.add(new GameEvent.ListenerInfo(event, emitterPos, emitter, gameeventlistener, vec3d1));
            } else {
                gameeventlistener.handleGameEvent(this.level, event, emitter, emitterPos);
            }
        };
        boolean flag = false;
        for (int l1 = j; l1 <= i1; ++l1) {
            for (int i2 = l; i2 <= k1; ++i2) {
                LevelChunk chunk = (LevelChunk)this.level.getChunkIfLoadedImmediately(l1, i2);
                if (chunk == null) continue;
                for (int j2 = k; j2 <= j1; ++j2) {
                    flag |= chunk.getListenerRegistry(j2).visitInRangeListeners(event, emitterPos, emitter, gameeventlistenerregistry_a);
                }
            }
        }
        if (!list.isEmpty()) {
            this.handleGameEventMessagesInQueue(list);
        }
        if (flag) {
            DebugPackets.sendGameEventInfo(this.level, event, emitterPos);
        }
    }

    private void handleGameEventMessagesInQueue(List<GameEvent.ListenerInfo> messages) {
        Collections.sort(messages);
        for (GameEvent.ListenerInfo gameevent_b : messages) {
            GameEventListener gameeventlistener = gameevent_b.recipient();
            gameeventlistener.handleGameEvent(this.level, gameevent_b.gameEvent(), gameevent_b.context(), gameevent_b.source());
        }
    }
}

