/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.apache.commons.lang3.tuple.Pair;

public class VibrationSelector {
    public static final Codec<VibrationSelector> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VibrationInfo.CODEC.lenientOptionalFieldOf("event").forGetter(vibrationSelector -> vibrationSelector.currentVibrationData.map(Pair::getLeft)), (App)Codec.LONG.fieldOf("tick").forGetter(vibrationSelector -> vibrationSelector.currentVibrationData.map(Pair::getRight).orElse(-1L))).apply((Applicative)instance, VibrationSelector::new));
    private Optional<Pair<VibrationInfo, Long>> currentVibrationData;

    public VibrationSelector(Optional<VibrationInfo> vibration, long tick) {
        this.currentVibrationData = vibration.map(vibration2 -> Pair.of((Object)vibration2, (Object)tick));
    }

    public VibrationSelector() {
        this.currentVibrationData = Optional.empty();
    }

    public void addCandidate(VibrationInfo vibration, long tick) {
        if (this.shouldReplaceVibration(vibration, tick)) {
            this.currentVibrationData = Optional.of(Pair.of((Object)vibration, (Object)tick));
        }
    }

    private boolean shouldReplaceVibration(VibrationInfo vibration, long tick) {
        if (this.currentVibrationData.isEmpty()) {
            return true;
        }
        Pair<VibrationInfo, Long> pair = this.currentVibrationData.get();
        long l = (Long)pair.getRight();
        if (tick != l) {
            return false;
        }
        VibrationInfo vibrationInfo = (VibrationInfo)pair.getLeft();
        if (vibration.distance() < vibrationInfo.distance()) {
            return true;
        }
        if (vibration.distance() > vibrationInfo.distance()) {
            return false;
        }
        return VibrationSystem.getGameEventFrequency(vibration.gameEvent()) > VibrationSystem.getGameEventFrequency(vibrationInfo.gameEvent());
    }

    public Optional<VibrationInfo> chosenCandidate(long currentTick) {
        if (this.currentVibrationData.isEmpty()) {
            return Optional.empty();
        }
        if ((Long)this.currentVibrationData.get().getRight() < currentTick) {
            return Optional.of((VibrationInfo)this.currentVibrationData.get().getLeft());
        }
        return Optional.empty();
    }

    public void startOver() {
        this.currentVibrationData = Optional.empty();
    }
}

