/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;

public class NoiseChunk
implements DensityFunction.ContextProvider,
DensityFunction.FunctionContext {
    private final NoiseSettings noiseSettings;
    final int cellCountXZ;
    final int cellCountY;
    final int cellNoiseMinY;
    private final int firstCellX;
    private final int firstCellZ;
    final int firstNoiseX;
    final int firstNoiseZ;
    final List<NoiseInterpolator> interpolators;
    final List<CacheAllInCell> cellCaches;
    private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
    private final Long2IntMap preliminarySurfaceLevel = new Long2IntOpenHashMap();
    private final Aquifer aquifer;
    private final DensityFunction initialDensityNoJaggedness;
    private final BlockStateFiller blockStateRule;
    private final Blender blender;
    private final FlatCache blendAlpha;
    private final FlatCache blendOffset;
    private final DensityFunctions.BeardifierOrMarker beardifier;
    private long lastBlendingDataPos = ChunkPos.INVALID_CHUNK_POS;
    private Blender.BlendingOutput lastBlendingOutput = new Blender.BlendingOutput(1.0, 0.0);
    final int noiseSizeXZ;
    final int cellWidth;
    final int cellHeight;
    boolean interpolating;
    boolean fillingCell;
    private int cellStartBlockX;
    int cellStartBlockY;
    private int cellStartBlockZ;
    int inCellX;
    int inCellY;
    int inCellZ;
    long interpolationCounter;
    long arrayInterpolationCounter;
    int arrayIndex;
    private final DensityFunction.ContextProvider sliceFillingContextProvider = new DensityFunction.ContextProvider(){

        @Override
        @Override
        public DensityFunction.FunctionContext forIndex(int index) {
            NoiseChunk.this.cellStartBlockY = (index + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
            ++NoiseChunk.this.interpolationCounter;
            NoiseChunk.this.inCellY = 0;
            NoiseChunk.this.arrayIndex = index;
            return NoiseChunk.this;
        }

        @Override
        @Override
        public void fillAllDirectly(double[] densities, DensityFunction densityFunction) {
            for (int i = 0; i < NoiseChunk.this.cellCountY + 1; ++i) {
                NoiseChunk.this.cellStartBlockY = (i + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
                ++NoiseChunk.this.interpolationCounter;
                NoiseChunk.this.inCellY = 0;
                NoiseChunk.this.arrayIndex = i;
                densities[i] = densityFunction.compute(NoiseChunk.this);
            }
        }
    };

    public static NoiseChunk forChunk(ChunkAccess chunk, RandomState noiseConfig, DensityFunctions.BeardifierOrMarker beardifying, NoiseGeneratorSettings chunkGeneratorSettings, Aquifer.FluidPicker fluidLevelSampler, Blender blender) {
        NoiseSettings noiseSettings = chunkGeneratorSettings.noiseSettings().clampToHeightAccessor(chunk);
        ChunkPos chunkPos = chunk.getPos();
        int i = 16 / noiseSettings.getCellWidth();
        return new NoiseChunk(i, noiseConfig, chunkPos.getMinBlockX(), chunkPos.getMinBlockZ(), noiseSettings, beardifying, chunkGeneratorSettings, fluidLevelSampler, blender);
    }

    public NoiseChunk(int horizontalCellCount, RandomState noiseConfig, int startBlockX, int startBlockZ, NoiseSettings generationShapeConfig, DensityFunctions.BeardifierOrMarker beardifying, NoiseGeneratorSettings chunkGeneratorSettings, Aquifer.FluidPicker fluidLevelSampler, Blender blender) {
        this.noiseSettings = generationShapeConfig;
        this.cellWidth = generationShapeConfig.getCellWidth();
        this.cellHeight = generationShapeConfig.getCellHeight();
        this.cellCountXZ = horizontalCellCount;
        this.cellCountY = Mth.floorDiv(generationShapeConfig.height(), this.cellHeight);
        this.cellNoiseMinY = Mth.floorDiv(generationShapeConfig.minY(), this.cellHeight);
        this.firstCellX = Math.floorDiv(startBlockX, this.cellWidth);
        this.firstCellZ = Math.floorDiv(startBlockZ, this.cellWidth);
        this.interpolators = Lists.newArrayList();
        this.cellCaches = Lists.newArrayList();
        this.firstNoiseX = QuartPos.fromBlock(startBlockX);
        this.firstNoiseZ = QuartPos.fromBlock(startBlockZ);
        this.noiseSizeXZ = QuartPos.fromBlock(horizontalCellCount * this.cellWidth);
        this.blender = blender;
        this.beardifier = beardifying;
        this.blendAlpha = new FlatCache(new BlendAlpha(), false);
        this.blendOffset = new FlatCache(new BlendOffset(), false);
        for (int i = 0; i <= this.noiseSizeXZ; ++i) {
            int j = this.firstNoiseX + i;
            int k = QuartPos.toBlock(j);
            for (int l = 0; l <= this.noiseSizeXZ; ++l) {
                int m = this.firstNoiseZ + l;
                int n = QuartPos.toBlock(m);
                Blender.BlendingOutput blendingOutput = blender.blendOffsetAndFactor(k, n);
                this.blendAlpha.values[i][l] = blendingOutput.alpha();
                this.blendOffset.values[i][l] = blendingOutput.blendingOffset();
            }
        }
        NoiseRouter noiseRouter = noiseConfig.router();
        NoiseRouter noiseRouter2 = noiseRouter.mapAll(this::wrap);
        if (!chunkGeneratorSettings.isAquifersEnabled()) {
            this.aquifer = Aquifer.createDisabled(fluidLevelSampler);
        } else {
            int o = SectionPos.blockToSectionCoord(startBlockX);
            int p = SectionPos.blockToSectionCoord(startBlockZ);
            this.aquifer = Aquifer.create(this, new ChunkPos(o, p), noiseRouter2, noiseConfig.aquiferRandom(), generationShapeConfig.minY(), generationShapeConfig.height(), fluidLevelSampler);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        DensityFunction densityFunction = DensityFunctions.cacheAllInCell(DensityFunctions.add(noiseRouter2.finalDensity(), DensityFunctions.BeardifierMarker.INSTANCE)).mapAll(this::wrap);
        builder.add(pos -> this.aquifer.computeSubstance(pos, densityFunction.compute(pos)));
        if (chunkGeneratorSettings.oreVeinsEnabled()) {
            builder.add((Object)OreVeinifier.create(noiseRouter2.veinToggle(), noiseRouter2.veinRidged(), noiseRouter2.veinGap(), noiseConfig.oreRandom()));
        }
        this.blockStateRule = new MaterialRuleList((List<BlockStateFiller>)builder.build());
        this.initialDensityNoJaggedness = noiseRouter2.initialDensityWithoutJaggedness();
    }

    protected Climate.Sampler cachedClimateSampler(NoiseRouter noiseRouter, List<Climate.ParameterPoint> spawnTarget) {
        return new Climate.Sampler(noiseRouter.temperature().mapAll(this::wrap), noiseRouter.vegetation().mapAll(this::wrap), noiseRouter.continents().mapAll(this::wrap), noiseRouter.erosion().mapAll(this::wrap), noiseRouter.depth().mapAll(this::wrap), noiseRouter.ridges().mapAll(this::wrap), spawnTarget);
    }

    @Nullable
    protected BlockState getInterpolatedState() {
        return this.blockStateRule.calculate(this);
    }

    @Override
    @Override
    public int blockX() {
        return this.cellStartBlockX + this.inCellX;
    }

    @Override
    @Override
    public int blockY() {
        return this.cellStartBlockY + this.inCellY;
    }

    @Override
    @Override
    public int blockZ() {
        return this.cellStartBlockZ + this.inCellZ;
    }

    public int preliminarySurfaceLevel(int blockX, int blockZ) {
        int i = QuartPos.toBlock(QuartPos.fromBlock(blockX));
        int j = QuartPos.toBlock(QuartPos.fromBlock(blockZ));
        return this.preliminarySurfaceLevel.computeIfAbsent(ColumnPos.asLong(i, j), this::computePreliminarySurfaceLevel);
    }

    private int computePreliminarySurfaceLevel(long columnPos) {
        int i = ColumnPos.getX(columnPos);
        int j = ColumnPos.getZ(columnPos);
        int k = this.noiseSettings.minY();
        for (int l = k + this.noiseSettings.height(); l >= k; l -= this.cellHeight) {
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(i, l, j);
            if (!(this.initialDensityNoJaggedness.compute(singlePointContext) > 0.390625)) continue;
            return l;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    @Override
    public Blender getBlender() {
        return this.blender;
    }

    private void fillSlice(boolean start, int cellX) {
        this.cellStartBlockX = cellX * this.cellWidth;
        this.inCellX = 0;
        for (int i = 0; i < this.cellCountXZ + 1; ++i) {
            int j = this.firstCellZ + i;
            this.cellStartBlockZ = j * this.cellWidth;
            this.inCellZ = 0;
            ++this.arrayInterpolationCounter;
            for (NoiseInterpolator noiseInterpolator : this.interpolators) {
                double[] ds = (start ? noiseInterpolator.slice0 : noiseInterpolator.slice1)[i];
                noiseInterpolator.fillArray(ds, this.sliceFillingContextProvider);
            }
        }
        ++this.arrayInterpolationCounter;
    }

    public void initializeForFirstCellX() {
        if (this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = true;
        this.interpolationCounter = 0L;
        this.fillSlice(true, this.firstCellX);
    }

    public void advanceCellX(int cellX) {
        this.fillSlice(false, this.firstCellX + cellX + 1);
        this.cellStartBlockX = (this.firstCellX + cellX) * this.cellWidth;
    }

    @Override
    @Override
    public NoiseChunk forIndex(int i) {
        int j = Math.floorMod(i, this.cellWidth);
        int k = Math.floorDiv(i, this.cellWidth);
        int l = Math.floorMod(k, this.cellWidth);
        int m = this.cellHeight - 1 - Math.floorDiv(k, this.cellWidth);
        this.inCellX = l;
        this.inCellY = m;
        this.inCellZ = j;
        this.arrayIndex = i;
        return this;
    }

    @Override
    @Override
    public void fillAllDirectly(double[] densities, DensityFunction densityFunction) {
        this.arrayIndex = 0;
        for (int i = this.cellHeight - 1; i >= 0; --i) {
            this.inCellY = i;
            for (int j = 0; j < this.cellWidth; ++j) {
                this.inCellX = j;
                int k = 0;
                while (k < this.cellWidth) {
                    this.inCellZ = k++;
                    densities[this.arrayIndex++] = densityFunction.compute(this);
                }
            }
        }
    }

    public void selectCellYZ(int cellY, int cellZ) {
        this.interpolators.forEach(interpolator -> interpolator.selectCellYZ(cellY, cellZ));
        this.fillingCell = true;
        this.cellStartBlockY = (cellY + this.cellNoiseMinY) * this.cellHeight;
        this.cellStartBlockZ = (this.firstCellZ + cellZ) * this.cellWidth;
        ++this.arrayInterpolationCounter;
        for (CacheAllInCell cacheAllInCell : this.cellCaches) {
            cacheAllInCell.noiseFiller.fillArray(cacheAllInCell.values, this);
        }
        ++this.arrayInterpolationCounter;
        this.fillingCell = false;
    }

    public void updateForY(int blockY, double deltaY) {
        this.inCellY = blockY - this.cellStartBlockY;
        this.interpolators.forEach(interpolator -> interpolator.updateForY(deltaY));
    }

    public void updateForX(int blockX, double deltaX) {
        this.inCellX = blockX - this.cellStartBlockX;
        this.interpolators.forEach(interpolator -> interpolator.updateForX(deltaX));
    }

    public void updateForZ(int blockZ, double deltaZ) {
        this.inCellZ = blockZ - this.cellStartBlockZ;
        ++this.interpolationCounter;
        this.interpolators.forEach(interpolator -> interpolator.updateForZ(deltaZ));
    }

    public void stopInterpolation() {
        if (!this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = false;
    }

    public void swapSlices() {
        this.interpolators.forEach(NoiseInterpolator::swapSlices);
    }

    public Aquifer aquifer() {
        return this.aquifer;
    }

    protected int cellWidth() {
        return this.cellWidth;
    }

    protected int cellHeight() {
        return this.cellHeight;
    }

    Blender.BlendingOutput getOrComputeBlendingOutput(int blockX, int blockZ) {
        Blender.BlendingOutput blendingOutput;
        long l = ChunkPos.asLong(blockX, blockZ);
        if (this.lastBlendingDataPos == l) {
            return this.lastBlendingOutput;
        }
        this.lastBlendingDataPos = l;
        this.lastBlendingOutput = blendingOutput = this.blender.blendOffsetAndFactor(blockX, blockZ);
        return blendingOutput;
    }

    protected DensityFunction wrap(DensityFunction function) {
        return this.wrapped.computeIfAbsent(function, this::wrapNew);
    }

    private DensityFunction wrapNew(DensityFunction function) {
        if (function instanceof DensityFunctions.Marker) {
            DensityFunctions.Marker marker = (DensityFunctions.Marker)function;
            return switch (marker.type()) {
                default -> throw new MatchException(null, null);
                case DensityFunctions.Marker.Type.Interpolated -> new NoiseInterpolator(marker.wrapped());
                case DensityFunctions.Marker.Type.FlatCache -> new FlatCache(marker.wrapped(), true);
                case DensityFunctions.Marker.Type.Cache2D -> new Cache2D(marker.wrapped());
                case DensityFunctions.Marker.Type.CacheOnce -> new CacheOnce(marker.wrapped());
                case DensityFunctions.Marker.Type.CacheAllInCell -> new CacheAllInCell(marker.wrapped());
            };
        }
        if (this.blender != Blender.empty()) {
            if (function == DensityFunctions.BlendAlpha.INSTANCE) {
                return this.blendAlpha;
            }
            if (function == DensityFunctions.BlendOffset.INSTANCE) {
                return this.blendOffset;
            }
        }
        if (function == DensityFunctions.BeardifierMarker.INSTANCE) {
            return this.beardifier;
        }
        if (function instanceof DensityFunctions.HolderHolder) {
            DensityFunctions.HolderHolder holderHolder = (DensityFunctions.HolderHolder)function;
            return holderHolder.function().value();
        }
        return function;
    }

    @Override
    public /* synthetic */ DensityFunction.FunctionContext forIndex(int index) {
        return this.forIndex(index);
    }

    class FlatCache
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        private final DensityFunction noiseFiller;
        final double[][] values;

        FlatCache(DensityFunction delegate, boolean sample) {
            this.noiseFiller = delegate;
            this.values = new double[NoiseChunk.this.noiseSizeXZ + 1][NoiseChunk.this.noiseSizeXZ + 1];
            if (sample) {
                for (int i = 0; i <= NoiseChunk.this.noiseSizeXZ; ++i) {
                    int j = NoiseChunk.this.firstNoiseX + i;
                    int k = QuartPos.toBlock(j);
                    for (int l = 0; l <= NoiseChunk.this.noiseSizeXZ; ++l) {
                        int m = NoiseChunk.this.firstNoiseZ + l;
                        int n = QuartPos.toBlock(m);
                        this.values[i][l] = delegate.compute(new DensityFunction.SinglePointContext(k, 0, n));
                    }
                }
            }
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            int i = QuartPos.fromBlock(pos.blockX());
            int j = QuartPos.fromBlock(pos.blockZ());
            int k = i - NoiseChunk.this.firstNoiseX;
            int l = j - NoiseChunk.this.firstNoiseZ;
            int m = this.values.length;
            if (k >= 0 && l >= 0 && k < m && l < m) {
                return this.values[k][l];
            }
            return this.noiseFiller.compute(pos);
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            applier.fillAllDirectly(densities, this);
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.FlatCache;
        }
    }

    class BlendAlpha
    implements NoiseChunkDensityFunction {
        BlendAlpha() {
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.BlendAlpha.INSTANCE;
        }

        @Override
        @Override
        public DensityFunction mapAll(DensityFunction.Visitor visitor) {
            return this.wrapped().mapAll(visitor);
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            return NoiseChunk.this.getOrComputeBlendingOutput(pos.blockX(), pos.blockZ()).alpha();
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            applier.fillAllDirectly(densities, this);
        }

        @Override
        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return DensityFunctions.BlendAlpha.CODEC;
        }
    }

    class BlendOffset
    implements NoiseChunkDensityFunction {
        BlendOffset() {
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.BlendOffset.INSTANCE;
        }

        @Override
        @Override
        public DensityFunction mapAll(DensityFunction.Visitor visitor) {
            return this.wrapped().mapAll(visitor);
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            return NoiseChunk.this.getOrComputeBlendingOutput(pos.blockX(), pos.blockZ()).blendingOffset();
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            applier.fillAllDirectly(densities, this);
        }

        @Override
        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return DensityFunctions.BlendOffset.CODEC;
        }
    }

    @FunctionalInterface
    public static interface BlockStateFiller {
        @Nullable
        public BlockState calculate(DensityFunction.FunctionContext var1);
    }

    public class NoiseInterpolator
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        double[][] slice0;
        double[][] slice1;
        private final DensityFunction noiseFiller;
        private double noise000;
        private double noise001;
        private double noise100;
        private double noise101;
        private double noise010;
        private double noise011;
        private double noise110;
        private double noise111;
        private double valueXZ00;
        private double valueXZ10;
        private double valueXZ01;
        private double valueXZ11;
        private double valueZ0;
        private double valueZ1;
        private double value;

        NoiseInterpolator(DensityFunction delegate) {
            this.noiseFiller = delegate;
            this.slice0 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            this.slice1 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            NoiseChunk.this.interpolators.add(this);
        }

        private double[][] allocateSlice(int sizeZ, int sizeX) {
            int i = sizeX + 1;
            int j = sizeZ + 1;
            double[][] ds = new double[i][j];
            for (int k = 0; k < i; ++k) {
                ds[k] = new double[j];
            }
            return ds;
        }

        void selectCellYZ(int cellY, int cellZ) {
            this.noise000 = this.slice0[cellZ][cellY];
            this.noise001 = this.slice0[cellZ + 1][cellY];
            this.noise100 = this.slice1[cellZ][cellY];
            this.noise101 = this.slice1[cellZ + 1][cellY];
            this.noise010 = this.slice0[cellZ][cellY + 1];
            this.noise011 = this.slice0[cellZ + 1][cellY + 1];
            this.noise110 = this.slice1[cellZ][cellY + 1];
            this.noise111 = this.slice1[cellZ + 1][cellY + 1];
        }

        void updateForY(double deltaY) {
            this.valueXZ00 = Mth.lerp(deltaY, this.noise000, this.noise010);
            this.valueXZ10 = Mth.lerp(deltaY, this.noise100, this.noise110);
            this.valueXZ01 = Mth.lerp(deltaY, this.noise001, this.noise011);
            this.valueXZ11 = Mth.lerp(deltaY, this.noise101, this.noise111);
        }

        void updateForX(double deltaX) {
            this.valueZ0 = Mth.lerp(deltaX, this.valueXZ00, this.valueXZ10);
            this.valueZ1 = Mth.lerp(deltaX, this.valueXZ01, this.valueXZ11);
        }

        void updateForZ(double deltaZ) {
            this.value = Mth.lerp(deltaZ, this.valueZ0, this.valueZ1);
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            if (pos != NoiseChunk.this) {
                return this.noiseFiller.compute(pos);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            if (NoiseChunk.this.fillingCell) {
                return Mth.lerp3((double)NoiseChunk.this.inCellX / (double)NoiseChunk.this.cellWidth, (double)NoiseChunk.this.inCellY / (double)NoiseChunk.this.cellHeight, (double)NoiseChunk.this.inCellZ / (double)NoiseChunk.this.cellWidth, this.noise000, this.noise100, this.noise010, this.noise110, this.noise001, this.noise101, this.noise011, this.noise111);
            }
            return this.value;
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            if (NoiseChunk.this.fillingCell) {
                applier.fillAllDirectly(densities, this);
                return;
            }
            this.wrapped().fillArray(densities, applier);
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        private void swapSlices() {
            double[][] ds = this.slice0;
            this.slice0 = this.slice1;
            this.slice1 = ds;
        }

        @Override
        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.Interpolated;
        }
    }

    class CacheAllInCell
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        final DensityFunction noiseFiller;
        final double[] values;

        CacheAllInCell(DensityFunction delegate) {
            this.noiseFiller = delegate;
            this.values = new double[NoiseChunk.this.cellWidth * NoiseChunk.this.cellWidth * NoiseChunk.this.cellHeight];
            NoiseChunk.this.cellCaches.add(this);
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            if (pos != NoiseChunk.this) {
                return this.noiseFiller.compute(pos);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            int i = NoiseChunk.this.inCellX;
            int j = NoiseChunk.this.inCellY;
            int k = NoiseChunk.this.inCellZ;
            if (i >= 0 && j >= 0 && k >= 0 && i < NoiseChunk.this.cellWidth && j < NoiseChunk.this.cellHeight && k < NoiseChunk.this.cellWidth) {
                return this.values[((NoiseChunk.this.cellHeight - 1 - j) * NoiseChunk.this.cellWidth + i) * NoiseChunk.this.cellWidth + k];
            }
            return this.noiseFiller.compute(pos);
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            applier.fillAllDirectly(densities, this);
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.CacheAllInCell;
        }
    }

    static class Cache2D
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        private final DensityFunction function;
        private long lastPos2D = ChunkPos.INVALID_CHUNK_POS;
        private double lastValue;

        Cache2D(DensityFunction delegate) {
            this.function = delegate;
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            double d;
            int j;
            int i = pos.blockX();
            long l = ChunkPos.asLong(i, j = pos.blockZ());
            if (this.lastPos2D == l) {
                return this.lastValue;
            }
            this.lastPos2D = l;
            this.lastValue = d = this.function.compute(pos);
            return d;
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            this.function.fillArray(densities, applier);
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.Cache2D;
        }
    }

    class CacheOnce
    implements DensityFunctions.MarkerOrMarked,
    NoiseChunkDensityFunction {
        private final DensityFunction function;
        private long lastCounter;
        private long lastArrayCounter;
        private double lastValue;
        @Nullable
        private double[] lastArray;

        CacheOnce(DensityFunction delegate) {
            this.function = delegate;
        }

        @Override
        @Override
        public double compute(DensityFunction.FunctionContext pos) {
            double d;
            if (pos != NoiseChunk.this) {
                return this.function.compute(pos);
            }
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                return this.lastArray[NoiseChunk.this.arrayIndex];
            }
            if (this.lastCounter == NoiseChunk.this.interpolationCounter) {
                return this.lastValue;
            }
            this.lastCounter = NoiseChunk.this.interpolationCounter;
            this.lastValue = d = this.function.compute(pos);
            return d;
        }

        @Override
        @Override
        public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                System.arraycopy(this.lastArray, 0, densities, 0, densities.length);
                return;
            }
            this.wrapped().fillArray(densities, applier);
            if (this.lastArray != null && this.lastArray.length == densities.length) {
                System.arraycopy(densities, 0, this.lastArray, 0, densities.length);
            } else {
                this.lastArray = (double[])densities.clone();
            }
            this.lastArrayCounter = NoiseChunk.this.arrayInterpolationCounter;
        }

        @Override
        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        @Override
        public DensityFunctions.Marker.Type type() {
            return DensityFunctions.Marker.Type.CacheOnce;
        }
    }

    static interface NoiseChunkDensityFunction
    extends DensityFunction {
        public DensityFunction wrapped();

        @Override
        @Override
        default public double minValue() {
            return this.wrapped().minValue();
        }

        @Override
        @Override
        default public double maxValue() {
            return this.wrapped().maxValue();
        }
    }
}

